//#define _XOPEN_SOURCE 600
#define _LARGEFILE64_SOURCE 1
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

#include "falloc.h"
#include "fallocate_internal.h"

/* Magic for ocfs2 and xfs, where we do the ioctl thing */
#define OCFS2_SUPER_MAGIC 0x7461636f
#define XFS_SUPER_MAGIC	  0x58465342

int fallocate64_xfs_ocfs2(int fd, int mode, __off64_t start, 
			  __off64_t len, const struct stat64 *stbuf)
{
	int err = -1;
	struct space_resv sr;
	/* Test for ocfs2 / XFS */
	struct statfs sfbuf;
	if (fstatfs(fd, &sfbuf))
		return -1;
	if (sfbuf.f_type != OCFS2_SUPER_MAGIC &&
	    sfbuf.f_type != XFS_SUPER_MAGIC) {
		errno = EOPNOTSUPP;
		return -1;
	}
	memset(&sr, 0, sizeof(sr));
	sr.l_whence = SEEK_SET;
	sr.l_start = start;
	sr.l_len = len;
	err = ioctl(fd, mode == (int)FALLOC_FL_UNRESV? 
		    FS_IOC_UNRESVSP64: FS_IOC_RESVSP64, &sr);
	/* errno will be ENOTTY if this is not supported, translate */
	if (err && errno == ENOTTY)
		errno = EOPNOTSUPP;
	if (!err && mode == FALLOC_FL_ADJUST_SIZE)
		fallocate64_sparse(fd, mode, start, len, stbuf);
	return err;
}

