/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.preproc.Defines;
import org.asciidoctor.diagram.DiagramGenerator;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;

class PlantUML
implements DiagramGenerator {
    public static final MimeType DEFAULT_OUTPUT_FORMAT = MimeType.PNG;

    PlantUML() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponseData generate(Request request) throws IOException {
        FileFormat fileFormat;
        MimeType format;
        File graphviz;
        String pathToGraphViz = request.headers.getValue("X-Graphviz");
        if (pathToGraphViz != null) {
            File graphvizParam = new File(pathToGraphViz);
            if (!graphvizParam.canExecute()) throw new IOException("GraphViz 'dot' tool at '" + pathToGraphViz + "' is not executable");
            graphviz = graphvizParam;
        } else {
            graphviz = null;
        }
        if ((format = request.headers.getValue(HTTPHeader.ACCEPT)) == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (format.equals(MimeType.PNG)) {
            fileFormat = FileFormat.PNG;
        } else if (format.equals(MimeType.SVG)) {
            fileFormat = FileFormat.SVG;
        } else if (format.equals(MimeType.TEXT_PLAIN_UTF8)) {
            fileFormat = FileFormat.UTXT;
        } else {
            if (!format.equals(MimeType.TEXT_PLAIN_ASCII)) throw new IOException("Unsupported output format: " + format);
            fileFormat = FileFormat.ATXT;
        }
        Option option = new Option();
        String plantUmlConfig = request.headers.getValue("X-PlantUML-Config");
        if (plantUmlConfig != null) {
            option.initConfig(plantUmlConfig);
        }
        option.setFileFormat(fileFormat);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PlantUML plantUML = this;
        synchronized (plantUML) {
            OptionFlags.getInstance().setDotExecutable(graphviz != null ? graphviz.getAbsolutePath() : null);
            new SourceStringReader(new Defines(), request.asString(), option.getConfig()).generateImage((OutputStream)byteArrayOutputStream, option.getFileFormatOption());
            return new ResponseData(format, byteArrayOutputStream.toByteArray());
        }
    }
}

