/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.asciidoctor.diagram.CommandProcessor;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.HTTPInputStream;
import org.asciidoctor.diagram.HTTPOutputStream;
import org.asciidoctor.diagram.Request;

public class CommandServer {
    private final ServerSocket serverSocket;
    private CommandProcessor processor;

    public static void main(String[] args) throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        System.out.println(serverSocket.getLocalPort());
        System.out.flush();
        CommandServer server = new CommandServer(serverSocket);
        server.processRequests();
        server.terminate();
    }

    public CommandServer(ServerSocket socket) {
        this.serverSocket = socket;
        this.processor = new CommandProcessor();
    }

    public void processRequests() throws IOException {
        while (!this.serverSocket.isClosed()) {
            Request request;
            Socket client = this.serverSocket.accept();
            HTTPInputStream input = new HTTPInputStream(client.getInputStream());
            HTTPOutputStream output = new HTTPOutputStream(client.getOutputStream());
            while ((request = input.readRequest()) != null) {
                output.writeResponse(this.processor.processRequest(request));
                if (!"close".equals(request.headers.getValue(HTTPHeader.CONNECTION))) continue;
            }
            client.close();
        }
    }

    public void terminate() throws IOException {
        this.serverSocket.close();
    }
}

