/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.asciidoctor.diagram.Charsets;
import org.asciidoctor.diagram.DiagramGenerator;
import org.asciidoctor.diagram.Ditaa;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.HTTPHeaders;
import org.asciidoctor.diagram.HTTPInputStream;
import org.asciidoctor.diagram.HTTPOutputStream;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.PlantUML;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.Response;
import org.asciidoctor.diagram.ResponseData;

public class CommandProcessor {
    public byte[] processRequest(byte[] request) throws IOException {
        Request req = new HTTPInputStream(new ByteArrayInputStream(request)).readRequest();
        Response response = this.processRequest(req);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new HTTPOutputStream(out).writeResponse(response);
        out.close();
        return out.toByteArray();
    }

    public Response processRequest(Request request) {
        try {
            DiagramGenerator generator;
            String requestPath = request.requestUri.getPath();
            if (requestPath.equalsIgnoreCase("/plantuml")) {
                generator = new PlantUML();
            } else if (requestPath.equalsIgnoreCase("/ditaa")) {
                generator = new Ditaa();
            } else {
                return this.createErrorResponse(404, new IllegalArgumentException("Invalid path '" + requestPath + "'"));
            }
            ResponseData result = generator.generate(request);
            HTTPHeaders headers = new HTTPHeaders();
            headers.putValue(HTTPHeader.CONTENT_LENGTH, result.data.length);
            headers.putValue(HTTPHeader.CONTENT_TYPE, result.format);
            return new Response(200, headers, result.data);
        }
        catch (IOException e) {
            return this.createErrorResponse(400, e);
        }
        catch (RuntimeException e) {
            return this.createErrorResponse(500, e);
        }
    }

    private Response createErrorResponse(int code, Exception e) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        p.write("{\"msg\":");
        this.writeJSONString(p, e.getMessage());
        p.write(",\"stk\":[");
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement elem = stackTrace[i];
            if (i > 0) {
                p.write(",");
            }
            p.write(91);
            this.writeJSONString(p, elem.getFileName());
            p.write(44);
            this.writeJSONString(p, elem.getClassName());
            p.write(44);
            this.writeJSONString(p, elem.getMethodName());
            p.write(44);
            p.write(Integer.toString(elem.getLineNumber()));
            p.write(93);
        }
        p.write("]}");
        p.flush();
        p.close();
        byte[] bytes = s.toString().getBytes(Charsets.UTF8);
        HTTPHeaders headers = new HTTPHeaders();
        headers.putValue(HTTPHeader.CONTENT_TYPE, MimeType.JSON_UTF8);
        headers.putValue(HTTPHeader.CONTENT_LENGTH, bytes.length);
        return new Response(code, headers, bytes);
    }

    private void writeJSONString(PrintWriter p, String message) {
        if (message == null) {
            p.write("null");
            return;
        }
        p.write(34);
        block9: for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '\"': {
                    p.print("\\\"");
                    continue block9;
                }
                case '\\': {
                    p.print("\\\\");
                    continue block9;
                }
                case '\b': {
                    p.print("\\b");
                    continue block9;
                }
                case '\f': {
                    p.print("\\f");
                    continue block9;
                }
                case '\n': {
                    p.print("\\n");
                    continue block9;
                }
                case '\r': {
                    p.print("\\r");
                    continue block9;
                }
                case '\t': {
                    p.print("\\t");
                    continue block9;
                }
                default: {
                    p.write(c);
                }
            }
        }
        p.write(34);
    }
}

