/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParamForecolored;
import net.sourceforge.plantuml.SkinParamSameClassWidth;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2InternalImage;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EntityImageProtected;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekResult;
import net.sourceforge.plantuml.svek.image.EntityImageActivity;
import net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.image.EntityImageBranch;
import net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage2;
import net.sourceforge.plantuml.svek.image.EntityImageGroup;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageObject;
import net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageState2;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.image.EntityImageTips;
import net.sourceforge.plantuml.svek.image.EntityImageUseCase;

public final class CucaDiagramFileMakerSvek2 {
    private final ColorSequence colorSequence = new ColorSequence();
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final UmlSource source;
    private final Pragma pragma;
    private static final StringBounder stringBounder;
    private DotStringFactory dotStringFactory;

    public CucaDiagramFileMakerSvek2(DotData dotData, EntityFactory entityFactory, UmlSource source, Pragma pragma) {
        this.dotData = dotData;
        this.entityFactory = entityFactory;
        this.source = source;
        this.pragma = pragma;
    }

    public Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    public IEntityImage createFileForConcurrentState() {
        return new CucaDiagramFileMakerSvek2InternalImage(this.dotData.getLeafs(), this.dotData.getTopParent().getConcurrentSeparator(), this.dotData.getSkinParam(), this.dotData.getSkinParam().getBackgroundColor());
    }

    public IEntityImage createFile(String ... dotStrings) {
        String svg;
        this.dotData.removeIrrelevantSametail();
        this.dotStringFactory = new DotStringFactory(this.colorSequence, stringBounder, this.dotData);
        this.printGroups(this.dotData.getRootGroup());
        this.printEntities(this.getUnpackagedEntities());
        for (Link link : this.dotData.getLinks()) {
            if (link.isRemoved()) continue;
            try {
                Shape shape;
                String shapeUid1 = this.getBibliotekon().getShapeUid((ILeaf)link.getEntity1());
                String shapeUid2 = this.getBibliotekon().getShapeUid((ILeaf)link.getEntity2());
                String ltail = null;
                if (shapeUid1.startsWith("za")) {
                    ltail = this.getCluster2(link.getEntity1()).getClusterId();
                }
                String lhead = null;
                if (shapeUid2.startsWith("za")) {
                    lhead = this.getCluster2(link.getEntity2()).getClusterId();
                }
                ISkinParam skinParam = this.dotData.getSkinParam();
                FontConfiguration labelFont = new FontConfiguration(skinParam.getFont(FontParam.GENERIC_ARROW, null, false), skinParam.getFontHtmlColor(FontParam.GENERIC_ARROW, null), skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
                Line line = new Line(shapeUid1, shapeUid2, link, this.colorSequence, ltail, lhead, skinParam, stringBounder, labelFont, this.getBibliotekon(), this.dotStringFactory.getGraphvizVersion(), this.dotData.getPragma());
                this.getBibliotekon().addLine(line);
                if (!link.getEntity1().isGroup() && link.getEntity1().getEntityType() == LeafType.NOTE && this.onlyOneLink(link.getEntity1())) {
                    shape = this.getBibliotekon().getShape(link.getEntity1());
                    ((EntityImageNote)shape.getImage()).setOpaleLine(line, shape);
                    line.setOpale(true);
                    continue;
                }
                if (link.getEntity2().isGroup() || link.getEntity2().getEntityType() != LeafType.NOTE || !this.onlyOneLink(link.getEntity2())) continue;
                shape = this.getBibliotekon().getShape(link.getEntity2());
                ((EntityImageNote)shape.getImage()).setOpaleLine(line, shape);
                line.setOpale(true);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        if (this.dotStringFactory.illegalDotExe()) {
            return this.error(this.dotStringFactory.getDotExe());
        }
        boolean trace = OptionFlags.getInstance().isKeepTmpFiles() || this.isSvekTrace();
        try {
            svg = this.dotStringFactory.getSvg(trace, dotStrings);
        }
        catch (IOException e) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        if (svg.length() == 0) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        String graphvizVersion = this.extractGraphvizVersion(svg);
        try {
            ClusterPosition position = this.dotStringFactory.solve(svg).delta(10.0, 10.0);
            double minY = position.getMinY();
            double minX = position.getMinX();
            if (minX > 0.0 || minY > 0.0) {
                throw new IllegalStateException();
            }
            SvekResult result = new SvekResult(position, this.dotData, this.dotStringFactory);
            result.moveSvek(6.0 - minX, -minY);
            return result;
        }
        catch (Exception e) {
            Log.error("Exception " + e);
            throw new UnparsableGraphvizException(e, graphvizVersion, svg, this.source.getPlainString());
        }
    }

    private boolean isSvekTrace() {
        String value = this.pragma.getValue("svek_trace");
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    private String extractGraphvizVersion(String svg) {
        Pattern pGraph = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher mGraph = pGraph.matcher(svg);
        if (mGraph.find()) {
            return StringUtils.trin(mGraph.group(1));
        }
        return null;
    }

    private boolean onlyOneLink(IEntity ent) {
        int nb = 0;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis()) continue;
            if (link.contains(ent)) {
                ++nb;
            }
            if (nb <= 1) continue;
            return false;
        }
        return nb == 1;
    }

    private Cluster getCluster2(IEntity entityMutable) {
        for (Cluster cl : this.getBibliotekon().allCluster()) {
            if (entityMutable != cl.getGroup()) continue;
            return cl;
        }
        throw new IllegalArgumentException();
    }

    private IEntityImage error(File dotExe) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Dot Executable: " + dotExe);
        if (dotExe != null) {
            if (!dotExe.exists()) {
                msg.add("File does not exist");
            } else if (dotExe.isDirectory()) {
                msg.add("It should be an executable, not a directory");
            } else if (!dotExe.isFile()) {
                msg.add("Not a valid file");
            } else if (!dotExe.canRead()) {
                msg.add("File cannot be read");
            }
        }
        msg.add("Cannot find Graphviz. You should try");
        msg.add(" ");
        msg.add("@startuml");
        msg.add("testdot");
        msg.add("@enduml");
        msg.add(" ");
        msg.add(" or ");
        msg.add(" ");
        msg.add("java -jar plantuml.jar -testdot");
        msg.add(" ");
        return GraphicStrings.createDefault(msg, false);
    }

    private void printEntities(Collection<ILeaf> entities2) {
        for (ILeaf ent : entities2) {
            if (ent.isRemoved()) continue;
            this.printEntity(ent);
        }
    }

    private void printEntity(ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(ent);
        Dimension2D dim = image.calculateDimension(stringBounder);
        Shape shape = new Shape(image, image.getShapeType(), dim.getWidth(), dim.getHeight(), this.colorSequence, ent.isTop(), image.getShield(), ent.getEntityPosition());
        this.dotStringFactory.addShape(shape);
        this.getBibliotekon().putShape(ent, shape);
    }

    private IEntityImage printEntityInternal(ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.dotData.getSkinParam();
            if (this.dotData.getSkinParam().sameClassWidth()) {
                double width = this.getMaxWidth();
                skinParam = new SkinParamSameClassWidth(this.dotData.getSkinParam(), width);
            }
            return CucaDiagramFileMakerSvek2.createEntityImageBlock(ent, skinParam, this.dotData.isHideEmptyDescriptionForState(), this.dotData, this.getBibliotekon(), this.dotStringFactory.getGraphvizVersion(), this.dotData.getUmlDiagramType());
        }
        return ent.getSvekImage();
    }

    private double getMaxWidth() {
        double result = 0.0;
        for (ILeaf ent : this.dotData.getLeafs()) {
            EntityImageClass im;
            double w;
            if (!ent.getEntityType().isLikeClass() || !((w = (im = new EntityImageClass(this.dotStringFactory.getGraphvizVersion(), ent, this.dotData.getSkinParam(), this.dotData)).calculateDimension(stringBounder).getWidth()) > result)) continue;
            result = w;
        }
        return result;
    }

    public static IEntityImage createEntityImageBlock(ILeaf leaf, ISkinParam skinParam, boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType) {
        if (leaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (leaf.getEntityType().isLikeClass()) {
            EntityImageClass entityImageClass = new EntityImageClass(graphvizVersion, leaf, skinParam, portionShower);
            Neighborhood neighborhood = leaf.getNeighborhood();
            if (neighborhood != null) {
                return new EntityImageProtected(entityImageClass, 20.0, neighborhood, bibliotekon);
            }
            return entityImageClass;
        }
        if (leaf.getEntityType() == LeafType.NOTE) {
            return new EntityImageNote(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(leaf, skinParam, bibliotekon);
        }
        if (leaf.getEntityType() == LeafType.STATE) {
            if (leaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster stateParent = bibliotekon.getCluster(leaf.getParentContainer());
                return new EntityImageStateBorder(leaf, skinParam, stateParent, bibliotekon);
            }
            if (isHideEmptyDescriptionForState && leaf.getBodier().getFieldsToDisplay().size() == 0) {
                return new EntityImageStateEmptyDescription(leaf, skinParam);
            }
            if (leaf.getStereotype() != null && "<<sdlreceive>>".equals(leaf.getStereotype().getLabel(false))) {
                return new EntityImageState2(leaf, skinParam);
            }
            return new EntityImageState(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.CIRCLE_START) {
            ColorParam param = ColorParam.activityStart;
            if (umlDiagramType == UmlDiagramType.STATE) {
                param = ColorParam.stateStart;
            }
            return new EntityImageCircleStart(leaf, skinParam, param);
        }
        if (leaf.getEntityType() == LeafType.CIRCLE_END) {
            ColorParam param = ColorParam.activityEnd;
            if (umlDiagramType == UmlDiagramType.STATE) {
                param = ColorParam.stateEnd;
            }
            return new EntityImageCircleEnd(leaf, skinParam, param);
        }
        if (leaf.getEntityType() == LeafType.BRANCH || leaf.getEntityType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.LOLLIPOP) {
            return new EntityImageLollipopInterface(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.DESCRIPTION) {
            return new EntityImageDescription(leaf, skinParam, portionShower);
        }
        if (leaf.getEntityType() == LeafType.USECASE) {
            return new EntityImageUseCase(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.OBJECT) {
            return new EntityImageObject(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.SYNCHRO_BAR || leaf.getEntityType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(leaf, skinParam);
        }
        if (leaf.isGroup()) {
            return new EntityImageGroup(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.EMPTY_PACKAGE) {
            if (leaf.getUSymbol() != null) {
                return new EntityImageDescription(leaf, new SkinParamForecolored(skinParam, HtmlColorUtils.BLACK), portionShower);
            }
            return new EntityImageEmptyPackage2(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(leaf, skinParam);
        }
        if (leaf.getEntityType() == LeafType.TIPS) {
            return new EntityImageTips(leaf, skinParam, bibliotekon);
        }
        throw new UnsupportedOperationException(leaf.getEntityType().toString());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printGroups(IGroup parent) {
        for (IGroup g : this.dotData.getGroupHierarchy().getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.dotData.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                ILeaf folder = this.entityFactory.createLeaf(g.getCode(), g.getDisplay(), LeafType.EMPTY_PACKAGE, g.getParentContainer(), null, this.dotData.getNamespaceSeparator());
                USymbol symbol = g.getUSymbol();
                folder.setUSymbol(symbol);
                if (g.getSpecificBackColor() == null) {
                    ColorParam param = symbol == null ? ColorParam.packageBackground : symbol.getColorParamBack();
                    HtmlColor c1 = this.dotData.getSkinParam().getHtmlColor(param, g.getStereotype(), false);
                    folder.setSpecificBackcolor(c1 == null ? this.dotData.getSkinParam().getBackgroundColor() : c1);
                } else {
                    folder.setSpecificBackcolor(g.getSpecificBackColor());
                }
                this.printEntity(folder);
                continue;
            }
            this.printGroup(g);
        }
    }

    private void printGroup(IGroup g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int titleAndAttributeWidth = 0;
        int titleAndAttributeHeight = 0;
        TextBlock title = this.getTitleBlock(g);
        TextBlock stereo = this.getStereoBlock(g);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(stereo, title, HorizontalAlignment.CENTER);
        Dimension2D dimLabel = stereoAndTitle.calculateDimension(stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            List<Member> members = g.getBodier().getFieldsToDisplay();
            AbstractTextBlock attribute = members.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(members, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam());
            Dimension2D dimAttribute = attribute.calculateDimension(stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
        this.dotStringFactory.openCluster(g, titleAndAttributeWidth, titleAndAttributeHeight, title, stereo);
        this.printEntities(g.getLeafsDirect());
        this.printGroups(g);
        this.dotStringFactory.closeCluster();
    }

    private TextBlock getTitleBlock(IGroup g) {
        Display label = g.getDisplay();
        Stereotype stereotype2 = g.getStereotype();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = g.getTitleFontParam();
        return label.create(new FontConfiguration(this.dotData.getSkinParam().getFont(fontParam, stereotype2, true), this.dotData.getSkinParam().getFontHtmlColor(fontParam, stereotype2), this.dotData.getSkinParam().getHyperlinkColor(), this.dotData.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    private TextBlock getStereoBlock(IGroup g) {
        if (g.getStereotype() == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        List<String> stereos = g.getStereotype().getLabels(this.dotData.getSkinParam().useGuillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean show = this.dotData.showPortion(EntityPortion.STEREOTYPE, g);
        if (!show) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Stereotype stereotype2 = g.getStereotype();
        FontParam fontParam = FontParam.COMPONENT_STEREOTYPE;
        return Display.create(stereos).create(new FontConfiguration(this.dotData.getSkinParam().getFont(fontParam, stereotype2, false), this.dotData.getSkinParam().getFontHtmlColor(fontParam, stereotype2), this.dotData.getSkinParam().getHyperlinkColor(), this.dotData.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    static {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(builder.getGraphics2D());
    }
}

