/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.FrontierCalculator;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapePseudoImpl;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class Cluster
implements Moveable {
    private final Cluster parent;
    private final IGroup group;
    private final List<Shape> shapes = new ArrayList<Shape>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final ISkinParam skinParam;
    private int titleAndAttributeWidth;
    private int titleAndAttributeHeight;
    private TextBlock ztitle;
    private TextBlock zstereo;
    private double xTitle;
    private double yTitle;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private ColorParam border;
    public static final String CENTER_ID = "za";

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.xTitle += deltaX;
        this.minX += deltaX;
        this.maxX += deltaX;
        this.yTitle += deltaY;
        this.minY += deltaY;
        this.maxY += deltaY;
    }

    private boolean hasEntryOrExitPoint() {
        for (Shape sh : this.shapes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            return true;
        }
        return false;
    }

    public Cluster(ColorSequence colorSequence, ISkinParam skinParam, IGroup root) {
        this(null, root, colorSequence, skinParam);
    }

    private Cluster(Cluster parent, IGroup group, ColorSequence colorSequence, ISkinParam skinParam) {
        if (group == null) {
            throw new IllegalStateException();
        }
        this.parent = parent;
        this.group = group;
        if (group.getUSymbol() != null) {
            this.border = group.getUSymbol().getColorParamBorder();
        }
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.skinParam = skinParam;
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParent() {
        return this.parent;
    }

    public void addShape(Shape sh) {
        if (sh == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(sh);
        sh.setCluster(this);
    }

    public final List<Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    private List<Shape> getShapesOrderedTop(Collection<Line> lines) {
        ArrayList<Shape> firsts = new ArrayList<Shape>();
        HashSet<String> tops = new HashSet<String>();
        HashMap<String, Shape> shs = new HashMap<String, Shape>();
        for (Shape sh : this.shapes) {
            shs.put(sh.getUid(), sh);
            if (!sh.isTop() || sh.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(sh);
            tops.add(sh.getUid());
        }
        for (Line l : lines) {
            Shape sh;
            if (tops.contains(l.getStartUid()) && (sh = (Shape)shs.get(l.getEndUid())) != null && sh.getEntityPosition() == EntityPosition.NORMAL) {
                firsts.add(0, sh);
            }
            if (!l.isInverted() || (sh = (Shape)shs.get(l.getStartUid())) == null || sh.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(0, sh);
        }
        return firsts;
    }

    private List<Shape> getShapesEntryExit(EntityPosition position) {
        ArrayList<Shape> result = new ArrayList<Shape>();
        for (Shape sh : this.shapes) {
            if (sh.getEntityPosition() != position) continue;
            result.add(sh);
        }
        return result;
    }

    private List<Shape> getShapesOrderedWithoutTop(Collection<Line> lines) {
        ArrayList<Shape> all = new ArrayList<Shape>(this.shapes);
        HashSet<String> tops = new HashSet<String>();
        HashMap<String, Shape> shs = new HashMap<String, Shape>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            Shape sh = (Shape)it.next();
            if (sh.getEntityPosition() != EntityPosition.NORMAL) {
                it.remove();
                continue;
            }
            shs.put(sh.getUid(), sh);
            if (!sh.isTop()) continue;
            tops.add(sh.getUid());
            it.remove();
        }
        for (Line l : lines) {
            Shape sh;
            if (tops.contains(l.getStartUid()) && (sh = (Shape)shs.get(l.getEndUid())) != null) {
                all.remove(sh);
            }
            if (!l.isInverted() || (sh = (Shape)shs.get(l.getStartUid())) == null) continue;
            all.remove(sh);
        }
        return all;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(IGroup g, int titleAndAttributeWidth, int titleAndAttributeHeight, TextBlock title, TextBlock stereo, ColorSequence colorSequence, ISkinParam skinParam) {
        Cluster child = new Cluster(this, g, colorSequence, skinParam);
        child.titleAndAttributeWidth = titleAndAttributeWidth;
        child.titleAndAttributeHeight = titleAndAttributeHeight;
        child.ztitle = title;
        child.zstereo = stereo;
        this.children.add(child);
        return child;
    }

    public final IGroup getGroup() {
        return this.group;
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void setTitlePosition(double x, double y) {
        this.xTitle = x;
        this.yTitle = y;
    }

    private static HtmlColor getColor(ColorParam colorParam, ISkinParam skinParam) {
        return new Rose().getHtmlColor(skinParam, colorParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, DotData dotData, UStroke stroke) {
        HtmlColor borderColor = dotData.getUmlDiagramType() == UmlDiagramType.STATE ? Cluster.getColor(ColorParam.stateBorder, dotData.getSkinParam()) : Cluster.getColor(ColorParam.packageBorder, dotData.getSkinParam());
        Url url = this.group.getUrl99();
        if (url != null) {
            ug.startUrl(url);
        }
        try {
            HtmlColor tmp;
            boolean isState;
            if (this.hasEntryOrExitPoint()) {
                this.manageEntryExitPoint(dotData, ug.getStringBounder());
            }
            if (this.skinParam.useSwimlanes(dotData.getUmlDiagramType())) {
                this.drawSwinLinesState(ug, borderColor, dotData);
                return;
            }
            boolean bl = isState = dotData.getUmlDiagramType() == UmlDiagramType.STATE;
            if (isState) {
                if (this.group.getSpecificLineStroke() != null) {
                    stroke = this.group.getSpecificLineStroke();
                }
                if (this.group.getSpecificLineColor() != null) {
                    borderColor = this.group.getSpecificLineColor();
                }
                this.drawUState(ug, borderColor, dotData, stroke);
                return;
            }
            PackageStyle style = this.group.getPackageStyle();
            if (style == null) {
                style = dotData.getSkinParam().getPackageStyle();
            }
            if (this.border != null && (tmp = dotData.getSkinParam().getHtmlColor(this.border, null, false)) != null) {
                borderColor = tmp;
            }
            if (this.ztitle != null || this.zstereo != null) {
                HtmlColor stateBack = Cluster.getStateBackColor(this.getBackColor(), dotData.getSkinParam(), this.group.getStereotype());
                ClusterDecoration decoration = new ClusterDecoration(style, this.group.getUSymbol(), this.ztitle, this.zstereo, stateBack, this.minX, this.minY, this.maxX, this.maxY, this.getStroke(dotData.getSkinParam(), this.group.getStereotype()));
                decoration.drawU(ug, borderColor, dotData.getSkinParam().shadowing());
                return;
            }
            URectangle rect = new URectangle(this.maxX - this.minX, this.maxY - this.minY);
            if (dotData.getSkinParam().shadowing()) {
                rect.setDeltaShadow(3.0);
            }
            HtmlColor stateBack = Cluster.getStateBackColor(this.getBackColor(), dotData.getSkinParam(), this.group.getStereotype());
            ug = ug.apply(new UChangeBackColor(stateBack)).apply(new UChangeColor(borderColor));
            ug.apply(new UStroke(2.0)).apply(new UTranslate(this.minX, this.minY)).draw(rect);
        }
        finally {
            if (url != null) {
                ug.closeAction();
            }
        }
    }

    private UStroke getStroke(ISkinParam skinParam, Stereotype stereo) {
        UStroke stroke = skinParam.getThickness(LineParam.packageBorder, stereo);
        if (stroke == null) {
            stroke = new UStroke(2.0);
        }
        return stroke;
    }

    private void manageEntryExitPoint(DotData dotData, StringBounder stringBounder) {
        ArrayList<ClusterPosition> insides = new ArrayList<ClusterPosition>();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Shape sh : this.shapes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) {
                insides.add(sh.getClusterPosition());
                continue;
            }
            points.add(sh.getClusterPosition().getPointCenter());
        }
        for (Cluster in : this.children) {
            insides.add(in.getClusterPosition());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getClusterPosition(), insides, points);
        if (this.titleAndAttributeHeight > 0 && this.titleAndAttributeWidth > 0) {
            frontierCalculator.ensureMinWidth(this.titleAndAttributeWidth + 10);
        }
        ClusterPosition forced = frontierCalculator.getSuggestedPosition();
        this.xTitle += (forced.getMinX() - this.minX + (forced.getMaxX() - this.maxX)) / 2.0;
        this.minX = forced.getMinX();
        this.minY = forced.getMinY();
        this.maxX = forced.getMaxX();
        this.maxY = forced.getMaxY();
        this.yTitle = this.minY + 5.0;
        double widthTitle = this.ztitle.calculateDimension(stringBounder).getWidth();
        this.xTitle = this.minX + (this.maxX - this.minX - widthTitle) / 2.0;
    }

    private void drawSwinLinesState(UGraphic ug, HtmlColor borderColor, DotData dotData) {
        if (this.ztitle != null) {
            this.ztitle.drawU(ug.apply(new UTranslate(this.xTitle, 0.0)));
        }
        ULine line = new ULine(0.0, this.maxY - this.minY);
        ug = ug.apply(new UChangeColor(borderColor));
        ug.apply(new UTranslate(this.minX, 0.0)).draw(line);
        ug.apply(new UTranslate(this.maxX, 0.0)).draw(line);
    }

    private HtmlColor getColor(DotData dotData, ColorParam colorParam, Stereotype stereo) {
        return new Rose().getHtmlColor(dotData.getSkinParam(), colorParam, stereo);
    }

    private void drawUState(UGraphic ug, HtmlColor borderColor, DotData dotData, UStroke stroke) {
        Stereotype stereotype;
        boolean withSymbol;
        double attributeHeight;
        Dimension2DDouble total = new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
        double suppY = this.ztitle == null ? 0.0 : this.ztitle.calculateDimension(ug.getStringBounder()).getHeight() + 5.0 + 5.0;
        HtmlColor stateBack = this.getBackColor();
        if (stateBack == null) {
            stateBack = this.getColor(dotData, ColorParam.stateBackground, this.group.getStereotype());
        }
        HtmlColor background = this.getColor(dotData, ColorParam.background, null);
        TextBlockWidth attribute = this.getTextBlockAttribute(dotData);
        RoundedContainer r = new RoundedContainer(total, suppY, attributeHeight + (double)((attributeHeight = attribute.calculateDimension(ug.getStringBounder()).getHeight()) > 0.0 ? 5 : 0), borderColor, stateBack, background, stroke);
        r.drawU(ug.apply(new UTranslate(this.minX, this.minY)), dotData.getSkinParam().shadowing());
        if (this.ztitle != null) {
            this.ztitle.drawU(ug.apply(new UTranslate(this.xTitle, this.yTitle)));
        }
        if (attributeHeight > 0.0) {
            attribute.asTextBlock(((Dimension2D)total).getWidth()).drawU(ug.apply(new UTranslate(this.minX + 5.0, this.minY + suppY + 2.5)));
        }
        boolean bl = withSymbol = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (withSymbol) {
            EntityImageState.drawSymbol(ug.apply(new UChangeColor(borderColor)), this.maxX, this.maxY);
        }
    }

    private TextBlockWidth getTextBlockAttribute(DotData dotData) {
        List<Member> members = this.group.getBodier().getFieldsToDisplay();
        AbstractTextBlock attribute = members.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(members, FontParam.STATE_ATTRIBUTE, dotData.getSkinParam());
        return attribute;
    }

    public void setPosition(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    private boolean isThereALinkFromOrToGroup(Collection<Line> lines) {
        for (Line line : lines) {
            if (!line.isLinkFromOrTo(this.group)) continue;
            return true;
        }
        return false;
    }

    public void printCluster1(StringBuilder sb, Collection<Line> lines) {
        for (Shape sh : this.getShapesOrderedTop(lines)) {
            sh.appendShape(sb);
        }
    }

    private List<IShapePseudo> addProtection(List<Shape> entries, double width) {
        ArrayList<IShapePseudo> result = new ArrayList<IShapePseudo>();
        result.add(entries.get(0));
        for (int i = 1; i < entries.size(); ++i) {
            result.add(new ShapePseudoImpl("psd" + UniqueSequence.getValue(), width, 5.0));
            result.add(entries.get(i));
        }
        return result;
    }

    private double getMaxWidthFromLabelForEntryExit(List<Shape> entries, StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (Shape shape : entries) {
            double w = this.getMaxWidthFromLabelForEntryExit(shape, stringBounder);
            if (!(w > result)) continue;
            result = w;
        }
        return result;
    }

    private double getMaxWidthFromLabelForEntryExit(Shape shape, StringBounder stringBounder) {
        return shape.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    public void printClusterEntryExit(StringBuilder sb, StringBounder stringBounder) {
        List<Shape> exits;
        List<Shape> shapesEntryExitList = this.getShapesEntryExit(EntityPosition.ENTRY_POINT);
        double maxWith = this.getMaxWidthFromLabelForEntryExit(shapesEntryExitList, stringBounder);
        double naturalSpace = 70.0;
        List<IShapePseudo> entries = maxWith > 70.0 ? this.addProtection(shapesEntryExitList, maxWith - 70.0) : shapesEntryExitList;
        if (entries.size() > 0) {
            sb.append("{rank=source;");
            for (IShapePseudo sh : entries) {
                sb.append(sh.getUid() + ";");
            }
            sb.append("}");
            for (IShapePseudo sh : entries) {
                sh.appendShape(sb);
            }
        }
        if ((exits = this.getShapesEntryExit(EntityPosition.EXIT_POINT)).size() > 0) {
            sb.append("{rank=sink;");
            for (Shape sh : exits) {
                sb.append(sh.getUid() + ";");
            }
            sb.append("}");
            for (Shape sh : exits) {
                sh.appendShape(sb);
            }
        }
    }

    public boolean printCluster2(StringBuilder sb, Collection<Line> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        boolean added = false;
        for (Shape sh : this.getShapesOrderedWithoutTop(lines)) {
            sh.appendShape(sb);
            added = true;
        }
        if (dotMode != DotMode.NO_LEFT_RIGHT) {
            this.appendRankSame(sb, lines);
        }
        for (Cluster child : this.getChildren()) {
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
        return added;
    }

    private void appendRankSame(StringBuilder sb, Collection<Line> lines) {
        for (String same : this.getRankSame(lines)) {
            sb.append(same);
            SvekUtils.println(sb);
        }
    }

    private Set<String> getRankSame(Collection<Line> lines) {
        HashSet<String> rankSame = new HashSet<String>();
        for (Line l : lines) {
            String same;
            if (l.hasEntryPoint()) continue;
            String startUid = l.getStartUid();
            String endUid = l.getEndUid();
            if (!this.isInCluster(startUid) || !this.isInCluster(endUid) || (same = l.rankSame()) == null) continue;
            rankSame.add(same);
        }
        return rankSame;
    }

    public void fillRankMin(Set<String> rankMin) {
        for (Shape sh : this.getShapes()) {
            if (!sh.isTop()) continue;
            rankMin.add(sh.getUid());
        }
        for (Cluster child : this.getChildren()) {
            child.fillRankMin(rankMin);
        }
    }

    private boolean isInCluster(String uid) {
        for (Shape sh : this.shapes) {
            if (!sh.getUid().equals(uid)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    public static String getSpecialPointId(IEntity group) {
        return CENTER_ID + group.getUid();
    }

    private boolean protection0(UmlDiagramType type) {
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean protection1(UmlDiagramType type) {
        if (this.group.getUSymbol() == USymbol.NODE) {
            return true;
        }
        return !this.skinParam.useSwimlanes(type);
    }

    public String getMinPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "minPoint" + this.color;
        }
        return null;
    }

    public String getMaxPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    private String getSourceInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sourceIn" + this.color;
        }
        return null;
    }

    private String getSinkInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sinkIn" + this.color;
        }
        return null;
    }

    private void printInternal(StringBuilder sb, Collection<Line> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        String label;
        boolean isLabel;
        boolean hasEntryOrExitPoint;
        boolean thereALinkFromOrToGroup2;
        boolean thereALinkFromOrToGroup1 = thereALinkFromOrToGroup2 = this.isThereALinkFromOrToGroup(lines);
        boolean useProtectionWhenThereALinkFromOrToGroup = graphvizVersion.useProtectionWhenThereALinkFromOrToGroup();
        if (!useProtectionWhenThereALinkFromOrToGroup) {
            thereALinkFromOrToGroup1 = false;
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphCluster(sb, "a");
        }
        if (hasEntryOrExitPoint = this.hasEntryOrExitPoint()) {
            for (Line line : lines) {
                if (!line.isLinkFromOrTo(this.group)) continue;
                line.setProjectionCluster(this);
            }
        }
        boolean protection0 = this.protection0(type);
        boolean protection1 = this.protection1(type);
        if (hasEntryOrExitPoint || !useProtectionWhenThereALinkFromOrToGroup) {
            protection0 = false;
            protection1 = false;
        }
        if (protection0) {
            this.subgraphCluster(sb, "p0");
        }
        sb.append("subgraph " + this.getClusterId() + " {");
        sb.append("style=solid;");
        sb.append("color=\"" + StringUtils.getAsHtml(this.color) + "\";");
        boolean bl = isLabel = this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
        if (isLabel) {
            StringBuilder sblabel = new StringBuilder("<");
            Line.appendTable(sblabel, this.getTitleAndAttributeWidth(), this.getTitleAndAttributeHeight() - 5, this.colorTitle);
            sblabel.append(">");
            label = sblabel.toString();
        } else {
            label = "\"\"";
        }
        if (hasEntryOrExitPoint) {
            this.printClusterEntryExit(sb, stringBounder);
            this.subgraphCluster(sb, "ee", label);
        } else {
            sb.append("label=" + label + ";");
            SvekUtils.println(sb);
        }
        if (thereALinkFromOrToGroup2) {
            sb.append(Cluster.getSpecialPointId(this.group) + " [shape=point,width=.01,label=\"\"];");
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphCluster(sb, "i");
        }
        if (protection1) {
            this.subgraphCluster(sb, "p1");
        }
        if (this.skinParam.useSwimlanes(type)) {
            sb.append("{rank = source; ");
            sb.append(this.getSourceInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append(this.getMinPoint(type) + "->" + this.getSourceInPoint(type) + "  [weight=999];");
            sb.append("}");
            SvekUtils.println(sb);
            sb.append("{rank = sink; ");
            sb.append(this.getSinkInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append("}");
            sb.append(this.getSinkInPoint(type) + "->" + this.getMaxPoint(type) + "  [weight=999];");
            SvekUtils.println(sb);
        }
        SvekUtils.println(sb);
        this.printCluster1(sb, lines);
        boolean added = this.printCluster2(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        if (hasEntryOrExitPoint && !added) {
            String empty = "empty" + this.color;
            sb.append(empty + " [shape=point,width=.01,label=\"\"];");
        }
        sb.append("}");
        if (protection1) {
            sb.append("}");
        }
        if (thereALinkFromOrToGroup1) {
            sb.append("}");
            sb.append("}");
        }
        if (hasEntryOrExitPoint) {
            sb.append("}");
        }
        if (protection0) {
            sb.append("}");
        }
        SvekUtils.println(sb);
    }

    private void subgraphCluster(StringBuilder sb, String id) {
        this.subgraphCluster(sb, id, "\"\"");
    }

    private void subgraphCluster(StringBuilder sb, String id, String label) {
        String uid = this.getClusterId() + id;
        sb.append("subgraph " + uid + " {");
        sb.append("label=" + label + ";");
    }

    public int getColor() {
        return this.color;
    }

    public int getTitleColor() {
        return this.colorTitle;
    }

    private final HtmlColor getBackColor() {
        if (EntityUtils.groupRoot(this.group)) {
            return null;
        }
        HtmlColor result = this.group.getSpecificBackColor();
        if (result != null) {
            return result;
        }
        Stereotype stereo = this.group.getStereotype();
        USymbol sym = this.group.getUSymbol() == null ? USymbol.PACKAGE : this.group.getUSymbol();
        ColorParam backparam = sym.getColorParamBack();
        HtmlColor c1 = this.skinParam.getHtmlColor(backparam, stereo, false);
        if (c1 != null) {
            return c1;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBackColor();
    }

    public boolean isClusterOf(IEntity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        return this.group == ent;
    }

    public static HtmlColor getStateBackColor(HtmlColor stateBack, ISkinParam skinParam, Stereotype stereotype) {
        if (stateBack == null) {
            stateBack = skinParam.getHtmlColor(ColorParam.packageBackground, stereotype, false);
        }
        if (stateBack == null) {
            stateBack = skinParam.getHtmlColor(ColorParam.background, stereotype, false);
        }
        if (stateBack == null) {
            stateBack = new HtmlColorTransparent();
        }
        return stateBack;
    }

    public double checkFolderPosition(Point2D pt, StringBounder stringBounder) {
        if (this.getClusterPosition().isPointJustUpper(pt)) {
            if (this.ztitle == null) {
                return 0.0;
            }
            Dimension2D dimTitle = this.ztitle.calculateDimension(stringBounder);
            if (pt.getX() < this.getClusterPosition().getMinX() + dimTitle.getWidth()) {
                return 0.0;
            }
            return this.getClusterPosition().getMinY() - pt.getY() + dimTitle.getHeight();
        }
        return 0.0;
    }
}

