/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.classdiagram.command.CommandUrl;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandFootboxIgnored;
import net.sourceforge.plantuml.command.CommandRankDir;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.command.note.FactoryNoteCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnEntityCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnLinkCommand;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.statediagram.command.CommandAddField;
import net.sourceforge.plantuml.statediagram.command.CommandConcurrentState;
import net.sourceforge.plantuml.statediagram.command.CommandCreatePackageState;
import net.sourceforge.plantuml.statediagram.command.CommandCreateState;
import net.sourceforge.plantuml.statediagram.command.CommandEndState;
import net.sourceforge.plantuml.statediagram.command.CommandHideEmptyDescription;
import net.sourceforge.plantuml.statediagram.command.CommandLinkState;

public class StateDiagramFactory
extends UmlDiagramFactory {
    @Override
    public StateDiagram createEmptyDiagram() {
        return new StateDiagram();
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(new CommandFootboxIgnored());
        cmds.add(new CommandRankDir());
        cmds.add(new CommandCreateState());
        cmds.add(new CommandLinkState());
        cmds.add(new CommandCreatePackageState());
        cmds.add(new CommandEndState());
        cmds.add(new CommandAddField());
        cmds.add(new CommandConcurrentState());
        FactoryNoteOnEntityCommand factoryNoteOnEntityCommand = new FactoryNoteOnEntityCommand(new RegexOr("ENTITY", new RegexLeaf("[\\p{L}0-9_.]+"), new RegexLeaf("[%g][^%g]+[%g]")));
        cmds.add(factoryNoteOnEntityCommand.createMultiLine());
        cmds.add(new CommandHideEmptyDescription());
        cmds.add(factoryNoteOnEntityCommand.createSingleLine());
        FactoryNoteOnLinkCommand factoryNoteOnLinkCommand = new FactoryNoteOnLinkCommand();
        cmds.add(factoryNoteOnLinkCommand.createSingleLine());
        cmds.add(factoryNoteOnLinkCommand.createMultiLine());
        cmds.add(new CommandUrl());
        FactoryNoteCommand factoryNoteCommand = new FactoryNoteCommand();
        cmds.add(factoryNoteCommand.createSingleLine());
        cmds.add(factoryNoteCommand.createMultiLine());
        this.addCommonCommands(cmds);
        return cmds;
    }

    @Override
    public String checkFinalError(AbstractPSystem sys) {
        StateDiagram system = (StateDiagram)sys;
        for (Link link : system.getLinks()) {
            IGroup parent2;
            IGroup parent1 = this.getGroupParentIfItIsConcurrentState(link.getEntity1());
            if (this.isCompatible(parent1, parent2 = this.getGroupParentIfItIsConcurrentState(link.getEntity2()))) continue;
            return "State within concurrent state cannot be linked out of this concurrent state (between " + link.getEntity1().getCode().getFullName() + " and " + link.getEntity2().getCode().getFullName() + ")";
        }
        return super.checkFinalError(system);
    }

    private boolean isCompatible(IGroup parent1, IGroup parent2) {
        if (parent1 == null && parent2 == null) {
            return true;
        }
        if (parent1 != null ^ parent2 != null) {
            return false;
        }
        assert (parent1 != null && parent2 != null);
        return parent1 == parent2;
    }

    private IGroup getGroupParentIfItIsConcurrentState(IEntity ent) {
        for (IGroup parent = ent.getParentContainer(); parent != null; parent = parent.getParentContainer()) {
            if (parent.getGroupType() != GroupType.CONCURRENT_STATE) continue;
            return parent;
        }
        return null;
    }
}

