/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class SegmentColored {
    private final Segment segment;
    private final HtmlColor backcolor;
    private final boolean shadowing;
    private final double pos1Initial;

    SegmentColored(double pos1, double pos2, HtmlColor backcolor, boolean shadowing) {
        this(new Segment(pos1, pos2), backcolor, shadowing, pos1);
    }

    private SegmentColored(Segment segment, HtmlColor backcolor, boolean shadowing, double pos1Initial) {
        this.segment = segment;
        this.backcolor = backcolor;
        this.shadowing = shadowing;
        this.pos1Initial = pos1Initial;
    }

    public HtmlColor getSpecificBackColor() {
        return this.backcolor;
    }

    public boolean equals(Object obj) {
        SegmentColored this2 = (SegmentColored)obj;
        return this.segment.equals(this2.segment);
    }

    public int hashCode() {
        return this.segment.hashCode();
    }

    public String toString() {
        return this.segment.toString();
    }

    public void drawU(UGraphic ug, Component compAliveBox, int level) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UTranslate((double)(level - 1) * compAliveBox.getPreferredWidth(stringBounder) / 2.0, this.segment.getPos1()));
        Dimension2DDouble dim = new Dimension2DDouble(compAliveBox.getPreferredWidth(stringBounder), this.segment.getPos2() - this.segment.getPos1());
        compAliveBox.drawU(ug, new Area(dim), new SimpleContext2D(false));
    }

    public Collection<SegmentColored> cutSegmentIfNeed(Collection<Segment> allDelays) {
        return new Coll2(this.segment.cutSegmentIfNeed(allDelays), this.segment.getPos1());
    }

    public double getPos1Initial() {
        return this.pos1Initial;
    }

    public SegmentColored merge(SegmentColored this2) {
        Segment merge = this.segment.merge(this2.segment);
        return new SegmentColored(merge, this.backcolor, this.shadowing, merge.getPos1());
    }

    public final Segment getSegment() {
        return this.segment;
    }

    class Coll2
    extends AbstractCollection<SegmentColored> {
        private final Collection<Segment> col;
        private final double pos1Initial;

        public Coll2(Collection<Segment> col, double pos1Initial) {
            this.col = col;
            this.pos1Initial = pos1Initial;
        }

        @Override
        public Iterator<SegmentColored> iterator() {
            return new Iterator2(this.col.iterator(), this.pos1Initial);
        }

        @Override
        public int size() {
            return this.col.size();
        }
    }

    class Iterator2
    implements Iterator<SegmentColored> {
        private final Iterator<Segment> it;
        private final double pos1Initial;

        public Iterator2(Iterator<Segment> it, double pos1Initial) {
            this.it = it;
            this.pos1Initial = pos1Initial;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SegmentColored next() {
            return new SegmentColored(this.it.next(), SegmentColored.this.backcolor, SegmentColored.this.shadowing, this.pos1Initial);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

