/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import net.sourceforge.plantuml.salt.element.ElementMenuPopup;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementMenuBar
extends AbstractElement {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final Map<ElementMenuEntry, ElementMenuPopup> popups = new HashMap<ElementMenuEntry, ElementMenuPopup>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuBar(UFont font, ISkinSimple spriteContainer) {
        this.font = font;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String s) {
        this.entries.add(new ElementMenuEntry(s, this.font, this.spriteContainer));
    }

    public void addSubEntry(String s, String sub) {
        ElementMenuPopup popup = this.getPopup(this.getElementMenuEntry(s));
        popup.addEntry(sub);
    }

    private ElementMenuPopup getPopup(ElementMenuEntry s) {
        ElementMenuPopup popup = this.popups.get(s);
        if (popup == null) {
            popup = new ElementMenuPopup(this.font, this.spriteContainer);
            this.popups.put(s, popup);
        }
        return popup;
    }

    private ElementMenuEntry getElementMenuEntry(String n) {
        for (ElementMenuEntry entry : this.entries) {
            if (!entry.getText().equals(n)) continue;
            return entry;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            Dimension2D dim = entry.getPreferredDimension(stringBounder, x, y);
            w += dim.getWidth() + 10.0;
            h = Math.max(h, dim.getHeight());
        }
        return new Dimension2DDouble(w, h);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        Dimension2D preferred = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        double x1 = 0.0;
        if (zIndex == 0) {
            ug.apply(new UChangeBackColor(HtmlColorSet.getInstance().getColorIfValid("#DDDDDD"))).draw(new URectangle(dimToUse.getWidth(), dimToUse.getHeight()));
            for (ElementMenuEntry entry : this.entries) {
                entry.drawU(ug.apply(new UTranslate(x1, 0.0)), zIndex, dimToUse);
                double w = entry.getPreferredDimension(ug.getStringBounder(), x1, 0.0).getWidth();
                entry.setX(x1);
                x1 += w + 10.0;
            }
            return;
        }
        if (zIndex == 1) {
            for (ElementMenuEntry entry : this.popups.keySet()) {
                entry.setBackground(HtmlColorSet.getInstance().getColorIfValid("#BBBBBB"));
            }
            double y1 = preferred.getHeight();
            for (Map.Entry<ElementMenuEntry, ElementMenuPopup> ent : this.popups.entrySet()) {
                ElementMenuPopup p = ent.getValue();
                double xpopup = ent.getKey().getX();
                p.drawU(ug.apply(new UTranslate(xpopup, y1)), zIndex, p.getPreferredDimension(ug.getStringBounder(), xpopup, y1));
            }
        }
    }
}

