/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UFont;

public class Stereotype
implements CharSequence,
Hideable {
    private static final Pattern circleChar = MyPattern.cmpile("\\<\\<[%s]*\\(?(\\S)[%s]*,[%s]*(#[0-9a-fA-F]{6}|\\w+)[%s]*(?:[),](.*?))?\\>\\>");
    private static final Pattern circleSprite = MyPattern.cmpile("\\<\\<[%s]*\\(?\\$([\\p{L}0-9_]+)[%s]*(?:,[%s]*(#[0-9a-fA-F]{6}|\\w+))?[%s]*(?:[),](.*?))?\\>\\>");
    private final String label;
    private final HtmlColor htmlColor;
    private final char character;
    private final String sprite;
    private final double radius;
    private final UFont circledFont;
    private final boolean automaticPackageStyle;

    public Stereotype(String label, double radius, UFont circledFont, IHtmlColorSet htmlColorSet) {
        this(label, radius, circledFont, true, htmlColorSet);
    }

    public Stereotype(String label, double radius, UFont circledFont, boolean automaticPackageStyle, IHtmlColorSet htmlColorSet) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        if (!label.startsWith("<<") || !label.endsWith(">>")) {
            throw new IllegalArgumentException(label);
        }
        this.automaticPackageStyle = automaticPackageStyle;
        this.radius = radius;
        this.circledFont = circledFont;
        Matcher mCircleChar = circleChar.matcher(label);
        Matcher mCircleSprite = circleSprite.matcher(label);
        if (mCircleSprite.find()) {
            this.label = StringUtils.isNotEmpty(mCircleSprite.group(3)) ? "<<" + mCircleSprite.group(3) + ">>" : null;
            String colName = mCircleSprite.group(2);
            HtmlColor col = htmlColorSet.getColorIfValid(colName);
            this.htmlColor = col == null ? HtmlColorUtils.BLACK : col;
            this.sprite = mCircleSprite.group(1);
            this.character = '\u0000';
        } else if (mCircleChar.find()) {
            this.label = StringUtils.isNotEmpty(mCircleChar.group(3)) ? "<<" + mCircleChar.group(3) + ">>" : null;
            String colName = mCircleChar.group(2);
            this.htmlColor = htmlColorSet.getColorIfValid(colName);
            this.character = mCircleChar.group(1).charAt(0);
            this.sprite = null;
        } else {
            this.label = label;
            this.character = '\u0000';
            this.htmlColor = null;
            this.sprite = null;
        }
    }

    public Stereotype(String label) {
        this(label, true);
    }

    public Stereotype(String label, boolean automaticPackageStyle) {
        this.automaticPackageStyle = automaticPackageStyle;
        this.label = label;
        this.htmlColor = null;
        this.character = '\u0000';
        this.radius = 0.0;
        this.circledFont = null;
        this.sprite = null;
    }

    public HtmlColor getHtmlColor() {
        return this.htmlColor;
    }

    public char getCharacter() {
        return this.character;
    }

    public final String getSprite() {
        return this.sprite;
    }

    public boolean isWithOOSymbol() {
        return "<<O-O>>".equalsIgnoreCase(this.label);
    }

    public String getLabel(boolean withGuillement) {
        assert (this.label == null || this.label.length() > 0);
        if (this.isWithOOSymbol()) {
            return null;
        }
        if (withGuillement) {
            return StringUtils.manageGuillemetStrict(this.label);
        }
        return this.label;
    }

    public boolean isSpotted() {
        return this.character != '\u0000';
    }

    @Override
    public String toString() {
        if (this.label == null) {
            return "" + this.character;
        }
        if (this.character == '\u0000') {
            return this.label;
        }
        return this.character + " " + this.label;
    }

    @Override
    public char charAt(int arg0) {
        return this.toString().charAt(arg0);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        return this.toString().subSequence(arg0, arg1);
    }

    public double getRadius() {
        return this.radius;
    }

    public final UFont getCircledFont() {
        return this.circledFont;
    }

    public List<String> getLabels(boolean useGuillemet) {
        if (this.getLabel(false) == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = MyPattern.cmpile("\\<\\<.*?\\>\\>");
        Matcher m = p.matcher(this.getLabel(false));
        while (m.find()) {
            if (useGuillemet) {
                result.add(StringUtils.manageGuillemetStrict(m.group()));
                continue;
            }
            result.add(m.group());
        }
        return Collections.unmodifiableList(result);
    }

    public PackageStyle getPackageStyle() {
        if (!this.automaticPackageStyle) {
            return null;
        }
        for (PackageStyle p : EnumSet.allOf(PackageStyle.class)) {
            if (!("<<" + (Object)((Object)p) + ">>").equalsIgnoreCase(this.label)) continue;
            return p;
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return "<<hidden>>".equalsIgnoreCase(this.label);
    }
}

