/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleMonospaced
implements Command {
    private final Pattern pattern;

    public static Command create() {
        return new CommandCreoleMonospaced("^(?i)([%g][%g](.*?)[%g][%g])");
    }

    private CommandCreoleMonospaced(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeFamily("monospaced");
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(2));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

