/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;

public final class FactoryNoteOnLinkCommand
implements SingleMultiFactoryCommand<CucaDiagram> {
    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?[%s]*on[%s]+link"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?[%s]*on[%s]+link"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    public Command<CucaDiagram> createMultiLine() {
        return new CommandMultilines2<CucaDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(CucaDiagram system, BlocLines lines) {
                String line0 = lines.getFirst499().toString();
                lines = lines.subExtract(1, 1);
                if ((lines = lines.removeEmptyColumns()).size() > 0) {
                    RegexResult arg = this.getStartingPattern().matcher(line0);
                    return FactoryNoteOnLinkCommand.this.executeInternal(system, lines, arg);
                }
                return CommandExecutionResult.error("No note defined");
            }
        };
    }

    @Override
    public Command<CucaDiagram> createSingleLine() {
        return new SingleLineCommand2<CucaDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(CucaDiagram system, RegexResult arg) {
                BlocLines note = BlocLines.getWithNewlines(arg.get("NOTE", 0));
                return FactoryNoteOnLinkCommand.this.executeInternal(system, note, arg);
            }
        };
    }

    private CommandExecutionResult executeInternal(CucaDiagram diagram, BlocLines note, RegexResult arg) {
        Link link = diagram.getLastLink();
        if (link == null) {
            return CommandExecutionResult.error("No link defined");
        }
        Position position = Position.BOTTOM;
        if (arg.get("POSITION", 0) != null) {
            position = Position.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0)));
        }
        Url url = null;
        if (note.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = urlBuilder.getUrl(note.getFirst499().toString());
        }
        if (url != null) {
            note = note.subExtract(1, 0);
        }
        link.addNote(note.toDisplay(), position, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }
}

