/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilinesBracket;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class CommandSkinParamMultilines
extends CommandMultilinesBracket<UmlDiagram> {
    private static final Pattern p1 = MyPattern.cmpile("^([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*)[%s]+(?:(\\{)|(.*))$|^\\}?$");

    public CommandSkinParamMultilines() {
        super("(?i)^skinparam[%s]*(?:[%s]+([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*))?[%s]*\\{$");
    }

    @Override
    protected boolean isLineConsistent(String line, int level) {
        if (this.hasStartingQuote(line = StringUtils.trin(line))) {
            return true;
        }
        return p1.matcher(line).matches();
    }

    private boolean hasStartingQuote(CharSequence line) {
        return MyPattern.mtches(line, "[%s]*[%q].*");
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram diagram, BlocLines lines) {
        Context context = new Context();
        Matcher mStart = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
        if (!mStart.find()) {
            throw new IllegalStateException();
        }
        if (mStart.group(1) != null) {
            context.push(mStart.group(1));
        }
        lines = lines.subExtract(1, 1);
        lines = lines.trim(true);
        for (CharSequence s : lines) {
            assert (s.length() > 0);
            if (this.hasStartingQuote(s)) continue;
            if (s.toString().equals("}")) {
                context.pop();
                continue;
            }
            Matcher m = p1.matcher(s);
            if (!m.find()) {
                throw new IllegalStateException();
            }
            if (m.group(2) != null) {
                context.push(m.group(1));
                continue;
            }
            if (m.group(3) != null) {
                String key = context.getFullParam() + m.group(1);
                diagram.setParam(key, m.group(3));
                continue;
            }
            throw new IllegalStateException("." + s.toString() + ".");
        }
        return CommandExecutionResult.ok();
    }

    static class Context {
        private List<String> strings = new ArrayList<String>();

        Context() {
        }

        public void push(String s) {
            this.strings.add(s);
        }

        public void pop() {
            this.strings.remove(this.strings.size() - 1);
        }

        public String getFullParam() {
            StringBuilder sb = new StringBuilder();
            for (String s : this.strings) {
                sb.append(s);
            }
            return sb.toString();
        }
    }
}

