/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileDiamondInside
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock label;
    private final TextBlock west;
    private final TextBlock east;
    private final TextBlock north;
    private final TextBlock south;

    public FtileDiamondInside(boolean shadowing, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock label) {
        this(shadowing, backColor, borderColor, swimlane, label, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondInside withNorth(TextBlock north) {
        return new FtileDiamondInside(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, north, this.south, this.west, this.east);
    }

    public FtileDiamondInside withWest(TextBlock west) {
        return new FtileDiamondInside(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, west, this.east);
    }

    public FtileDiamondInside withEast(TextBlock east) {
        return new FtileDiamondInside(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, this.west, east);
    }

    public FtileDiamondInside withSouth(TextBlock south) {
        return new FtileDiamondInside(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, south, this.west, this.east);
    }

    private FtileDiamondInside(boolean shadowing, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock label, TextBlock north, TextBlock south, TextBlock west, TextBlock east) {
        super(shadowing);
        this.backColor = backColor;
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.label = label;
        this.west = west;
        this.east = east;
        this.north = north;
        this.south = south;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimensionAlone(stringBounder);
        ug = ug.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor));
        ug.draw(Diamond.asPolygon(this.shadowing(), ((Dimension2D)dimTotal).getWidth(), ((Dimension2D)dimTotal).getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + ((Dimension2D)dimTotal).getWidth() / 2.0, ((Dimension2D)dimTotal).getHeight())));
        this.south.drawU(ug.apply(new UTranslate(4.0 + ((Dimension2D)dimTotal).getWidth() / 2.0, ((Dimension2D)dimTotal).getHeight())));
        double lx = (((Dimension2D)dimTotal).getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (((Dimension2D)dimTotal).getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        Dimension2D dimWeat = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWeat.getWidth(), -dimWeat.getHeight() + ((Dimension2D)dimTotal).getHeight() / 2.0)));
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth(), -dimEast.getHeight() + ((Dimension2D)dimTotal).getHeight() / 2.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.calculateDimensionAlone(stringBounder);
        Dimension2D dimNorth = this.north.calculateDimension(stringBounder);
        double northHeight = dimNorth.getHeight();
        double northWidth = dimNorth.getWidth();
        dim = Dimension2DDouble.delta(dim, 0.0, northHeight);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight() - northHeight);
    }

    private FtileGeometry calculateDimensionAlone(StringBounder stringBounder) {
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        Dimension2D dim = dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0 ? new Dimension2DDouble(24.0, 24.0) : Dimension2DDouble.delta(Dimension2DDouble.atLeast(dimLabel, 24.0, 24.0), 24.0, 0.0);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }
}

