/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileSplit1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorCreateSplit
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double barHeight = 6.0;
    private final double xMargin = 14.0;
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorCreateSplit(FtileFactory factory, ISkinParam skinParam) {
        super(factory, skinParam);
    }

    private static boolean isSimpleSwimlanes(List<Ftile> all) {
        HashSet<Swimlane> already = new HashSet<Swimlane>();
        for (Ftile ftile : all) {
            Set<Swimlane> currents = ftile.getSwimlanes();
            if (currents.size() != 1) {
                return false;
            }
            assert (currents.size() == 1);
            Swimlane current = currents.iterator().next();
            if (already.contains(current)) {
                return false;
            }
            already.add(current);
        }
        return already.size() > 1;
    }

    private static boolean isSeveralSwimlanes(List<Ftile> all) {
        HashSet<Swimlane> already = new HashSet<Swimlane>();
        for (Ftile ftile : all) {
            Set<Swimlane> currents = ftile.getSwimlanes();
            if (currents.size() > 1) {
                return true;
            }
            assert (currents.size() == 0 || currents.size() == 1);
            if (currents.size() != 1) continue;
            Swimlane current = currents.iterator().next();
            already.add(current);
        }
        return already.size() > 1;
    }

    @Override
    public Ftile createSplit(List<Ftile> all) {
        HtmlColor arrowColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry dimSuper = super.createSplit(all).calculateDimension(this.getStringBounder());
        double height1 = ((Dimension2D)dimSuper).getHeight() + 40.0;
        ArrayList<Ftile> list = new ArrayList<Ftile>();
        for (Ftile tmp : all) {
            list.add(new FtileHeightFixed(new FtileMarged(tmp, 14.0), height1));
        }
        Ftile inner = super.createSplit(list);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        double x = 0.0;
        boolean hasOut = false;
        for (Ftile tmp : list) {
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            conns.add(new ConnectionIn(tmp, x, arrowColor, this.getTextBlock(tmp.getInLinkRendering())));
            boolean hasOutTmp = tmp.calculateDimension(this.getStringBounder()).hasPointOut();
            if (hasOutTmp) {
                conns.add(new ConnectionOut(tmp, x, arrowColor, height1, this.getTextBlock(tmp.getOutLinkRendering())));
                hasOut = true;
            }
            x += ((Dimension2D)dim).getWidth();
        }
        double totalWidth = inner.calculateDimension(this.getStringBounder()).getWidth();
        conns.add(new ConnectionHline2(inner, arrowColor, 0.0, list, totalWidth));
        if (hasOut) {
            conns.add(new ConnectionHline2(inner, arrowColor, height1, list, totalWidth));
        }
        inner = FtileUtils.addConnection(inner, conns);
        if (!hasOut) {
            inner = new FtileKilled(inner);
        }
        return inner;
    }

    private TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = LinkRendering.getDisplay(linkRendering);
        if (Display.isNull(display)) {
            return null;
        }
        ISkinParam skinParam = this.getSkinParam();
        UFont font = skinParam.getFont(FontParam.ACTIVITY_ARROW, null, false);
        HtmlColor color = this.rose.getFontColor(skinParam, FontParam.ACTIVITY_ARROW);
        FontConfiguration fontConfiguration = new FontConfiguration(font, color, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, null, CreoleMode.SIMPLE_LINE);
    }

    private Ftile simpleSwimlanes(List<Ftile> all) {
        HtmlColor arrowColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry dimSuper = new FtileSplit1(all).calculateDimension(this.getStringBounder());
        double height1 = ((Dimension2D)dimSuper).getHeight() + 40.0;
        ArrayList<Ftile> list = new ArrayList<Ftile>();
        for (Ftile tmp : all) {
            list.add(new FtileHeightFixed(new FtileMarged(tmp, 14.0), height1));
        }
        Ftile inner = new FtileSplit1(list);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        boolean hasOut = false;
        for (Ftile tmp : list) {
            double x = inner.getTranslateFor(tmp, this.getStringBounder()).getDx();
            conns.add(new ConnectionIn(tmp, x, arrowColor, null));
            boolean hasOutTmp = tmp.calculateDimension(this.getStringBounder()).hasPointOut();
            if (!hasOutTmp) continue;
            conns.add(new ConnectionOut(tmp, x, arrowColor, height1, null));
            hasOut = true;
        }
        double totalWidth = inner.calculateDimension(this.getStringBounder()).getWidth();
        conns.add(new ConnectionHline3(inner, arrowColor, 0.0, list, totalWidth));
        if (hasOut) {
            conns.add(new ConnectionHline3(inner, arrowColor, height1, list, totalWidth));
        }
        inner = FtileUtils.addConnection(inner, conns);
        if (!hasOut) {
            inner = new FtileKilled(inner);
        }
        return inner;
    }

    static class ConnectionOut
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final double height;
        private final TextBlock text;

        public ConnectionOut(Ftile tmp, double x, HtmlColor arrowColor, double height, TextBlock text) {
            super(tmp, null);
            this.x = x;
            this.arrowColor = arrowColor;
            this.height = height;
            this.text = text;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile1().calculateDimension(ug.getStringBounder());
            if (!geo.hasPointOut()) {
                assert (false);
                return;
            }
            Snake s = new Snake(this.arrowColor, Arrows.asToDown());
            s.setLabel(this.text);
            s.goUnmergeable();
            s.addPoint(geo.getLeft(), geo.getOutY());
            s.addPoint(geo.getLeft(), this.height);
            ug.draw(s);
        }
    }

    static class ConnectionIn
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final TextBlock text;

        public ConnectionIn(Ftile tmp, double x, HtmlColor arrowColor, TextBlock text) {
            super(null, tmp);
            this.x = x;
            this.arrowColor = arrowColor;
            this.text = text;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile2().calculateDimension(ug.getStringBounder());
            double left = geo.getLeft();
            Snake s = new Snake(this.arrowColor, Arrows.asToDown());
            s.setLabel(this.text);
            s.addPoint(left, 0.0);
            s.addPoint(left, geo.getInY());
            ug.draw(s);
        }
    }

    static class ConnectionHline3
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Ftile inner;
        private final double y;
        private final HtmlColor arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline3(Ftile inner, HtmlColor arrowColor, double y, List<Ftile> list, double totalWidth) {
            super(null, null);
            this.inner = inner;
            this.y = y;
            this.arrowColor = arrowColor;
            this.list = list;
            this.totalWidth = totalWidth;
        }

        @Override
        public void drawU(UGraphic ug) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            double minX;
            StringBounder stringBounder = ug.getStringBounder();
            UTranslate left = this.inner.getSwimlaneIn().getTranslate();
            double maxX = minX = this.inner.calculateDimension(stringBounder).getLeft() + left.getDx();
            for (Ftile tmp : this.list) {
                FtileGeometry tmpGeom = tmp.calculateDimension(stringBounder);
                UTranslate tpos = this.inner.getTranslateFor(tmp, stringBounder);
                for (Swimlane sw : tmp.getSwimlanes()) {
                    double x = tmpGeom.translate(sw.getTranslate().compose(tpos)).getLeft();
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                }
            }
            FtileGeometry dimInner = this.inner.calculateDimension(stringBounder);
            Snake s = new Snake(this.arrowColor);
            s.goUnmergeable();
            s.addPoint(minX, this.y);
            s.addPoint(maxX, this.y);
            ug.draw(s);
        }
    }

    static class ConnectionHline2
    extends AbstractConnection {
        private final Ftile inner;
        private final double y;
        private final HtmlColor arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline2(Ftile inner, HtmlColor arrowColor, double y, List<Ftile> list, double totalWidth) {
            super(null, null);
            this.inner = inner;
            this.y = y;
            this.arrowColor = arrowColor;
            this.list = list;
            this.totalWidth = totalWidth;
        }

        @Override
        public void drawU(UGraphic ug) {
            double minX = Double.MAX_VALUE;
            double maxX = 0.0;
            if (this.y == 0.0 && ug instanceof UGraphicInterceptorOneSwimlane) {
                Swimlane intoSw = ((UGraphicInterceptorOneSwimlane)ug).getSwimlane();
                boolean found = false;
                for (Ftile tmp : this.list) {
                    if (tmp.getSwimlaneIn() != intoSw) continue;
                    found = true;
                }
                if (!found) {
                    return;
                }
            }
            StringBounder stringBounder = ug.getStringBounder();
            for (Ftile tmp : this.list) {
                UTranslate ut;
                if (this.y > 0.0 && !tmp.calculateDimension(stringBounder).hasPointOut() || (ut = this.inner.getTranslateFor(tmp, stringBounder)) == null) continue;
                double middle = tmp.calculateDimension(stringBounder).translate(ut).getLeft();
                minX = Math.min(minX, middle);
                maxX = Math.max(maxX, middle);
            }
            if (minX > this.totalWidth / 2.0) {
                minX = this.totalWidth / 2.0;
            }
            if (maxX < this.totalWidth / 2.0) {
                maxX = this.totalWidth / 2.0;
            }
            Snake s = new Snake(this.arrowColor);
            s.goUnmergeable();
            s.addPoint(minX, this.y);
            s.addPoint(maxX, this.y);
            ug.draw(s);
        }
    }
}

