/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMargedRight;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ConnectionVerticalDown;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorAssembly
extends FtileFactoryDelegator {
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorAssembly(FtileFactory factory, ISkinParam skinParam) {
        super(factory, skinParam);
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        double height = 35.0;
        TextBlock textBlock = this.getTextBlock(this.getInLinkRenderingDisplay(tile2));
        StringBounder stringBounder = this.getStringBounder();
        if (textBlock != null) {
            height += textBlock.calculateDimension(stringBounder).getHeight();
        }
        Ftile tile1andSpace = FtileUtils.addBottom(tile1, height);
        Ftile result = super.assembly(tile1andSpace, tile2);
        FtileGeometry geo = tile1.calculateDimension(stringBounder);
        if (!geo.hasPointOut()) {
            return result;
        }
        UTranslate translate1 = result.getTranslateFor(tile1andSpace, stringBounder);
        Point2D p1 = geo.translate(translate1).getPointOut();
        UTranslate translate2 = result.getTranslateFor(tile2, stringBounder);
        Point2D p2 = tile2.calculateDimension(stringBounder).translate(translate2).getPointIn();
        HtmlColor color = this.getInLinkRenderingColor(tile2);
        ConnectionVerticalDown connection = new ConnectionVerticalDown(tile1, tile2, p1, p2, color, textBlock);
        result = FtileUtils.addConnection(result, connection);
        if (textBlock != null) {
            FtileGeometry dim = result.calculateDimension(stringBounder);
            double width = dim.getWidth();
            double maxX = connection.getMaxX(stringBounder);
            double needed = (maxX - width) * 2.0;
            if (width < maxX) {
                result = new FtileMargedRight(result, maxX);
            }
        }
        return result;
    }

    private TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        ISkinParam skinParam = this.getSkinParam();
        UFont font = skinParam.getFont(FontParam.ACTIVITY_ARROW, null, false);
        HtmlColor color = this.rose.getFontColor(skinParam, FontParam.ACTIVITY_ARROW);
        FontConfiguration fontConfiguration = new FontConfiguration(font, color, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, null, CreoleMode.SIMPLE_LINE);
    }
}

