/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileMarged
extends AbstractFtile {
    private final Ftile tile;
    private final double margin;

    public FtileMarged(Ftile tile, double margin) {
        super(tile.shadowing());
        this.tile = tile;
        this.margin = margin;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        return new FtileGeometry(orig.getWidth() + 2.0 * this.margin, orig.getHeight(), orig.getLeft() + this.margin, orig.getInY(), orig.getOutY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(new UTranslate(this.margin, 0.0)).draw(this.tile);
    }
}

