/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometryMerger;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileGeometry
extends Dimension2D {
    private final double width;
    private final double height;
    private final double left;
    private final double inY;
    private final double outY;

    public FtileGeometry(Dimension2D dim, double left, double inY) {
        this(dim.getWidth(), dim.getHeight(), left, inY);
    }

    public FtileGeometry(double width, double height, double left, double inY) {
        this(width, height, left, inY, Double.MIN_NORMAL);
    }

    public String toString() {
        return "[" + this.width + "x" + this.height + " left=" + this.left + "]";
    }

    @Override
    public void setSize(double width, double height) {
        throw new UnsupportedOperationException();
    }

    public FtileGeometry(double width, double height, double left, double inY, double outY) {
        this.left = left;
        this.inY = inY;
        this.outY = outY;
        this.width = width;
        this.height = height;
    }

    public FtileGeometry(Dimension2D dim, double left, double inY, double outY) {
        this(dim.getWidth(), dim.getHeight(), left, inY, outY);
    }

    public boolean hasPointOut() {
        return this.outY != Double.MIN_NORMAL;
    }

    public Point2D getPointIn() {
        return new Point2D.Double(this.left, this.inY);
    }

    public Point2D getPointOut() {
        if (this.outY == Double.MIN_NORMAL) {
            throw new UnsupportedOperationException();
        }
        return new Point2D.Double(this.left, this.outY);
    }

    public FtileGeometry withoutPointOut() {
        return new FtileGeometry(this.width, this.height, this.left, this.inY);
    }

    public FtileGeometry translate(UTranslate translate) {
        double dx = translate.getDx();
        double dy = translate.getDy();
        if (this.outY == Double.MIN_NORMAL) {
            return new FtileGeometry(this.width, this.height, this.left + dx, this.inY + dy);
        }
        return new FtileGeometry(this.width, this.height, this.left + dx, this.inY + dy, this.outY + dy);
    }

    public final double getInY() {
        return this.inY;
    }

    public final double getLeft() {
        return this.left;
    }

    public double getOutY() {
        return this.outY;
    }

    @Override
    public final double getWidth() {
        return this.width;
    }

    @Override
    public final double getHeight() {
        return this.height;
    }

    public FtileGeometry addDim(double deltaWidth, double deltaHeight) {
        return new FtileGeometry(this.width + deltaWidth, this.height + deltaHeight, this.left, this.inY, this.outY + deltaHeight);
    }

    public FtileGeometry addMarginX(double marginx) {
        return new FtileGeometry(this.width + 2.0 * marginx, this.height, this.left + marginx, this.inY, this.outY);
    }

    public FtileGeometry fixedHeight(double fixedHeight) {
        return new FtileGeometry(this.width, fixedHeight, this.left, this.inY, this.outY);
    }

    public FtileGeometry appendBottom(FtileGeometry other) {
        return new FtileGeometryMerger(this, other).getResult();
    }
}

