/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionSplit
implements Instruction {
    private final List<InstructionList> splits = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;

    public InstructionSplit(Instruction parent, LinkRendering inlinkRendering) {
        this.parent = parent;
        this.splits.add(new InstructionList());
        this.inlinkRendering = inlinkRendering;
    }

    private InstructionList getLast() {
        return this.splits.get(this.splits.size() - 1);
    }

    @Override
    public void add(Instruction ins) {
        this.getLast().add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.splits) {
            all.add(list.createFtile(factory));
        }
        return factory.createSplit(all);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void splitAgain(LinkRendering inlinkRendering) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        InstructionList list = new InstructionList();
        this.splits.add(list);
    }

    public void endSplit(LinkRendering inlinkRendering) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public void addNote(Display note, NotePosition position) {
        this.getLast().addNote(note, position);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.splits);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getLast().getSwimlaneOut();
    }
}

