var Protocol = require('../')
var test = require('tape')

test('Timeout and destroy when peer does not respond', function (t) {
  t.plan(7)

  var timeouts = 0

  var wire = new Protocol()
  wire.on('error', t.fail)
  wire.pipe(wire)
  wire.setTimeout(1000)
  wire.handshake(new Buffer('01234567890123456789'), new Buffer('12345678901234567890'))

  wire.on('unchoke', function () {
    var requests = 0

    wire.request(0, 0, 0, function (err) {
      t.ok(err)
      t.ok(++requests === 1)
    })

    wire.request(0, 0, 0, function (err) {
      t.ok(err)
      t.ok(++requests === 2)
    })

    wire.request(0, 0, 0, function (err) {
      t.ok(err)
      t.ok(++requests === 3)
    })
  })

  wire.on('timeout', function () {
    t.ok(++timeouts === 1)
    wire.end()
  })

  wire.unchoke()
})
