/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.debug.ui.actions;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.ide.dialogs.OpenResourceDialog;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.django.launching.PythonFileRunner;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.ConsoleColorCache;
import org.python.pydev.shared_ui.EditorUtils;

public abstract class DjangoAction
implements IObjectActionDelegate {
    protected IProject selectedProject;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedProject = null;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selections = (IStructuredSelection)selection;
        Object project = selections.getFirstElement();
        if (!(project instanceof IProject)) {
            return;
        }
        this.selectedProject = (IProject)project;
    }

    public void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    public ILaunch launchDjangoCommand(final String command, boolean refreshAndShowMessageOnFinish) {
        PythonNature nature = PythonNature.getPythonNature((IProject)this.selectedProject);
        if (nature == null) {
            MessageDialog.openError((Shell)EditorUtils.getShell(), (String)"PyDev nature not found", (String)"Unable to perform action because the Pydev nature is not properly set.");
            return null;
        }
        IPythonPathNature pythonPathNature = nature.getPythonPathNature();
        String manageVarible = null;
        Map variableSubstitution = null;
        try {
            variableSubstitution = pythonPathNature.getVariableSubstitution();
            manageVarible = (String)variableSubstitution.get("DJANGO_MANAGE_LOCATION");
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        if (manageVarible == null && (manageVarible = this.askNewManageSubstitution(pythonPathNature, variableSubstitution, StringUtils.format((String)"Unable to perform action because the %s \nsubstitution variable is not set.\n\nPlease select the manage.py to be used to run the action.", (Object[])new Object[]{"DJANGO_MANAGE_LOCATION"}))) == null) {
            return null;
        }
        IFile manageDotPy = this.selectedProject.getFile(manageVarible);
        if (manageDotPy == null || !manageDotPy.exists()) {
            manageVarible = this.askNewManageSubstitution(pythonPathNature, variableSubstitution, StringUtils.format((String)"Unable to perform action because the %s \nsubstitution variable is set to a non existing file.\n\nPlease select the manage.py to be used to run the action.", (Object[])new Object[]{"DJANGO_MANAGE_LOCATION"}));
            if (manageVarible == null) {
                return null;
            }
            manageDotPy = this.selectedProject.getFile(manageVarible);
        }
        final IFile finalManageDotPy = manageDotPy;
        try {
            ILaunch launch = PythonFileRunner.launch(manageDotPy, command);
            final IProcess[] processes = launch.getProcesses();
            ProcessConsoleManager consoleManager = DebugUIPlugin.getDefault().getProcessConsoleManager();
            if (processes.length >= 1) {
                IConsole console = consoleManager.getConsole(processes[0]);
                final IOConsoleOutputStream outputStream = ((IOConsole)console).newOutputStream();
                HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
                themeConsoleStreamToColor.put(outputStream, "console.output");
                ((IOConsole)console).setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
                ConsoleColorCache.getDefault().keepConsoleColorsSynched((IOConsole)console);
                Job j = new Job("Refresh on finish"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        boolean allTerminated = false;
                        while (!allTerminated) {
                            1 p;
                            allTerminated = true;
                            IProcess[] iProcessArray = processes;
                            int n = processes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                p = iProcessArray[n2];
                                if (!p.isTerminated()) {
                                    allTerminated = false;
                                    break;
                                }
                                ++n2;
                            }
                            p = this;
                            synchronized (p) {
                                try {
                                    ((Object)((Object)this)).wait(50L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        try {
                            outputStream.write(StringUtils.format((String)("Finished \"" + finalManageDotPy.getLocation().toOSString() + " " + command + "\" execution."), (Object[])new Object[0]));
                        }
                        catch (IOException e1) {
                            Log.log((Throwable)e1);
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException e1) {
                            Log.log((Throwable)e1);
                        }
                        try {
                            DjangoAction.this.selectedProject.refreshLocal(2, null);
                        }
                        catch (CoreException e) {
                            Log.log((Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                j.setSystem(true);
                j.schedule();
            }
            return launch;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String askNewManageSubstitution(IPythonPathNature pythonPathNature, Map<String, String> variableSubstitution, String message) {
        String manageVarible = null;
        OpenResourceDialog manageSelectionDialog = this.createManageSelectionDialog(message);
        if (manageSelectionDialog.open() != 0) return null;
        Object firstResult = manageSelectionDialog.getFirstResult();
        if (firstResult instanceof IFile) {
            IFile iFile = (IFile)firstResult;
            IPath projectRelativePath = iFile.getProjectRelativePath();
            manageVarible = projectRelativePath.toPortableString();
            variableSubstitution.put("DJANGO_MANAGE_LOCATION", manageVarible);
            try {
                pythonPathNature.setVariableSubstitution(variableSubstitution);
                return manageVarible;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            return manageVarible;
        } else {
            Log.log((String)("Error. Expected IFile selected. Found: " + firstResult.getClass()));
            return null;
        }
    }

    private OpenResourceDialog createManageSelectionDialog(String message) {
        OpenResourceDialog resourceDialog = new OpenResourceDialog(EditorUtils.getShell(), (IContainer)this.selectedProject, 1);
        try {
            Field field = FilteredItemsSelectionDialog.class.getDeclaredField("multi");
            field.setAccessible(true);
            field.set(resourceDialog, false);
        }
        catch (Throwable throwable) {}
        resourceDialog.setInitialPattern("manage.py");
        resourceDialog.setMessage(message);
        return resourceDialog;
    }
}

