/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.partition;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.python.pydev.shared_core.partitioner.IChangeTokenRule;
import org.python.pydev.shared_core.partitioner.IMarkScanner;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class SingleLineRuleWithMultipleStarts
implements IPredicateRule,
IChangeTokenRule {
    protected IToken fToken;
    private final char escapeCharacter;
    private final boolean escapeContinuesLine;
    private ArrayList<char[]> fStartSequences;
    private char[] fEndSequence;

    public void setToken(IToken token) {
        this.fToken = token;
    }

    public SingleLineRuleWithMultipleStarts(String[] startSequences, String endSequence, Token token, char escapeCharacter, boolean escapeContinuesLine) {
        ArrayList<char[]> lst = new ArrayList<char[]>(startSequences.length);
        String[] stringArray = startSequences;
        int n = startSequences.length;
        int n2 = 0;
        while (n2 < n) {
            String start = stringArray[n2];
            lst.add(start.toCharArray());
            ++n2;
        }
        this.fStartSequences = lst;
        this.fEndSequence = endSequence.toCharArray();
        this.fToken = token;
        this.escapeCharacter = escapeCharacter;
        this.escapeContinuesLine = escapeContinuesLine;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.detectEnd(scanner)) {
                return this.fToken;
            }
        } else {
            IMarkScanner markScanner = (IMarkScanner)scanner;
            int mark = markScanner.getMark();
            int size = this.fStartSequences.size();
            int j = 0;
            while (j < size) {
                boolean found = true;
                char[] startSequence = this.fStartSequences.get(j);
                int i = 0;
                while (i < startSequence.length) {
                    int c = scanner.read();
                    if (c != startSequence[i]) {
                        found = false;
                        markScanner.setMark(mark);
                        break;
                    }
                    ++i;
                }
                if (found) break;
                if (j == size - 1) {
                    return Token.UNDEFINED;
                }
                ++j;
            }
            if (this.detectEnd(scanner)) {
                return this.fToken;
            }
            markScanner.setMark(mark);
        }
        return Token.UNDEFINED;
    }

    private boolean detectEnd(ICharacterScanner scanner) {
        int c;
        while (true) {
            if ((c = scanner.read()) == -1) {
                return true;
            }
            if (c == this.escapeCharacter) {
                if (this.escapeContinuesLine) {
                    c = scanner.read();
                    if (c != 13 || (c = scanner.read()) == 10) continue;
                    scanner.unread();
                    continue;
                }
                c = scanner.read();
                if (c == 13 || c == 10) {
                    scanner.unread();
                }
                return true;
            }
            if (c == 13 || c == 10) {
                return true;
            }
            if (c == this.fEndSequence[0]) break;
        }
        boolean found = true;
        int i = 1;
        while (i < this.fEndSequence.length) {
            c = scanner.read();
            if (c != this.fEndSequence[i]) {
                found = false;
                scanner.unread();
                int j = 0;
                while (j < i) {
                    scanner.unread();
                    ++j;
                }
                break;
            }
            ++i;
        }
        return found;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer("SingleLineRuleWithMultipleStarts(", this.fEndSequence.length + 40);
        buf.append("start: ");
        for (char[] chars : this.fStartSequences) {
            buf.append(chars).append(",\n");
        }
        buf.append("end: ").append(this.fEndSequence).append(")");
        return buf.toString();
    }
}

