/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.log;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_ui.ConsoleColorCache;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class Log {
    private static MessageConsole fConsole;
    private static IOConsoleOutputStream fOutputStream;
    private static final Object lock;
    private static final StringBuffer logIndent;
    private static boolean firstCall;

    static {
        lock = new Object();
        logIndent = new StringBuffer();
        firstCall = true;
    }

    public static CoreException log(int errorLevel, String message, Throwable e) {
        return org.python.pydev.shared_core.log.Log.log((int)errorLevel, (String)message, (Throwable)e);
    }

    public static CoreException log(Throwable e) {
        return Log.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten (null message).", e);
    }

    public static CoreException log(String msg) {
        return Log.log(4, msg, new RuntimeException(msg));
    }

    public static CoreException log(String msg, Throwable e) {
        return Log.log(4, msg, e);
    }

    public static CoreException logInfo(Throwable e) {
        return Log.log(1, e.getMessage(), e);
    }

    public static CoreException logInfo(String msg) {
        return Log.log(1, msg, new RuntimeException(msg));
    }

    public static CoreException logWarn(String msg) {
        return Log.log(2, msg, new RuntimeException(msg));
    }

    public static CoreException logInfo(String msg, Throwable e) {
        return Log.log(1, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toLogFile(Object obj, String string) {
        Object object = lock;
        synchronized (object) {
            if (obj == null) {
                obj = new Object();
            }
            Class<?> class1 = obj.getClass();
            Log.toLogFile(string, class1);
        }
    }

    public static void toLogFile(String string, Class<? extends Object> class1) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(logIndent);
        buffer.append(FullRepIterable.getLastPart(class1.getName()));
        buffer.append(": ");
        buffer.append(string);
        Log.toLogFile(buffer.toString());
    }

    public static String getLogOutputFile() {
        try {
            CorePlugin default1 = CorePlugin.getDefault();
            if (default1 != null) {
                IPath stateLocation = default1.getStateLocation().append("PyDevLog.log");
                return stateLocation.toOSString();
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toLogFile(final String buffer) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    try {
                        IOConsoleOutputStream c = Log.getConsoleOutputStream();
                        c.write(buffer.toString());
                        c.write(System.lineSeparator());
                    }
                    catch (Throwable e) {
                        Log.log(e);
                    }
                }
            }
        };
        String file = Log.getLogOutputFile();
        Object object = lock;
        synchronized (object) {
            block11: {
                System.out.println(buffer);
                if (file == null) {
                    return;
                }
                if (firstCall) {
                    try {
                        try {
                            File f = new File(file);
                            if (f.length() > 0x100000L) {
                                f.delete();
                            }
                        }
                        catch (Exception e) {
                            Log.log(e);
                            firstCall = false;
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        firstCall = false;
                        throw throwable;
                    }
                    firstCall = false;
                }
            }
            FileUtils.appendStrToFile((String)(String.valueOf(buffer) + System.lineSeparator()), (String)file);
        }
        RunInUiThread.async((Runnable)r, (boolean)true);
    }

    private static IOConsoleOutputStream getConsoleOutputStream() {
        if (fConsole == null) {
            fConsole = new MessageConsole("PyDev Logging", CorePlugin.getImageCache().getDescriptor("icons/python_logging.png"));
            fOutputStream = fConsole.newOutputStream();
            HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
            themeConsoleStreamToColor.put(fOutputStream, "console.output");
            fConsole.setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
            ConsoleColorCache.getDefault().keepConsoleColorsSynched((IOConsole)fConsole);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
        }
        return fOutputStream;
    }

    public static void toLogFile(Exception e) {
        String msg = Log.getExceptionStr(e);
        Log.toLogFile(msg);
    }

    public static String getExceptionStr(Exception e) {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        PrintStream prnt = new PrintStream(str);
        e.printStackTrace(prnt);
        prnt.flush();
        String msg = new String(str.toByteArray());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogLevel() {
        Object object = lock;
        synchronized (object) {
            logIndent.append("    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remLogLevel() {
        Object object = lock;
        synchronized (object) {
            if (logIndent.length() > 3) {
                logIndent.delete(0, 4);
            }
        }
    }
}

