/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.parser.grammarcommon.ComprehensionCollection;
import org.python.pydev.parser.grammarcommon.CtxVisitor;
import org.python.pydev.parser.grammarcommon.DefaultArg;
import org.python.pydev.parser.grammarcommon.ExtraArg;
import org.python.pydev.parser.grammarcommon.ExtraArgValue;
import org.python.pydev.parser.grammarcommon.ITreeBuilder;
import org.python.pydev.parser.grammarcommon.ITreeConstants;
import org.python.pydev.parser.grammarcommon.JJTPythonGrammarState;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;

public abstract class AbstractTreeBuilderHelpers
implements ITreeBuilder,
ITreeConstants {
    protected final JJTPythonGrammarState stack;
    protected CtxVisitor ctx;
    protected SimpleNode lastPop;

    public AbstractTreeBuilderHelpers(JJTPythonGrammarState stack) {
        this.stack = stack;
        this.ctx = new CtxVisitor(stack);
    }

    protected final stmtType[] makeStmts(int l) throws ParseException {
        stmtType[] stmts = new stmtType[l];
        int i = l - 1;
        while (i >= 0) {
            SimpleNode node = this.stack.popNode();
            try {
                stmts[i] = (stmtType)node;
            }
            catch (ClassCastException e) {
                if (node instanceof Yield) {
                    stmts[i] = new Expr((Yield)node);
                    String msg = "Error. Found yield out of scope.";
                    ParseException e2 = new ParseException(msg, node);
                    this.stack.getGrammar().addAndReport(e2, msg);
                }
                this.recoverFromClassCastException(node, e);
                stmts[i] = new Pass();
            }
            --i;
        }
        return stmts;
    }

    protected final void recoverFromClassCastException(SimpleNode node, ClassCastException e) throws ParseException {
        String msg = "ClassCastException: was: " + e.getMessage() + " (" + node + "). Expected: stmtType";
        ParseException e2 = new ParseException(msg, node);
        this.stack.getGrammar().addAndReport(e2, msg);
    }

    protected final stmtType[] popSuite() {
        return this.getBodyAndSpecials();
    }

    protected final exprType[] makeExprs() {
        SimpleNode commaNode = null;
        if (this.stack.nodeArity() > 0 && this.stack.peekNode().getId() == 533) {
            commaNode = this.stack.popNode();
        }
        int arity = this.stack.nodeArity();
        exprType[] exprs = this.makeExprs(arity);
        if (commaNode != null && arity > 0) {
            exprs[arity - 1].addSpecial(new SpecialStr(",", commaNode.beginLine, commaNode.beginColumn), true);
        }
        return exprs;
    }

    /*
     * Unable to fully structure code
     */
    protected final SimpleNode makeTuple(SimpleNode n) throws ParseException {
        try {
            endsWithComma = false;
            if (this.stack.nodeArity() > 0 && this.stack.peekNode().getId() == 533) {
                endsWithComma = true;
            }
            if (!endsWithComma && this.stack.nodeArity() == 1) {
                tokenSourceSpecialTokensList = this.stack.getGrammar().getTokenSourceSpecialTokensList();
                for (Object object : tokenSourceSpecialTokensList) {
                    if (object instanceof Object[]) {
                        objects = (Object[])object;
                        object = objects[0];
                    }
                    if (!(object instanceof ISpecialStr) || !(specialStr = (ISpecialStr)object).toString().equals(",")) continue;
                    endsWithComma = true;
                    break;
                }
            }
            exp = this.makeExprs();
            t = new Tuple(exp, 1, endsWithComma);
            this.addSpecialsAndClearOriginal(n, t);
            return t;
        }
        catch (ClassCastException e) {
            if (e.getMessage().equals(ExtraArgValue.class.getName())) {
                this.stack.getGrammar().addAndReport(new ParseException("Token: '*' is not expected inside tuples.", this.lastPop), "Treated class cast exception on tuple");
            }
            this.stack.getGrammar().addAndReport(new ParseException("Syntax error while detecting tuple.", this.lastPop), "Treated class cast exception on tuple");
            ** while (this.stack.nodeArity() > 0)
        }
lbl-1000:
        // 1 sources

        {
            this.stack.popNode();
            continue;
        }
lbl26:
        // 1 sources

        return new Tuple(new exprType[0], 1, false);
    }

    protected final exprType[] makeExprs(int l) {
        exprType[] exprs = new exprType[l];
        int i = l - 1;
        while (i >= 0) {
            this.lastPop = this.stack.popNode();
            exprs[i] = (exprType)this.lastPop;
            --i;
        }
        return exprs;
    }

    protected final NameTok makeName(int ctx) throws ParseException {
        SimpleNode popNode = this.stack.popNode();
        if (!(popNode instanceof Name)) {
            this.stack.getGrammar().addAndReport(new ParseException("Syntax error. Expected Name, found: " + popNode.getClass().getName(), popNode), "Treated class cast exception making name");
            popNode = new Name("invalid", ctx, false);
        }
        Name name = (Name)popNode;
        return this.makeName(ctx, name);
    }

    protected final NameTok makeName(int ctx, Name name) {
        NameTok n = new NameTok(name.id, ctx);
        n.beginColumn = name.beginColumn;
        n.beginLine = name.beginLine;
        this.addSpecials(name, n);
        name.specialsBefore = n.getSpecialsBefore();
        name.specialsAfter = n.getSpecialsAfter();
        return n;
    }

    protected final NameTok[] makeIdentifiers(int ctx) throws ParseException {
        int l = this.stack.nodeArity();
        return this.makeIdentifiers(ctx, l);
    }

    protected final NameTok[] makeIdentifiers(int ctx, int arity) throws ParseException {
        NameTok[] ids = new NameTok[arity];
        int i = arity - 1;
        while (i >= 0) {
            ids[i] = this.makeName(ctx);
            --i;
        }
        return ids;
    }

    protected final Suite popSuiteAndSuiteType() {
        Suite s = (Suite)this.stack.popNode();
        Suite orelseSuite = (Suite)this.stack.popNode();
        orelseSuite.body = s.body;
        this.addSpecialsAndClearOriginal(s, orelseSuite);
        return orelseSuite;
    }

    protected final void addSpecialsAndClearOriginal(SimpleNode from, SimpleNode to) {
        this.addSpecials(from, to);
        if (from.specialsBefore != null) {
            from.specialsBefore.clear();
        }
        if (from.specialsAfter != null) {
            from.specialsAfter.clear();
        }
    }

    protected final void addSpecials(SimpleNode from, SimpleNode to) {
        if (from.specialsBefore != null && from.specialsBefore.size() > 0) {
            to.getSpecialsBefore().addAll(from.specialsBefore);
        }
        if (from.specialsAfter != null && from.specialsAfter.size() > 0) {
            to.getSpecialsAfter().addAll(from.specialsAfter);
        }
    }

    protected final void addSpecialsBefore(SimpleNode from, SimpleNode to) {
        if (from.specialsBefore != null && from.specialsBefore.size() > 0) {
            to.getSpecialsBefore().addAll(from.specialsBefore);
        }
        if (from.specialsAfter != null && from.specialsAfter.size() > 0) {
            to.getSpecialsBefore().addAll(from.specialsAfter);
        }
    }

    protected final void setParentForFuncOrClass(stmtType[] body, stmtType classDef) {
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType b = stmtTypeArray[n2];
            if (b instanceof ClassDef) {
                ((ClassDef)b).parent = classDef;
            } else if (b instanceof FunctionDef) {
                ((FunctionDef)b).parent = classDef;
            }
            ++n2;
        }
    }

    protected final stmtType[] getBodyAndSpecials() {
        Suite suite = (Suite)this.stack.popNode();
        stmtType[] body = suite.body;
        if (body == null) {
            body = new stmtType[]{};
        }
        if (body.length > 0) {
            if (suite.specialsBefore != null && suite.specialsBefore.size() > 0) {
                body[0].getSpecialsBefore().addAll(suite.specialsBefore);
            }
            if (suite.specialsAfter != null && suite.specialsAfter.size() > 0) {
                body[body.length - 1].getSpecialsAfter().addAll(suite.specialsAfter);
            }
        }
        return body;
    }

    protected final SimpleNode makeDecorator(List<SimpleNode> nodes) {
        exprType starargs = null;
        exprType kwargs = null;
        exprType func = null;
        ArrayList<keywordType> keywordsl = new ArrayList<keywordType>();
        ArrayList<SimpleNode> argsl = new ArrayList<SimpleNode>();
        Iterator<SimpleNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            ExtraArgValue extraArg;
            SimpleNode node = iter.next();
            if (node.getId() == 553) {
                extraArg = (ExtraArgValue)node;
                kwargs = extraArg.value;
                this.addSpecialsAndClearOriginal(extraArg, kwargs);
                extraArg.specialsBefore = kwargs.getSpecialsBefore();
                extraArg.specialsAfter = kwargs.getSpecialsAfter();
                continue;
            }
            if (node.getId() == 551) {
                extraArg = (ExtraArgValue)node;
                starargs = extraArg.value;
                this.addSpecialsAndClearOriginal(extraArg, starargs);
                extraArg.specialsBefore = starargs.getSpecialsBefore();
                extraArg.specialsAfter = starargs.getSpecialsAfter();
                continue;
            }
            if (node instanceof keywordType) {
                keywordType keyword = (keywordType)node;
                if (starargs == null) {
                    keyword.afterstarargs = true;
                }
                keywordsl.add(keyword);
                continue;
            }
            if (this.isArg(node)) {
                argsl.add(node);
                continue;
            }
            if (node instanceof Comprehension) {
                argsl.add(new ListComp((exprType)iter.next(), new comprehensionType[]{(comprehensionType)node}, 3));
                continue;
            }
            if (node instanceof ComprehensionCollection) {
                argsl.add(new ListComp((exprType)iter.next(), ((ComprehensionCollection)node).getGenerators(), 3));
                continue;
            }
            if (node instanceof decoratorsType) {
                func = (exprType)this.stack.popNode();
                decoratorsType d = (decoratorsType)node;
                d.func = func;
                d.args = argsl.toArray(new exprType[0]);
                d.keywords = keywordsl.toArray(new keywordType[0]);
                d.starargs = starargs;
                d.kwargs = kwargs;
                return d;
            }
            argsl.add(node);
        }
        throw new RuntimeException("Something wrong happened while making the decorators...");
    }

    protected final aliasType[] makeAliases(int l) {
        aliasType[] aliases = new aliasType[l];
        int i = l - 1;
        while (i >= 0) {
            aliases[i] = (aliasType)this.stack.popNode();
            --i;
        }
        return aliases;
    }

    protected final boolean isArg(SimpleNode n) {
        return n instanceof ExtraArg || n instanceof DefaultArg || n instanceof keywordType;
    }

    protected final SimpleNode defaultCreateDictionary(int arity) {
        boolean isDictComplete = arity % 2 == 0;
        int l = arity / 2;
        exprType[] keys = isDictComplete ? new exprType[l] : new exprType[l + 1];
        exprType[] vals = new exprType[l];
        int i = l - 1;
        while (i >= 0) {
            vals[i] = (exprType)this.stack.popNode();
            keys[i] = (exprType)this.stack.popNode();
            --i;
        }
        if (!isDictComplete) {
            keys[keys.length - 1] = (exprType)this.stack.popNode();
        }
        return new Dict(keys, vals);
    }
}

