/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.python.pydev.parser.grammarcommon.AbstractTokenManagerWithConstants;
import org.python.pydev.parser.grammarcommon.ITokenManager;
import org.python.pydev.parser.grammarcommon.ITreeConstants;
import org.python.pydev.parser.grammarcommon.IndentLevel;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.shared_core.utils.Reflection;

public abstract class AbstractTokenManager
extends AbstractTokenManagerWithConstants
implements ITreeConstants,
ITokenManager {
    protected final IndentLevel indentation = new IndentLevel();
    protected int levelBeforeEof = -1;
    protected int parens = 0;
    protected int indent;
    public final List<Object> specialTokens = new ArrayList<Object>();
    private FastCharStream inputStream;
    private Map<String, Integer> tokenToIdCache;
    public static int CUSTOM_NOT_CREATED = 0;
    public static int CUSTOM_CREATED_NOT_PARENS = 1;
    public static int CUSTOM_CREATED_WAS_PARENS = 2;

    @Override
    public final FastCharStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = (FastCharStream)Reflection.getAttrObj((Object)this, (String)"input_stream", (boolean)true);
        }
        return this.inputStream;
    }

    protected final int getCurLexState() {
        return (Integer)Reflection.getAttrObj((Object)this, (String)"curLexState", (boolean)true);
    }

    @Override
    public abstract Token getNextToken();

    protected AbstractTokenManager() {
    }

    protected final Token createFrom(Token previous, int kind, String image) {
        Token t = new Token();
        t.kind = kind;
        t.beginLine = previous.beginLine;
        t.endLine = previous.endLine;
        t.beginColumn = previous.beginColumn;
        t.endColumn = previous.endColumn;
        t.image = image;
        t.specialToken = null;
        t.next = null;
        return t;
    }

    protected final Token createFromAndSetAsNext(Token previous, int kind, String image) {
        Token t = this.createFrom(previous, kind, image);
        Token oldNext = previous.next;
        previous.next = t;
        t.next = oldNext;
        return t;
    }

    protected final Token addDedent(Token previous) {
        return this.createFromAndSetAsNext(previous, this.getDedentId(), "<DEDENT>");
    }

    private Map<String, Integer> getTokenToId() {
        if (this.tokenToIdCache == null) {
            this.tokenToIdCache = new HashMap<String, Integer>();
            this.tokenToIdCache.put(")", this.getRparenId());
            this.tokenToIdCache.put("]", this.getRbracketId());
            this.tokenToIdCache.put("}", this.getRbraceId());
            this.tokenToIdCache.put(":", this.getColonId());
            this.tokenToIdCache.put("(", this.getLparenId());
            this.tokenToIdCache.put(",", this.getCommaId());
        }
        return this.tokenToIdCache;
    }

    public int addCustom(Token curr, String token) {
        Integer id = this.getTokenToId().get(token);
        if (id != null) {
            this.createFromAndSetAsNext(curr, id, token);
            int ret = CUSTOM_CREATED_NOT_PARENS;
            if (id.intValue() == this.getRparenId() || id.intValue() == this.getRbracketId() || id.intValue() == this.getRbraceId()) {
                --this.parens;
                ret = CUSTOM_CREATED_WAS_PARENS;
            } else if (id.intValue() == this.getLparenId()) {
                ++this.parens;
                ret = CUSTOM_CREATED_WAS_PARENS;
            }
            return ret;
        }
        return CUSTOM_NOT_CREATED;
    }

    protected final void CommonTokenAction(Token initial) {
        Token t = initial;
        int i = this.specialTokens.size();
        while (t.specialToken != null) {
            this.specialTokens.add(i, t.specialToken);
            t = t.specialToken;
        }
        t = initial;
        if (t.kind == this.getEofId()) {
            this.levelBeforeEof = this.indentation.level;
            if (this.getCurLexState() == this.getLexerDefaultId()) {
                t.kind = this.getNewlineId();
            } else {
                t.kind = this.getDedentId();
                if (this.indentation.level >= 0) {
                    --this.indentation.level;
                }
            }
            while (this.indentation.level >= 0) {
                --this.indentation.level;
                t = this.addDedent(t);
            }
            t.kind = this.getEofId();
            t.image = "<EOF>";
        }
    }

    @Override
    public abstract void indenting(int var1);

    public abstract int getCurrentLineIndentation();

    public abstract int getLastIndentation();
}

