/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.docutils.TabNannyDocIterator;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.parsing.IScopesParser;
import org.python.pydev.shared_core.parsing.Scopes;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple3;

public class ScopesParser
implements IScopesParser {
    private Scopes scopes;
    private SortedMap<Integer, Integer> lineOffsetToIndent;
    private IDocument doc;

    public Scopes createScopes(IDocument doc) {
        this.scopes = new Scopes();
        this.doc = doc;
        this.lineOffsetToIndent = new TreeMap<Integer, Integer>();
        try {
            TabNannyDocIterator nannyDocIterator = new TabNannyDocIterator(doc, true, false);
            while (nannyDocIterator.hasNext()) {
                Tuple3 next = nannyDocIterator.next();
                this.lineOffsetToIndent.put((Integer)next.o2, ((String)next.o1).length());
            }
        }
        catch (BadLocationException e1) {
            throw new RuntimeException(e1);
        }
        try {
            return this.createScopes();
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    private Scopes createScopes() throws SyntaxErrorException {
        int globalScope = this.scopes.startScope(0, 4);
        int offset = this.createInternalScopes(ParsingUtils.create((Object)this.doc, (boolean)true), 0);
        this.scopes.endScope(globalScope, offset, 4);
        return this.scopes;
    }

    private int createInternalScopes(ParsingUtils parsingUtils, int offsetDelta) {
        int docLen = parsingUtils.len();
        int offset = 0;
        FastStringBuffer lineMemo = new FastStringBuffer();
        int memoStart = 0;
        while (offset < docLen) {
            char ch = parsingUtils.charAt(offset);
            switch (ch) {
                case '#': {
                    int id = this.scopes.startScope(offsetDelta + offset, Scopes.TYPE_COMMENT);
                    offset = parsingUtils.eatComments(null, offset);
                    this.scopes.endScope(id, offsetDelta + offset, Scopes.TYPE_COMMENT);
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    int id;
                    int baseOffset = offset;
                    try {
                        offset = parsingUtils.eatPar(offset, null, ch);
                        id = this.scopes.startScope(offsetDelta + baseOffset + 1, 2);
                        try {
                            String cs = this.doc.get(offsetDelta + baseOffset + 1, offset - baseOffset - 1);
                            this.createInternalScopes(ParsingUtils.create((Object)cs, (boolean)true), offsetDelta + baseOffset + 1);
                        }
                        catch (BadLocationException e1) {
                            Log.log((Throwable)e1);
                        }
                        this.scopes.endScope(id, offsetDelta + offset, 2);
                    }
                    catch (SyntaxErrorException syntaxErrorException) {}
                    break;
                }
                case '\"': 
                case '\'': {
                    int id;
                    int baseOffset = offset;
                    try {
                        offset = parsingUtils.eatLiterals(null, offset);
                        id = this.scopes.startScope(offsetDelta + baseOffset, 3);
                        this.scopes.endScope(id, offsetDelta + offset + 1, 3);
                    }
                    catch (SyntaxErrorException syntaxErrorException) {}
                    break;
                }
                case ':': {
                    if (!PySelection.startsWithIndentToken((String)lineMemo.toString().trim())) break;
                    SortedMap<Integer, Integer> subMap = this.lineOffsetToIndent.tailMap(offsetDelta + memoStart + 1);
                    Integer level = (Integer)this.lineOffsetToIndent.get(offsetDelta + memoStart);
                    if (level == null) break;
                    Set<Map.Entry<Integer, Integer>> entrySet = subMap.entrySet();
                    boolean found = false;
                    int id = this.scopes.startScope(memoStart + level, 5);
                    int id2 = -1;
                    int j = offset + 1;
                    while (j < docLen) {
                        char c = parsingUtils.charAt(j);
                        if (!Character.isWhitespace(c)) {
                            if (c == '#') {
                                j = parsingUtils.eatComments(null, j);
                            } else {
                                id2 = this.scopes.startScope(offsetDelta + j, 5);
                                break;
                            }
                        }
                        ++j;
                    }
                    for (Map.Entry<Integer, Integer> entry : entrySet) {
                        if (level < entry.getValue()) continue;
                        found = true;
                        Integer scopeEndOffset = entry.getKey();
                        try {
                            int line = this.doc.getLineOfOffset(scopeEndOffset.intValue());
                            if (line > 0) {
                                IRegion lineInformation = this.doc.getLineInformation(line - 1);
                                scopeEndOffset = lineInformation.getOffset() + lineInformation.getLength();
                            }
                        }
                        catch (BadLocationException e) {
                            Log.log((Throwable)e);
                        }
                        this.scopes.endScope(id, scopeEndOffset.intValue(), 5);
                        if (id2 <= 0) break;
                        this.scopes.endScope(id2, scopeEndOffset.intValue(), 5);
                        break;
                    }
                    if (found) break;
                    this.scopes.endScope(id, offsetDelta + parsingUtils.len(), 5);
                    if (id2 <= 0) break;
                    this.scopes.endScope(id2, offsetDelta + parsingUtils.len(), 5);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (lineMemo.length() <= 0 || lineMemo.lastChar() == '\\') break;
                    lineMemo.clear();
                    break;
                }
                default: {
                    if (lineMemo.length() == 0) {
                        memoStart = offset;
                    }
                    lineMemo.append(ch);
                }
            }
            ++offset;
        }
        return offset;
    }
}

