/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.editor.templates.TemplateHelper;
import org.python.pydev.plugin.PydevPlugin;

public class TemplateSelectDialog
extends SelectionDialog {
    private Label label;
    private Table templateList;
    private TreeMap<String, TemplatePersistenceData> nameToTemplateData;
    private IDialogSettings fDialogSettings;
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";

    protected TemplateSelectDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topLevel = (Composite)super.createDialogArea(parent);
        this.createTemplateOptions(topLevel);
        return topLevel;
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        PydevPlugin.setCssId(parent, "py-template-select-dialog", true);
        return ret;
    }

    private void createTemplateOptions(Composite topLevel) {
        TemplatePersistenceData[] templateData;
        final TemplateStore templateStore = TemplateHelper.getTemplateStore();
        if (templateStore != null && (templateData = templateStore.getTemplateData(false)) != null && templateData.length > 0) {
            this.label = new Label(topLevel, 0);
            this.label.setText("Template");
            this.templateList = new Table(topLevel, 2820);
            this.fillTemplateOptions(templateData, this.templateList);
            this.templateList.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                    TemplateSelectDialog.this.okPressed();
                }
            });
            Link link = new Link(topLevel, 0);
            link.setText("<a>Config available templates...</a>");
            link.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.python.pydev.prefs.template", null, null);
                    dialog.open();
                    TemplatePersistenceData[] templateData = templateStore.getTemplateData(false);
                    if (templateData != null && templateData.length > 0) {
                        TemplateSelectDialog.this.fillTemplateOptions(templateData, TemplateSelectDialog.this.templateList);
                    } else {
                        TemplateSelectDialog.this.fillTemplateOptions(new TemplatePersistenceData[0], TemplateSelectDialog.this.templateList);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.setLayout(this.label, (Control)this.templateList, (Control)link);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_BOUNDS_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            section.put(DIALOG_HEIGHT, 500);
            section.put(DIALOG_WIDTH, 600);
        }
        return section;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PydevPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(TemplateSelectDialog.class.getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(TemplateSelectDialog.class.getName());
        }
        return this.fDialogSettings;
    }

    private void fillTemplateOptions(TemplatePersistenceData[] templateData, Table list) {
        this.nameToTemplateData = new TreeMap();
        TemplatePersistenceData[] templatePersistenceDataArray = templateData;
        int n = templateData.length;
        int n2 = 0;
        while (n2 < n) {
            TemplatePersistenceData data = templatePersistenceDataArray[n2];
            if ("org.python.pydev.editor.templates.python.modules".equals(data.getTemplate().getContextTypeId())) {
                String name = data.getTemplate().getName();
                this.nameToTemplateData.put(name, data);
            }
            ++n2;
        }
        ArrayList<String> lst = new ArrayList<String>(this.nameToTemplateData.keySet());
        for (String string : lst) {
            new TableItem(list, 0).setText(string);
        }
        list.setSelection(0);
    }

    protected void okPressed() {
        TemplatePersistenceData selectedTemplate = this.getCurr();
        this.setResult(Arrays.asList(selectedTemplate));
        super.okPressed();
    }

    private TemplatePersistenceData getCurr() {
        TableItem[] sel;
        if (this.templateList != null && this.nameToTemplateData != null && (sel = this.templateList.getSelection()) != null && sel.length > 0) {
            return this.nameToTemplateData.get(sel[0].getText(0));
        }
        return null;
    }

    public TemplatePersistenceData getSelectedTemplate() {
        Object[] r = this.getResult();
        if (r != null && r.length > 0) {
            return (TemplatePersistenceData)r[0];
        }
        return null;
    }

    private void setLayout(Label label, Control control, Control link) {
        GridData data;
        if (label != null) {
            data = new GridData();
            data.grabExcessHorizontalSpace = false;
            label.setLayoutData((Object)data);
        }
        if (control != null) {
            data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            control.setLayoutData((Object)data);
        }
        if (link != null) {
            data = new GridData();
            link.setLayoutData((Object)data);
        }
    }
}

