/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.AbstractPythonWizardPage;

public class PythonExistingSourceFolderWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonExistingSourceFolderWizard";

    public PythonExistingSourceFolderWizard() {
        super("Add pre-existing source folders from external locations.");
    }

    @Override
    protected AbstractPythonWizardPage createPathPage() {
        return new AbstractPythonWizardPage(this.description, this.selection){

            @Override
            protected boolean shouldCreateSourceFolderSelect() {
                return false;
            }

            @Override
            protected boolean shouldCreatePackageSelect() {
                return false;
            }

            @Override
            protected boolean shouldCreateExistingSourceFolderSelect() {
                return true;
            }

            @Override
            protected boolean checkAdditionalErrors() {
                return false;
            }
        };
    }

    @Override
    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        IPythonNature nature;
        IProject project = this.filePage.getValidatedProject();
        String name = this.filePage.getValidatedName();
        IPath source = this.filePage.getSourceToLink();
        if (project == null || !project.exists()) {
            throw new RuntimeException("The project selected does not exist in the workspace.");
        }
        IPythonPathNature pathNature = PythonNature.getPythonPathNature(project);
        if (pathNature == null && (pathNature = (nature = PythonNature.addNature(project, monitor, null, null, null, null, null)).getPythonPathNature()) == null) {
            throw new RuntimeException("Unable to add the nature to the seleted project.");
        }
        if (source == null || !source.toFile().exists()) {
            throw new RuntimeException("The source to link to, " + source.toString() + ", does not exist.");
        }
        IFolder folder = project.getFolder(name);
        if (!folder.exists()) {
            folder.createLink(source, 128, monitor);
        }
        String newPath = folder.getFullPath().toString();
        String curr = pathNature.getProjectSourcePath(true);
        if (curr == null) {
            curr = "";
        }
        if (curr.endsWith("|")) {
            curr = curr.substring(0, curr.length() - 1);
        }
        String newPathRel = PyStructureConfigHelpers.convertToProjectRelativePath(project.getFullPath().toString(), newPath);
        if (curr.length() > 0) {
            Set projectSourcePathSet = pathNature.getProjectSourcePathSet(true);
            if (!projectSourcePathSet.contains(newPath)) {
                curr = String.valueOf(curr) + "|" + newPathRel;
            }
        } else {
            curr = newPathRel;
        }
        pathNature.setProjectSourcePath(curr);
        PythonNature.getPythonNature(project).rebuildPath();
        return null;
    }
}

