/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.ui.pythonpathconf.IInterpreterProviderFactory;

public abstract class AbstractInterpreterProviderFactory
implements IInterpreterProviderFactory {
    private static final int INVALID = -1;

    private int matchesPattern(Pattern[] patterns, File afile) {
        int i = 0;
        while (i < patterns.length) {
            Pattern pattern = patterns[i];
            if (pattern.matcher(afile.getName().toLowerCase()).matches()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] searchPaths(Set<String> pathsToSearch, List<String> expectedPatterns) {
        return this.searchPaths(pathsToSearch, expectedPatterns, true);
    }

    public String[] searchPaths(Set<String> pathsToSearch, List<String> expectedPatterns, boolean followLinks) {
        int n = expectedPatterns.size();
        LinkedHashSet[] pathSetsByPriority = new LinkedHashSet[n];
        LinkedHashSet prioritizedPaths = new LinkedHashSet();
        Pattern[] patterns = new Pattern[n];
        int i = 0;
        while (i < n) {
            patterns[i] = Pattern.compile(expectedPatterns.get(i));
            ++i;
        }
        for (String s : pathsToSearch) {
            File[] available;
            File file;
            String pathname = s.trim();
            if (pathname.length() <= 0 || !(file = new File(pathname)).isDirectory() || (available = file.listFiles()) == null) continue;
            File[] fileArray = available;
            int n2 = available.length;
            int n3 = 0;
            while (n3 < n2) {
                File afile = fileArray[n3];
                int priority = this.matchesPattern(patterns, afile);
                if (priority != -1) {
                    if (pathSetsByPriority[priority] == null) {
                        pathSetsByPriority[priority] = new LinkedHashSet();
                    }
                    LinkedHashSet pathSet = pathSetsByPriority[priority];
                    File f = new File(file, afile.getName());
                    if (!followLinks) {
                        pathSet.add(FileUtils.getFileAbsolutePathNotFollowingLinks((File)f));
                    } else {
                        pathSet.add(FileUtils.getFileAbsolutePath((File)f));
                    }
                }
                ++n3;
            }
        }
        LinkedHashSet[] linkedHashSetArray = pathSetsByPriority;
        int n4 = pathSetsByPriority.length;
        int n5 = 0;
        while (n5 < n4) {
            LinkedHashSet pathSet = linkedHashSetArray[n5];
            if (pathSet != null) {
                prioritizedPaths.addAll(pathSet);
            }
            ++n5;
        }
        return prioritizedPaths.toArray(new String[prioritizedPaths.size()]);
    }
}

