/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.importsconf;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.editor.preferences.PyScopedPreferences;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.field_editors.BooleanFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class ImportsPreferencesPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor fromImportsFirstBooleanEditor;
    private BooleanFieldEditorCustom pep8ImportCompliantFieldEditor;
    public static final String GROUP_IMPORTS = "GROUP_IMPORTS";
    public static final boolean DEFAULT_GROUP_IMPORTS = true;
    public static final String MULTILINE_IMPORTS = "MULTILINE_IMPORTS";
    public static final boolean DEFAULT_MULTILINE_IMPORTS = true;
    public static final String BREAK_IMPORTS_MODE = "BREAK_IMPORTS_MODE";
    public static final String BREAK_IMPORTS_MODE_ESCAPE = "ESCAPE";
    public static final String BREAK_IMPORTS_MODE_PARENTHESIS = "PARENTHESIS";
    public static final String DEFAULT_BREAK_IMPORTS_MODE = "ESCAPE";
    public static final String PEP8_IMPORTS = "PEP8_IMPORTS";
    public static final boolean DEFAULT_PEP8_IMPORTS = true;
    public static final String DELETE_UNUSED_IMPORTS = "DELETE_UNUSED_IMPORTS";
    public static final boolean DEFAULT_DELETE_UNUSED_IMPORTS = false;
    public static final String FROM_IMPORTS_FIRST = "FROM_IMPORTS_FIRST";
    public static final boolean DEFAULT_FROM_IMPORTS_FIRST = false;
    public static final String SORT_NAMES_GROUPED = "SORT_NAMES_GROUPED";
    public static final boolean DEFAULT_SORT_NAMES_GROUPED = false;
    public static boolean groupImportsForTests = true;
    public static boolean sortFromImportsFirstForTests = true;
    public static boolean multilineImportsForTests = true;
    public static boolean sortNamesGroupedForTests = false;
    public static String breakImportModeForTests = "PARENTHESIS";
    public static boolean pep8ImportsForTests = true;
    public static boolean deleteUnusedImportsForTests = true;

    public ImportsPreferencesPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Imports Preferences");
    }

    protected void createFieldEditors() {
        final Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new LabelFieldEditor("Label_Info_File_Preferences1", WrapAndCaseUtils.wrap((String)"These setting are used whenever imports are managed in the application\n\n", (int)80), p));
        this.pep8ImportCompliantFieldEditor = new BooleanFieldEditorCustom(PEP8_IMPORTS, WrapAndCaseUtils.wrap((String)"Use Pep8 compliant import organzier?", (int)80), p);
        this.addFieldWithToolTip((BooleanFieldEditor)this.pep8ImportCompliantFieldEditor, p, "System modules are those found on the interpreter's Python path; third party modules are found in site-packages.");
        this.addFieldWithToolTip(new BooleanFieldEditor(DELETE_UNUSED_IMPORTS, WrapAndCaseUtils.wrap((String)"Delete unused imports?", (int)80), p), p, "Simple unused imports as reported by the code analysis are deleted. This can be configured to ignore certain files, and individual warnings can be surpressed.");
        this.addField((FieldEditor)new BooleanFieldEditor(GROUP_IMPORTS, "Combine 'from' imports when possible?", p));
        this.fromImportsFirstBooleanEditor = new BooleanFieldEditor(FROM_IMPORTS_FIRST, "Sort 'from' imports before 'import' imports?", p);
        this.addField((FieldEditor)this.fromImportsFirstBooleanEditor);
        this.addField((FieldEditor)new BooleanFieldEditor(MULTILINE_IMPORTS, WrapAndCaseUtils.wrap((String)"Allow multiline imports when the import size would exceed the print margin?", (int)80), p));
        this.addField((FieldEditor)new BooleanFieldEditor(SORT_NAMES_GROUPED, WrapAndCaseUtils.wrap((String)"Sort individual names on grouped imports?", (int)80), p));
        this.addField((FieldEditor)new RadioGroupFieldEditor(BREAK_IMPORTS_MODE, "How to break imports in multiline?", 1, (String[][])new String[][]{{"Use escape char", "ESCAPE"}, {"Use parenthesis", BREAK_IMPORTS_MODE_PARENTHESIS}}, p));
        this.updateEnablement(p, PydevPrefs.getPreferences().getBoolean(PEP8_IMPORTS));
        Button checkBox = this.pep8ImportCompliantFieldEditor.getCheckBox(p);
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportsPreferencesPage.this.updateEnablement(p, ImportsPreferencesPage.this.pep8ImportCompliantFieldEditor.getBooleanValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)new LinkFieldEditor("link_saveactions", "\nNote: view <a>save actions</a> to automatically sort imports on save.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.editor.saveactions.PydevSaveActionsPrefPage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)ImportsPreferencesPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private void updateEnablement(Composite p, boolean enable) {
        this.fromImportsFirstBooleanEditor.setEnabled(enable, p);
    }

    private void addFieldWithToolTip(BooleanFieldEditor editor, Composite p, String tip) {
        this.addField((FieldEditor)editor);
        editor.getDescriptionControl(p).setToolTipText(tip);
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean getGroupImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return groupImportsForTests;
        }
        return PyScopedPreferences.getBoolean(GROUP_IMPORTS, projectAdaptable);
    }

    public static boolean getSortFromImportsFirst(IAdaptable projectAdaptable) {
        if (PydevPlugin.getDefault() == null) {
            return sortFromImportsFirstForTests;
        }
        return PyScopedPreferences.getBoolean(FROM_IMPORTS_FIRST, projectAdaptable);
    }

    public static boolean getMultilineImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return multilineImportsForTests;
        }
        return PyScopedPreferences.getBoolean(MULTILINE_IMPORTS, projectAdaptable);
    }

    public static boolean getSortNamesGrouped(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return sortNamesGroupedForTests;
        }
        return PyScopedPreferences.getBoolean(SORT_NAMES_GROUPED, projectAdaptable);
    }

    public static String getBreakIportMode(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return breakImportModeForTests;
        }
        return PyScopedPreferences.getString(BREAK_IMPORTS_MODE, projectAdaptable);
    }

    public static boolean getPep8Imports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return pep8ImportsForTests;
        }
        return PyScopedPreferences.getBoolean(PEP8_IMPORTS, projectAdaptable);
    }

    public static boolean getDeleteUnusedImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return deleteUnusedImportsForTests;
        }
        return PyScopedPreferences.getBoolean(DELETE_UNUSED_IMPORTS, projectAdaptable);
    }
}

