/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.dialogs.PythonModuleContentProvider;

public class PythonModulePickerDialog
extends ElementTreeSelectionDialog {
    public PythonModulePickerDialog(Shell parent, String title, String message, IProject project, boolean unitTesting) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new PythonModuleContentProvider());
        this.setAllowMultiple(unitTesting);
        this.setEmptyListMessage("No Python modules in project " + project.getName());
        this.setInput(project);
        this.setTitle(title);
        this.setMessage(message);
        if (!unitTesting) {
            this.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length >= 1) {
                        if (selection[0] instanceof IFile) {
                            IFile file = (IFile)selection[0];
                            return new Status(0, PydevPlugin.getPluginID(), 0, "Module  " + file.getName() + " selected", null);
                        }
                        if (selection[0] instanceof IFolder) {
                            IFolder folder = (IFolder)selection[0];
                            if (folder.findMember("__main__.py") == null) {
                                return new Status(4, PydevPlugin.getPluginID(), 4, "Can't find '__main__' module in this folder.", null);
                            }
                            return new Status(0, PydevPlugin.getPluginID(), 0, "Module " + folder.getName() + " selected", null);
                        }
                    }
                    return new Status(4, PydevPlugin.getPluginID(), 4, "No Python module selected", null);
                }
            });
        } else {
            this.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    int i = 0;
                    while (i < selection.length) {
                        IFolder folder;
                        if (selection[i] instanceof IFolder && (folder = (IFolder)selection[i]).getFileExtension() != null) {
                            return new Status(4, PydevPlugin.getPluginID(), 4, "Invalid selection: " + folder.getFileExtension(), null);
                        }
                        ++i;
                    }
                    if (selection.length == 1) {
                        if (selection[0] instanceof IFile) {
                            IFile file = (IFile)selection[0];
                            return new Status(0, PydevPlugin.getPluginID(), 0, "Module " + file.getName() + " selected", null);
                        }
                        if (selection[0] instanceof IFolder) {
                            IFolder folder = (IFolder)selection[0];
                            return new Status(0, PydevPlugin.getPluginID(), 0, "Package " + folder.getName() + " selected", null);
                        }
                    } else if (selection.length > 1) {
                        return new Status(0, PydevPlugin.getPluginID(), 0, "Multiple items selected", null);
                    }
                    return new Status(4, PydevPlugin.getPluginID(), 4, "Nothing selected", null);
                }
            });
        }
    }
}

