/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.pyunit.preferences;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.MultiStringFieldEditor;
import org.python.pydev.shared_ui.tooltips.presenter.AbstractTooltipInformationPresenter;
import org.python.pydev.shared_ui.tooltips.presenter.ToolTipPresenterHandler;

public class PyUnitPrefsPage2
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final int TEST_RUNNER_PYDEV = 0;
    public static final int TEST_RUNNER_NOSE = 1;
    public static final int TEST_RUNNER_PY_TEST = 2;
    public static final String[][] ENTRY_NAMES_AND_VALUES = new String[][]{{"PyDev test runner", Integer.toString(0)}, {"Nose test runner", Integer.toString(1)}, {"Py.test runner", Integer.toString(2)}};
    public static final String TEST_RUNNER = "PYDEV_TEST_RUNNER";
    public static final int DEFAULT_TEST_RUNNER = 0;
    public static final String TEST_RUNNER_DEFAULT_PARAMETERS = "PYDEV_TEST_RUNNER_DEFAULT_PARAMETERS";
    public static final String DEFAULT_TEST_RUNNER_DEFAULT_PARAMETERS = "--verbosity 0";
    public static final String USE_PYUNIT_VIEW = "PYDEV_USE_PYUNIT_VIEW";
    public static final boolean DEFAULT_USE_PYUNIT_VIEW = true;
    public static final String LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS_CHOICE = "LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS_CHOICE";
    public static final String LAUNCH_CONFIG_OVERRIDE_TEST_RUNNER = "LAUNCH_CONFIG_OVERRIDE_TEST_RUNNER";
    public static final String LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS = "LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS";
    private MultiStringFieldEditor parametersField;
    private ToolTipPresenterHandler tooltipPresenter;
    private Composite parentPyDev;
    private Composite parentNose;
    private Composite parentPyTest;

    public PyUnitPrefsPage2() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        AbstractTooltipInformationPresenter presenter = new AbstractTooltipInformationPresenter(){

            protected void onUpdatePresentation(String hoverInfo, TextPresentation presentation) {
            }

            protected void onHandleClick(Object data) {
            }
        };
        Composite p = this.getFieldEditorParent();
        this.tooltipPresenter = new ToolTipPresenterHandler(p.getShell(), (DefaultInformationControl.IInformationPresenter)presenter, "Tip: Click on the link to add it as a parameter to the test runner.");
        Composite parentAll = p;
        final StackLayout stackLayout = new StackLayout();
        final ComboFieldEditor comboField = PyUnitPrefsPage2.createTestRunnerEditor(p);
        this.addField((FieldEditor)comboField);
        Combo combo = comboField.getCombo();
        this.parametersField = new MultiStringFieldEditor(TEST_RUNNER_DEFAULT_PARAMETERS, "Parameters for test runner   (click links below to add flags)", p);
        this.addField((FieldEditor)this.parametersField);
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYUNIT_VIEW, "Show the results in the unittest results view?", p));
        String s = "Note: if unchecked, no xml-rpc communication will be done when running tests\nand the output will only be shown in the console.";
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", s, p));
        String s2 = "Parameters for PyDev test runner (hover for description):";
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor2", s2, p));
        final Composite contentPanel = new Composite(parentAll, 0);
        contentPanel.setLayout((Layout)stackLayout);
        this.parentPyTest = p = new Composite(contentPanel, 0);
        this.add("-<a>n</a> number of processes (requires xdist plugin)", "n", "Sets the number of processes to be used to run\ntests (requires py.test xdist plugin)\n\n", p);
        this.add("--<a>maxfail</a>=number (max number of failures)", "maxfail", "When the maximum number of failures\nis reached execution stops.\n\n", p);
        this.add("--<a>tb</a>=long | native | short | line", "tb", "Traceback style.\nlong = the default informative traceback formatting\nnative = the Python standard library formatting\nshort = a shorter traceback format\nline = only one line per failure\n\n", p);
        this.add("--<a>capture</a>=no | sys | fd", "capture", "Capture stdout/stderr\nno = disable capture\nsys = replace stdout/stderr with in-mem files\nfd = also point filedescriptors 1 and 2 to temp file\n\n", p);
        this.add("--<a>showlocals</a>", "showlocals", "Show local variables in tracebacks.\n\n", p);
        this.add("--<a>runxfail</a>", "runxfail", "Run tests even if they are marked xfali.\n\n", p);
        this.add("--<a>assert</a>=plain | reinterp | rewrite", "assert", "Control assertion debugging tools. 'plain' performs no\nassertion debugging. 'reinterp' reinterprets assert\nstatements after they failed to provide assertion\nexpression information. 'rewrite' (the default)\nrewrites assert statements in test modules on import\nto provide assert expression information..\n\n", p);
        this.add("--<a>durations</a>=number of slower tests to show", "durations", "Profiling test execution duration\n(shows n slowest tests).\n\n", p);
        this.parentNose = p = new Composite(contentPanel, 0);
        this.parentPyDev = p = new Composite(contentPanel, 0);
        this.add("--<a>verbosity</a>=number", "verbosity", "Sets the verbosity level for the run (0-9)\n 0: almost no output\n 9: many details", p);
        this.add("--<a>jobs</a>=number", "jobs", "The number of processes to be used to run the tests.\n\nThe --split_jobs flag actually mandates how the tests will be scheduled (if jobs > 1).", p);
        this.add("--<a>split_jobs</a>=tests | module", "split_jobs", "tests:  if 'tests' is passed (default), a process will randomly get a\n\tnew test to be run after the current one finishes running.\n\nmodule: if 'module' is passed, a given job will always run all the\n\ttests from a module and then get a new module to run tests from.", p);
        this.add("--<a>include_files</a>=comma separated list of patterns to match files to include", "include_files", "Patters to match filenames to be included during test discovery.\n\nPatters are fnmatch-style patterns (i.e.: test*, todo* and not regexps).\n\nNote that *.py,*.pyw files are already pre-selected, so, patterns\nwill be matched against those pre-selected by default.", p);
        this.add("--<a>exclude_files</a>=comma separated list of patterns to match files to exclude", "exclude_files", "Patters to match filenames to be excluded during test discovery.\n\nPatters are fnmatch-style patterns (i.e.: test*, todo* and not regexps).\n\nNote that *.py,*.pyw files are already pre-selected, so, patterns\nwill be matched against those pre-selected by default.", p);
        this.add("--<a>include_tests</a>=comma separated list of patterns to match tests to include", "include_tests", "Patters to match tests (method names) to be included during test discovery.\n\nPatters are fnmatch-style patterns (i.e.: *_todo, *_slow and not regexps).\n\n", p);
        this.add("--<a>exclude_tests</a>=comma separated list of patterns to match tests to exclude", "exclude_tests", "Patters to match tests (method names) to be excluded during test discovery.\n\nPatters are fnmatch-style patterns (i.e.: *_todo, *_slow and not regexps).\n\n", p);
        this.add("--<a>django</a>=true | false (default is true on django projects and false otherwise)", "django", "Whether the django runner should be used for setup/teardown of the django test environment\n\n", p);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String comboValue = comboField.getComboValue();
                int val = 0;
                try {
                    val = Integer.parseInt(comboValue);
                }
                catch (NumberFormatException e1) {
                    Log.log((Throwable)e1);
                    return;
                }
                PyUnitPrefsPage2.this.layoutTestRunnerOptions(stackLayout, val, contentPanel);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.layoutTestRunnerOptions(stackLayout, PyUnitPrefsPage2.getTestRunner(), contentPanel);
    }

    private void add(String linkText, String flag, String tooltip, Composite p) {
        LinkFieldEditor field = new LinkFieldEditor("link_" + flag, linkText, p, (SelectionListener)new PyUnitPageLinkListener(flag), String.valueOf(tooltip) + "\n", this.tooltipPresenter);
        this.addField((FieldEditor)field);
    }

    public static ComboFieldEditor createTestRunnerEditor(Composite p) {
        return new ComboFieldEditor(TEST_RUNNER, "Test Runner", ENTRY_NAMES_AND_VALUES, p);
    }

    public void init(IWorkbench workbench) {
    }

    private void layoutTestRunnerOptions(StackLayout stackLayout, int val, Composite contentPanel) {
        switch (val) {
            case 0: {
                stackLayout.topControl = this.parentPyDev;
                break;
            }
            case 2: {
                stackLayout.topControl = this.parentPyTest;
                break;
            }
            case 1: {
                stackLayout.topControl = this.parentNose;
            }
        }
        contentPanel.layout();
    }

    public static String getTestRunnerParameters(ILaunchConfiguration config, IProject project) {
        boolean override = false;
        try {
            override = config.getAttribute(LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS_CHOICE, false);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        IPreferenceStore prefs = PydevPrefs.getPreferenceStore();
        int testRunner = prefs.getInt(TEST_RUNNER);
        String ret = prefs.getString(TEST_RUNNER_DEFAULT_PARAMETERS);
        if (override) {
            try {
                testRunner = config.getAttribute(LAUNCH_CONFIG_OVERRIDE_TEST_RUNNER, testRunner);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
            try {
                ret = config.getAttribute(LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS, ret);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        switch (testRunner) {
            case 1: {
                ret = "--nose-params " + ret;
                break;
            }
            case 2: {
                ret = "--py-test-params " + ret;
                break;
            }
            default: {
                try {
                    if (!project.hasNature("org.python.pydev.django.djangoNature") || ret.contains("--django")) break;
                    ret = String.valueOf(ret) + " --django=true";
                    break;
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return ret;
    }

    public static int getTestRunner() {
        IPreferenceStore prefs = PydevPrefs.getPreferenceStore();
        return prefs.getInt(TEST_RUNNER);
    }

    public static boolean getUsePyUnitView() {
        return PydevPrefs.getPreferenceStore().getBoolean(USE_PYUNIT_VIEW);
    }

    public static void showPage() {
        String id = "org.python.pydev.prefs.pyunitPage";
        PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn(null, (String)id, null, null);
        prefDialog.open();
    }

    public static boolean isPyTestRun() {
        return PyUnitPrefsPage2.getTestRunner() == 2;
    }

    private class PyUnitPageLinkListener
    implements SelectionListener {
        private String fTag;

        public PyUnitPageLinkListener(String tag) {
            this.fTag = tag;
        }

        public void widgetSelected(SelectionEvent e) {
            String tag;
            int testRunner = PyUnitPrefsPage2.getTestRunner();
            boolean addEquals = true;
            boolean addSpace = false;
            if (testRunner == 0) {
                tag = "--" + this.fTag;
            } else if (testRunner == 2) {
                if ("n".equals(this.fTag)) {
                    tag = "-" + this.fTag;
                    addEquals = false;
                    addSpace = true;
                } else if ("showlocals".equals(this.fTag) || "runxfail".equals(this.fTag)) {
                    tag = "--" + this.fTag;
                    addEquals = false;
                } else {
                    tag = "--" + this.fTag;
                }
            } else {
                tag = this.fTag;
            }
            Text textControl = PyUnitPrefsPage2.this.parametersField.getTextControl();
            String currentText = textControl.getText();
            StringTokenizer stringTokenizer = new StringTokenizer(currentText);
            FastStringBuffer buf = new FastStringBuffer(currentText.length() * 2);
            boolean found = false;
            while (stringTokenizer.hasMoreTokens()) {
                String tok = stringTokenizer.nextToken();
                if (tok.startsWith(tag)) {
                    found = true;
                }
                buf.append(tok);
                buf.append('\n');
            }
            if (!found) {
                buf.append(tag);
                if (addEquals) {
                    buf.append('=');
                }
                if (addSpace) {
                    buf.append(' ');
                }
            } else {
                buf.deleteLast();
            }
            textControl.setText(buf.toString());
            textControl.setSelection(textControl.getSize());
            textControl.setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

