/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.ui;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.dnd.CommonDropAdapterDescriptor;
import org.eclipse.ui.internal.navigator.dnd.CommonDropDescriptorManager;
import org.eclipse.ui.internal.navigator.dnd.NavigatorDnDService;
import org.eclipse.ui.navigator.CommonDragAdapter;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.actions.PythonLinkHelper;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.editor_input.PydevZipFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileStorage;
import org.python.pydev.shared_ui.utils.IViewWithControls;
import org.python.pydev.ui.NotifyViewCreated;

public class PydevPackageExplorer
extends CommonNavigator
implements IShowInTarget,
IViewWithControls {
    private IMemento memento;
    public final ICallbackWithListeners onControlCreated = new CallbackWithListeners();
    public final ICallbackWithListeners onControlDisposed = new CallbackWithListeners();
    private PydevCommonViewer viewer;
    private final PythonLinkHelper pythonLinkHelper = new PythonLinkHelper();

    public PydevPackageExplorer() {
        NotifyViewCreated.notifyViewCreated(this);
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        PydevCommonViewer aViewer = new PydevCommonViewer(this.getViewSite().getId(), aParent, 770, this);
        this.initListeners((TreeViewer)aViewer);
        return aViewer;
    }

    public void createPartControl(Composite aParent) {
        PydevCommonViewer viewer;
        super.createPartControl(aParent);
        this.viewer = viewer = (PydevCommonViewer)this.getCommonViewer();
        this.onControlCreated.call((Object)viewer);
        viewer.availableToRestoreMemento = true;
        int i = 0;
        while (i < 3) {
            block3: {
                try {
                    viewer.getNavigatorContentService().restoreState(this.memento);
                }
                catch (Exception e1) {
                    if (i <= 1) break block3;
                    Log.log((String)"Unable to restore the state of the Pydev Package Explorer.", (Throwable)e1);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.viewer != null) {
            this.onControlDisposed.call((Object)this.viewer);
            this.viewer = null;
        }
        super.dispose();
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof IURIEditorInput) {
            IURIEditorInput iuriEditorInput = (IURIEditorInput)input;
            URI uri = iuriEditorInput.getURI();
            return new File(uri);
        }
        if (input instanceof PydevZipFileEditorInput) {
            PydevZipFileEditorInput pydevZipFileEditorInput = (PydevZipFileEditorInput)input;
            try {
                IStorage storage = pydevZipFileEditorInput.getStorage();
                if (storage instanceof PydevZipFileStorage) {
                    PydevZipFileStorage pydevZipFileStorage = (PydevZipFileStorage)storage;
                    return pydevZipFileStorage;
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        return null;
    }

    public boolean show(ShowInContext context) {
        Object input;
        IStructuredSelection structuredSelection;
        Object elementOfInput = null;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            elementOfInput = structuredSelection.getFirstElement();
        }
        if ((input = context.getInput()) instanceof IEditorInput) {
            elementOfInput = this.getElementOfInput((IEditorInput)context.getInput());
        }
        return elementOfInput != null && this.tryToReveal(elementOfInput);
    }

    public boolean tryToReveal(Object element) {
        IAdaptable adaptable;
        IResource resource;
        if ((element = this.getPythonModelElement(element)) instanceof PydevZipFileStorage) {
            this.pythonLinkHelper.setCommonViewer(this.getCommonViewer());
            PydevZipFileStorage pydevZipFileStorage = (PydevZipFileStorage)element;
            IStructuredSelection externalFileSelectionInTree = this.pythonLinkHelper.findExternalFileSelection(pydevZipFileStorage.zipFile);
            if (externalFileSelectionInTree != null && !externalFileSelectionInTree.isEmpty()) {
                Object firstElement = externalFileSelectionInTree.getFirstElement();
                if (firstElement instanceof TreeNode) {
                    TreeNode treeNode = (TreeNode)firstElement;
                    String zipPath = pydevZipFileStorage.zipPath;
                    List split = StringUtils.split((String)zipPath, (char)'/');
                    block0: for (String string : split) {
                        List children = treeNode.getChildren();
                        for (TreeNode child : children) {
                            if (!string.equals(((LabelAndImage)child.getData()).label)) continue;
                            treeNode = child;
                            continue block0;
                        }
                    }
                    if (this.revealAndVerify(new StructuredSelection((Object)treeNode))) {
                        return true;
                    }
                } else {
                    Log.log((String)("Expected a TreeNode. Found: " + firstElement));
                    if (this.revealAndVerify(externalFileSelectionInTree)) {
                        return true;
                    }
                }
            }
        } else if (element instanceof File) {
            this.pythonLinkHelper.setCommonViewer(this.getCommonViewer());
            IStructuredSelection externalFileSelectionInTree = this.pythonLinkHelper.findExternalFileSelection((File)element);
            if (externalFileSelectionInTree != null && !externalFileSelectionInTree.isEmpty() && this.revealAndVerify(externalFileSelectionInTree)) {
                return true;
            }
        }
        if (this.revealAndVerify(element)) {
            return true;
        }
        return element instanceof IAdaptable && !(element instanceof IResource) && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null && this.revealAndVerify(resource);
    }

    private Object getPythonModelElement(Object element) {
        IAdaptable adaptable;
        IFile file;
        if (element instanceof IWrappedResource) {
            return element;
        }
        INavigatorPipelineService pipelineService = this.getNavigatorContentService().getPipelineService();
        if (element instanceof IAdaptable && (file = (IFile)(adaptable = (IAdaptable)element).getAdapter(IFile.class)) != null) {
            ContributorTrackingSet files = new ContributorTrackingSet((NavigatorContentService)this.getNavigatorContentService());
            files.add(file);
            pipelineService.interceptAdd(new PipelinedShapeModification((Object)file.getParent(), (Set)files));
            if (files.size() > 0) {
                element = files.iterator().next();
            }
        }
        return element;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ISelection) {
            this.selectReveal((ISelection)element);
        } else {
            this.selectReveal((ISelection)new StructuredSelection(element));
        }
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    public ICallbackWithListeners getOnControlCreated() {
        return this.onControlCreated;
    }

    public ICallbackWithListeners getOnControlDisposed() {
        return this.onControlDisposed;
    }

    public static class PydevCommonViewer
    extends CommonViewer {
        public boolean availableToRestoreMemento = false;
        private PydevPackageExplorer pydevPackageExplorer;
        private PydevNavigatorContentService pyContentService;

        public PydevPackageExplorer getPydevPackageExplorer() {
            return this.pydevPackageExplorer;
        }

        public PydevCommonViewer(String id, Composite parent, int style, PydevPackageExplorer pydevPackageExplorer) {
            super(id, parent, style);
            this.pydevPackageExplorer = pydevPackageExplorer;
            this.setComparer(new IElementComparer(){

                public int hashCode(Object element) {
                    if (element instanceof IWrappedResource) {
                        IWrappedResource wrappedResource = (IWrappedResource)element;
                        return wrappedResource.getActualObject().hashCode();
                    }
                    return element.hashCode();
                }

                public boolean equals(Object a, Object b) {
                    IWrappedResource wrappedResource;
                    if (a instanceof IWrappedResource) {
                        wrappedResource = (IWrappedResource)a;
                        a = wrappedResource.getActualObject();
                    }
                    if (b instanceof IWrappedResource) {
                        wrappedResource = (IWrappedResource)b;
                        b = wrappedResource.getActualObject();
                    }
                    if (a == null) {
                        return b == null;
                    }
                    if (b == null) {
                        return false;
                    }
                    return a.equals(b);
                }
            });
        }

        protected void init() {
            this.pyContentService = new PydevNavigatorContentService("org.python.pydev.navigator.view", (StructuredViewer)this);
            super.init();
        }

        protected void initDragAndDrop() {
            int operations = 7;
            CommonDragAdapter dragAdapter = this.createDragAdapter();
            this.addDragSupport(operations, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
            CommonDropAdapter dropAdapter = this.createDropAdapter();
            this.addDropSupport(operations, dropAdapter.getSupportedDropTransfers(), (DropTargetListener)dropAdapter);
            NavigatorDnDService dnd = (NavigatorDnDService)this.pyContentService.getDnDService();
            dnd.setDropAdaptor(dropAdapter);
        }

        protected CommonDropAdapter createDropAdapter() {
            return new CommonDropAdapter((INavigatorContentService)this.pyContentService, (StructuredViewer)this);
        }

        public void dispose() {
            if (this.pyContentService != null) {
                this.pyContentService.dispose();
            }
            super.dispose();
        }

        protected TreePath getTreePathFromItem(Item item) {
            LinkedListWarningOnSlowOperations segments = new LinkedListWarningOnSlowOperations();
            while (item != null) {
                Object segment = item.getData();
                if (segment == null) {
                    return null;
                }
                segments.addFirst(segment);
                item = this.getParentItem(item);
            }
            return new TreePath(segments.toArray());
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            Object input = this.getInput();
            if (input instanceof AggregateWorkingSet) {
                return ((AggregateWorkingSet)input).getComponents();
            }
            return null;
        }
    }

    public static class PydevNavigatorContentService
    extends NavigatorContentService {
        private INavigatorDnDService pyNavigatorDnDService;

        public PydevNavigatorContentService(String aViewerId, StructuredViewer aViewer) {
            super(aViewerId, aViewer);
        }

        public INavigatorDnDService getDnDService() {
            if (this.pyNavigatorDnDService == null) {
                this.pyNavigatorDnDService = new PydevNavigatorDnDService((INavigatorContentService)this);
            }
            return this.pyNavigatorDnDService;
        }
    }

    public static class PydevNavigatorDnDService
    extends NavigatorDnDService {
        private static final CommonDropAdapterAssistant[] NO_ASSISTANTS = new CommonDropAdapterAssistant[0];
        private INavigatorContentService pyContentService;
        private CommonDropAdapter pyDropAdapter;
        private final Map pyDropAssistants = new HashMap();

        public PydevNavigatorDnDService(INavigatorContentService aContentService) {
            super(aContentService);
            this.pyContentService = aContentService;
        }

        public void setDropAdaptor(CommonDropAdapter da) {
            super.setDropAdaptor(da);
            this.pyDropAdapter = da;
        }

        private CommonDropAdapterAssistant[] pySortAssistants(CommonDropAdapterAssistant[] array) {
            Arrays.sort(array, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    CommonDropAdapterAssistant a = (CommonDropAdapterAssistant)arg0;
                    CommonDropAdapterAssistant b = (CommonDropAdapterAssistant)arg1;
                    String id = "org.python.pydev.navigator.actions";
                    if (a.getClass().getName().startsWith(id)) {
                        return -1;
                    }
                    if (b.getClass().getName().startsWith(id)) {
                        return 1;
                    }
                    return a.getClass().getName().compareTo(b.getClass().getName());
                }
            });
            return array;
        }

        public CommonDropAdapterAssistant[] findCommonDropAdapterAssistants(Object aDropTarget, TransferData aTransferType) {
            CommonDropAdapterDescriptor[] descriptors = CommonDropDescriptorManager.getInstance().findCommonDropAdapterAssistants(aDropTarget, this.pyContentService);
            if (descriptors.length == 0) {
                return NO_ASSISTANTS;
            }
            if (LocalSelectionTransfer.getTransfer().isSupportedType(aTransferType) && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection) {
                return this.pyGetAssistantsBySelection(descriptors, (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection());
            }
            return this.pyGetAssistantsByTransferData(descriptors, aTransferType);
        }

        public CommonDropAdapterAssistant[] findCommonDropAdapterAssistants(Object aDropTarget, IStructuredSelection theDragSelection) {
            CommonDropAdapterDescriptor[] descriptors = CommonDropDescriptorManager.getInstance().findCommonDropAdapterAssistants(aDropTarget, this.pyContentService);
            if (descriptors.length == 0) {
                return NO_ASSISTANTS;
            }
            return this.pyGetAssistantsBySelection(descriptors, theDragSelection);
        }

        private CommonDropAdapterAssistant[] pyGetAssistantsByTransferData(CommonDropAdapterDescriptor[] descriptors, TransferData aTransferType) {
            LinkedHashSet<CommonDropAdapterAssistant> assistants = new LinkedHashSet<CommonDropAdapterAssistant>();
            int i = 0;
            while (i < descriptors.length) {
                CommonDropAdapterAssistant asst = this.pyGetAssistant(descriptors[i]);
                if (asst.isSupportedType(aTransferType)) {
                    assistants.add(asst);
                }
                ++i;
            }
            return this.pySortAssistants(assistants.toArray(new CommonDropAdapterAssistant[assistants.size()]));
        }

        private CommonDropAdapterAssistant[] pyGetAssistantsBySelection(CommonDropAdapterDescriptor[] descriptors, IStructuredSelection aSelection) {
            LinkedHashSet<CommonDropAdapterAssistant> assistants = new LinkedHashSet<CommonDropAdapterAssistant>();
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].areDragElementsSupported(aSelection)) {
                    assistants.add(this.pyGetAssistant(descriptors[i]));
                }
                ++i;
            }
            return this.pySortAssistants(assistants.toArray(new CommonDropAdapterAssistant[assistants.size()]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CommonDropAdapterAssistant pyGetAssistant(CommonDropAdapterDescriptor descriptor) {
            CommonDropAdapterAssistant asst = (CommonDropAdapterAssistant)this.pyDropAssistants.get(descriptor);
            if (asst != null) {
                return asst;
            }
            Map map = this.pyDropAssistants;
            synchronized (map) {
                asst = (CommonDropAdapterAssistant)this.pyDropAssistants.get(descriptor);
                if (asst == null) {
                    asst = descriptor.createDropAssistant();
                    this.pyDropAssistants.put(descriptor, asst);
                    asst.init(this.pyContentService);
                    asst.setCommonDropAdapter(this.pyDropAdapter);
                }
            }
            return asst;
        }
    }
}

