/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions.copied;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ResourceTransfer;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.shared_core.string.StringUtils;

public abstract class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private Shell shell;
    private Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super("Paste");
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText("Paste ToolTip");
        this.setId(ID);
    }

    private IResource getTarget() {
        List selectedResources = this.getSelectedResources();
        int i = 0;
        while (i < selectedResources.size()) {
            IResource resource = (IResource)selectedResources.get(i);
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return null;
            }
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    private boolean isLinked(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        ResourceTransfer resTransfer = ResourceTransfer.getInstance();
        IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() == 4) {
                int i = 0;
                while (i < resourceData.length) {
                    CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                    operation.copyProject((IProject)resourceData[i]);
                    ++i;
                }
            } else {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
                IContainer container = this.getContainer();
                IResource[] copiedResources = operation.copyResources(resourceData, container);
                if (copiedResources.length > 0) {
                    PythonPathHelper.updatePyPath(copiedResources, container, 2);
                }
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            IContainer container = this.getContainer();
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
            operation.copyFiles(fileData, container);
            return;
        }
        TextTransfer instance = TextTransfer.getInstance();
        String contents = (String)this.clipboard.getContents((Transfer)instance);
        if (contents != null) {
            IFile file;
            IContainer container = this.getContainer();
            String name = this.getNameForContentsPasted(container);
            if (name == null) {
                return;
            }
            String delimiter = PyAction.getDelimiter((IDocument)new Document());
            if (delimiter != null) {
                contents = StringUtils.replaceNewLines((String)contents, (String)delimiter);
            }
            if (!(file = container.getFile((IPath)new Path(name))).exists()) {
                try {
                    file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
    }

    private String getNameForContentsPasted(final IContainer container) {
        final IWorkspace workspace = container.getWorkspace();
        final String[] returnValue = new String[1];
        final IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                IStatus status = workspace.validateName(string, 1);
                if (!status.isOK()) {
                    return status.getMessage();
                }
                if (container.getFile((IPath)new Path(string)).exists()) {
                    return "File already exists";
                }
                return null;
            }
        };
        String base = "snippet%s.py";
        int i = 0;
        while (i < 1000) {
            String newCheck = i == 0 ? StringUtils.format((String)base, (Object[])new Object[]{""}) : StringUtils.format((String)base, (Object[])new Object[]{i});
            if (validator.isValid(newCheck) == null) {
                base = newCheck;
                break;
            }
            ++i;
        }
        final String initialValue = base;
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                InputDialog dialog = new InputDialog(PasteAction.this.shell, "Enter file name", "Please enter the name of the file to be created with the pasted contents.", initialValue, validator){

                    protected void createButtonsForButtonBar(Composite parent) {
                        super.createButtonsForButtonBar(parent);
                        Text control = this.getText();
                        String textInControl = control.getText();
                        int i = textInControl.indexOf(46);
                        if (i >= 0) {
                            control.setSelection(0, i);
                        }
                    }
                };
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            return null;
        }
        return returnValue[0];
    }

    private IContainer getContainer() {
        List selection = this.getSelectedResources();
        if (selection.get(0) instanceof IFile) {
            return ((IFile)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        int i;
        boolean isProjectRes;
        if (!super.updateSelection(selection)) {
            return false;
        }
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resTransfer);
            }
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            int i2 = 0;
            while (i2 < resourceData.length) {
                if (resourceData[i2].getType() != 4 || !((IProject)resourceData[i2]).isOpen()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource targetResource = this.getTarget();
        if (targetResource == null) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            i = 0;
            while (i < selectedResources.size()) {
                IResource resource = (IResource)selectedResources.get(i);
                if (resource.getType() != 1) {
                    return false;
                }
                if (!targetResource.equals((Object)resource.getParent())) {
                    return false;
                }
                ++i;
            }
        }
        if (resourceData != null) {
            if (this.isLinked(resourceData) && targetResource.getType() != 4) {
                return false;
            }
            if (targetResource.getType() == 2) {
                i = 0;
                while (i < resourceData.length) {
                    if (targetResource.equals((Object)resourceData[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        TransferData[] transfers = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i3 = 0;
        while (i3 < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i3])) {
                return true;
            }
            ++i3;
        }
        return false;
    }
}

