/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.StringUtils;

public class PySourceLocatorPrefs {
    public static final String DONTASK = "DONTASK";
    public static final String ON_SOURCE_NOT_FOUND = "ON_SOURCE_NOT_FOUND";
    public static final String FILE_CONTENTS_TIMEOUT = "FILE_CONTENTS_TIMEOUT";
    public static final int DEFAULT_FILE_CONTENTS_TIMEOUT = 1500;
    public static final int ASK_FOR_FILE = 0;
    public static final int ASK_FOR_FILE_GET_FROM_SERVER = 1;
    public static final int GET_FROM_SERVER = 2;
    public static final int DEFAULT_ON_FILE_NOT_FOUND_IN_DEBUGGER = 1;

    public static String isValid(String[] translation) {
        if (translation.length != 2) {
            return "Input must have 2 elements.";
        }
        if (translation[1].equals(DONTASK)) {
            return null;
        }
        if (!new File(translation[1]).exists()) {
            return StringUtils.format((String)"The file: %s does not exist and doesn't match 'DONTASK'.", (Object[])new Object[]{translation[1]});
        }
        return null;
    }

    public static void addPathTranslation(IPath path, IPath location) {
        PySourceLocatorPrefs.addPathTranslation(new String[]{path.toOSString(), location.toOSString()});
    }

    public static void setIgnorePathTranslation(IPath path) {
        PySourceLocatorPrefs.addPathTranslation(new String[]{path.toOSString(), DONTASK});
    }

    private static void addPathTranslation(String[] translation) {
        String valid = PySourceLocatorPrefs.isValid(translation);
        if (valid != null) {
            throw new RuntimeException(valid);
        }
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String available = store.getString("SOURCE_LOCATION_PATHS");
        if (available == null || available.trim().length() == 0) {
            available = StringUtils.join((String)",", (String[])translation);
        } else {
            String pathAsked = translation[0].trim();
            String existent = PySourceLocatorPrefs.getPathTranslation(pathAsked);
            if (existent != null) {
                List splitted = StringUtils.splitAndRemoveEmptyTrimmed((String)available, (char)'\n');
                int size = splitted.size();
                int i = 0;
                while (i < size) {
                    String s = (String)splitted.get(i);
                    String initialPart = ((String)StringUtils.splitAndRemoveEmptyTrimmed((String)s, (char)',').get(0)).trim();
                    if (initialPart.equals(pathAsked)) {
                        splitted.set(i, StringUtils.join((String)",", (String[])translation));
                        break;
                    }
                    ++i;
                }
                available = StringUtils.join((String)"\n", (Collection)splitted);
            } else {
                available = String.valueOf(available) + "\n";
                available = String.valueOf(available) + StringUtils.join((String)",", (String[])translation);
            }
        }
        store.putValue("SOURCE_LOCATION_PATHS", available);
    }

    public static String getPathTranslation(IPath pathToTranslate) {
        return PySourceLocatorPrefs.getPathTranslation(pathToTranslate.toOSString());
    }

    public static String getPathTranslation(String pathToTranslate) {
        pathToTranslate = pathToTranslate.trim();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String available = store.getString("SOURCE_LOCATION_PATHS");
        if (available == null || available.trim().length() == 0) {
            return null;
        }
        for (String string : StringUtils.splitAndRemoveEmptyTrimmed((String)available, (char)'\n')) {
            List translation = StringUtils.splitAndRemoveEmptyTrimmed((String)string, (char)',');
            if (translation.size() != 2 || !((String)translation.get(0)).trim().equals(pathToTranslate)) continue;
            return ((String)translation.get(1)).trim();
        }
        return null;
    }

    public static String wordsAsString(List<String[]> words) {
        StringBuffer buf = new StringBuffer();
        for (String[] string : words) {
            buf.append(string[0].trim());
            buf.append(',');
            buf.append(string[1].trim());
            buf.append('\n');
        }
        return buf.toString();
    }

    public static List<String[]> stringAsWords(String string) {
        ArrayList<String[]> strs = new ArrayList<String[]>();
        for (String str : StringUtils.splitAndRemoveEmptyTrimmed((String)string, (char)'\n')) {
            List temp = StringUtils.splitAndRemoveEmptyTrimmed((String)str, (char)',');
            strs.add(temp.toArray(new String[temp.size()]));
        }
        return strs;
    }

    public static int getOnSourceNotFound() {
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        int onSourceNotFound = store.getInt(ON_SOURCE_NOT_FOUND);
        if (onSourceNotFound < 0 || onSourceNotFound > 2) {
            onSourceNotFound = 1;
        }
        return onSourceNotFound;
    }

    public static int getFileContentsTimeout() {
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        int timeout = store.getInt(FILE_CONTENTS_TIMEOUT);
        if (timeout < 1000) {
            timeout = 1000;
        }
        return timeout;
    }
}

