/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_ui.editor_input.PydevFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileStorage;

public class EditorInputFactory {
    public static IEditorInput create(File file, boolean forceExternalFile) {
        IEditorInput input;
        IPath path = Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)file));
        if (!forceExternalFile && (input = new PySourceLocatorBase().createEditorInput(path, false, null, null)) != null) {
            return input;
        }
        Path zipPath = new Path("");
        while (path.segmentCount() > 0) {
            if (path.toFile().exists()) break;
            zipPath = new Path(path.lastSegment()).append((IPath)zipPath);
            path = path.uptoSegment(path.segmentCount() - 1);
        }
        if (zipPath.segmentCount() > 0 && path.segmentCount() > 0) {
            return new PydevZipFileEditorInput(new PydevZipFileStorage(path.toFile(), zipPath.toPortableString()));
        }
        try {
            URI uri = file.toURI();
            return new FileStoreEditorInput(EFS.getStore((URI)uri));
        }
        catch (Throwable throwable) {
            return new PydevFileEditorInput(file);
        }
    }
}

