/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.refactoring;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.refactoring.ModuleRenameRefactoringRequest;
import org.python.pydev.editor.refactoring.PyRefactoringRequest;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editor.refactoring.TargetNotInPythonpathException;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;

public class MultiModuleMoveRefactoringRequest
extends PyRefactoringRequest {
    private String initialName;
    private IContainer target;

    public MultiModuleMoveRefactoringRequest(List<ModuleRenameRefactoringRequest> requests, IContainer target) throws MisconfigurationException, TargetNotInPythonpathException {
        super(requests.toArray(new RefactoringRequest[requests.size()]));
        PythonNature nature = PythonNature.getPythonNature((IResource)target);
        File file = target.getLocation().toFile();
        this.target = target;
        this.initialName = nature.resolveModule(file);
        IPath fullPath = target.getFullPath();
        if (this.initialName == null) {
            try {
                Set projectSourcePathSet = nature.getPythonPathNature().getProjectSourcePathSet(true);
                for (String string : projectSourcePathSet) {
                    if (!new Path(string).equals((Object)fullPath)) continue;
                    this.initialName = "";
                    break;
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        if (this.initialName == null) {
            throw new TargetNotInPythonpathException("Unable to resolve file as a python module: " + fullPath);
        }
    }

    @Override
    public void setInputName(String text) {
        IPath walk;
        IContainer finalContainer;
        Assert.isNotNull((Object)text, (String)"Not expecting input name to be null.");
        this.inputName = text;
        Path initialPath = new Path(StringUtils.replaceAll((String)this.initialName, (String)".", (String)"/"));
        Path finalPath = new Path(StringUtils.replaceAll((String)text, (String)".", (String)"/"));
        IContainer initialContainer = this.target;
        if (initialPath.equals((Object)finalPath)) {
            finalContainer = initialContainer;
        } else if (initialPath.isPrefixOf((IPath)finalPath)) {
            walk = finalPath.removeFirstSegments(initialPath.segmentCount());
            finalContainer = initialContainer.getFolder(walk);
        } else {
            walk = finalPath.removeFirstSegments(initialPath.segmentCount());
            finalContainer = initialContainer;
            int i = 0;
            while (i < walk.segmentCount()) {
                finalContainer = finalContainer.getParent();
                --i;
            }
        }
        for (RefactoringRequest r : this.requests) {
            ModuleRenameRefactoringRequest modReq = (ModuleRenameRefactoringRequest)r;
            modReq.setTarget(finalContainer);
            String lastPart = FullRepIterable.getLastPart((String)r.initialName);
            r.inputName = text.length() > 0 ? String.valueOf(text) + "." + lastPart : lastPart;
        }
    }

    @Override
    public String getInitialName() {
        return this.initialName;
    }

    public IContainer getTarget() {
        return this.target;
    }
}

