/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.refactoring;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.nature.PythonNature;

public class ModuleRenameRefactoringRequest
extends RefactoringRequest {
    private IContainer target;

    public ModuleRenameRefactoringRequest(File file, IPythonNature nature, IContainer target) throws IOException {
        super(file, new PySelection(FileUtilsFileBuffer.getDocFromFile((File)file)), nature);
        this.target = target;
    }

    public void setTarget(IContainer target) {
        this.target = target;
    }

    public IContainer getTarget() {
        return this.target;
    }

    @Override
    public void fillInitialNameAndOffset() {
        try {
            this.initialName = this.nature.resolveModule(this.file);
            if (this.initialName.endsWith(".__init__")) {
                this.initialName = this.initialName.substring(0, this.initialName.length() - 9);
            }
        }
        catch (MisconfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isModuleRenameRefactoringRequest() {
        return true;
    }

    @Override
    public IPythonNature getTargetNature() {
        if (this.target != null) {
            return PythonNature.getPythonNature((IResource)this.target);
        }
        return this.nature;
    }
}

