/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.editor.PyInformationPresenter;
import org.python.pydev.editor.hover.AbstractPyEditorTextHover;
import org.python.pydev.editor.hover.PyEditorTextHoverDescriptor;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PydevCombiningHover
extends AbstractPyEditorTextHover {
    public static final Object ID_DEFAULT_COMBINING_HOVER = "org.python.pydev.editor.hover.defaultCombiningHover";
    private static List<PyEditorTextHoverDescriptor> fTextHoverSpecifications;
    private static List<AbstractPyEditorTextHover> fInstantiatedTextHovers;
    private Map<AbstractPyEditorTextHover, PyEditorTextHoverDescriptor> hoverMap = new HashMap<AbstractPyEditorTextHover, PyEditorTextHoverDescriptor>();
    boolean preempt = false;
    Integer currentPriority = null;
    boolean contentTypeSupported = false;
    private int lastDividerLen;
    protected ITextViewer viewer;
    private static final String DIVIDER_CHAR;

    static {
        DIVIDER_CHAR = Character.toString('\u2015');
    }

    public PydevCombiningHover() {
        PydevCombiningHover.installTextHovers();
        this.addInformationPresenterControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (PydevCombiningHover.this.hoverControlPreferredWidth != null) {
                    PydevCombiningHover.this.informationControl.setSize(PydevCombiningHover.this.hoverControlPreferredWidth, PydevCombiningHover.this.informationControl.getBounds().height);
                }
                PydevCombiningHover.this.hoverControlWidth = PydevCombiningHover.this.informationControl.getBounds().width;
                StyledText text = (StyledText)e.getSource();
                if (PyHoverPreferencesPage.getUseHoverDelimiters()) {
                    PydevCombiningHover.this.resizeDividerText(text, PydevCombiningHover.this.hoverControlWidth);
                }
            }
        });
    }

    public static void installTextHovers() {
        PyEditorTextHoverDescriptor[] hoverDescs;
        fTextHoverSpecifications = new ArrayList<PyEditorTextHoverDescriptor>(5);
        fInstantiatedTextHovers = new ArrayList<AbstractPyEditorTextHover>(5);
        PyEditorTextHoverDescriptor[] pyEditorTextHoverDescriptorArray = hoverDescs = PydevPlugin.getDefault().getPyEditorTextHoverDescriptors();
        int n = hoverDescs.length;
        int n2 = 0;
        while (n2 < n) {
            PyEditorTextHoverDescriptor desc = pyEditorTextHoverDescriptorArray[n2];
            if (!ID_DEFAULT_COMBINING_HOVER.equals(desc.getId())) {
                fTextHoverSpecifications.add(desc);
            }
            ++n2;
        }
    }

    private void checkTextHovers() {
        if (fTextHoverSpecifications == null) {
            return;
        }
        this.hoverMap.clear();
        List<PyEditorTextHoverDescriptor> specifications = fTextHoverSpecifications;
        fTextHoverSpecifications = null;
        for (PyEditorTextHoverDescriptor spec : specifications) {
            AbstractPyEditorTextHover hover;
            if (spec == null || (hover = spec.createTextHover()) == null) continue;
            fInstantiatedTextHovers.add(hover);
            this.hoverMap.put(hover, spec);
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.viewer = textViewer;
        final FastStringBuffer buf = new FastStringBuffer();
        this.checkTextHovers();
        if (fInstantiatedTextHovers == null) {
            return null;
        }
        boolean firstHoverInfo = true;
        for (final AbstractPyEditorTextHover hover : fInstantiatedTextHovers) {
            String hoverText;
            PyEditorTextHoverDescriptor descr;
            if (hover == null || !(descr = this.hoverMap.get(hover)).isEnabled() || this.hoverMap.get(hover) == null) continue;
            if (this.currentPriority == null) {
                this.currentPriority = descr.getPriority();
            }
            if ((descr.getPriority().equals(this.currentPriority) || !this.preempt) && (hoverText = hover.getHoverInfo(textViewer, hoverRegion)) != null && hoverText.trim().length() > 0) {
                if (!firstHoverInfo && PyHoverPreferencesPage.getUseHoverDelimiters()) {
                    buf.append(PyInformationPresenter.LINE_DELIM);
                    this.viewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (PydevCombiningHover.this.hoverControlWidth != null) {
                                buf.append(PydevCombiningHover.this.createDivider(PydevCombiningHover.this.hoverControlWidth));
                            } else {
                                buf.append(PydevCombiningHover.this.createDivider(PydevCombiningHover.this.getMaxExtent(hoverText)));
                            }
                        }
                    });
                    buf.append(PyInformationPresenter.LINE_DELIM);
                } else if (buf.length() > 0) {
                    buf.append(PyInformationPresenter.LINE_DELIM);
                }
                buf.append(hoverText);
                firstHoverInfo = false;
                this.viewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PydevCombiningHover.this.checkHoverControlWidth(hover);
                    }
                });
            }
            this.currentPriority = descr.getPriority();
            if (this.preempt) continue;
            this.preempt = descr.isPreempt();
        }
        this.currentPriority = null;
        this.preempt = false;
        return buf.toString();
    }

    private void checkHoverControlWidth(AbstractPyEditorTextHover hover) {
        if (hover.getHoverControlPreferredWidth() != null) {
            if (this.hoverControlWidth == null) {
                this.hoverControlPreferredWidth = hover.getHoverControlPreferredWidth();
                if (this.informationControl != null) {
                    this.informationControl.setSize(this.hoverControlPreferredWidth, this.informationControl.getBounds().height);
                }
            } else if (hover.getHoverControlPreferredWidth() > this.hoverControlWidth) {
                this.hoverControlPreferredWidth = hover.getHoverControlPreferredWidth();
                if (this.informationControl != null) {
                    this.informationControl.setSize(this.hoverControlPreferredWidth, this.informationControl.getBounds().height);
                }
            }
        }
    }

    protected void resizeDividerText(StyledText text, final int width) {
        if (width != this.lastDividerLen) {
            final String[] newDivider = new String[1];
            int oldLen = this.lastDividerLen;
            text.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    newDivider[0] = PydevCombiningHover.this.createDivider(width);
                }
            });
            String regex = "\\" + DIVIDER_CHAR + "{" + oldLen + "}\\n\\s\\" + DIVIDER_CHAR + "{" + Math.abs(oldLen - this.lastDividerLen) + "}";
            StyleRange[] ranges = text.getStyleRanges();
            text.setText(text.getText().replaceAll(regex, newDivider[0]));
            text.setStyleRanges(ranges);
        }
    }

    private String createDivider(int width) {
        Assert.isTrue((Display.getCurrent().getThread() == Thread.currentThread() ? 1 : 0) != 0, (String)"This method must be called from the UI thread");
        StringBuilder divider = new StringBuilder();
        this.getHoverControlCreator();
        GC gc = new GC((Drawable)this.viewer.getTextWidget().getDisplay());
        while (gc.stringExtent((String)divider.toString()).x < width) {
            divider.append(DIVIDER_CHAR);
        }
        divider.deleteCharAt(divider.length() - 1);
        gc.dispose();
        this.lastDividerLen = divider.length();
        return divider.toString();
    }

    private int getMaxExtent(String hoverText) {
        GC gc = new GC((Drawable)this.viewer.getTextWidget().getDisplay());
        int max = 0;
        String[] stringArray = hoverText.split("\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int extent;
            String line = stringArray[n2];
            if (!line.startsWith("FILE_PATH=") && (extent = gc.stringExtent((String)line).x) > max) {
                max = extent;
            }
            ++n2;
        }
        gc.dispose();
        return max;
    }

    @Override
    public boolean isContentTypeSupported(String contentType) {
        return true;
    }
}

