/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.hover.AbstractPyEditorTextHover;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.editor.hover.PydevCombiningHover;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

public class PyEditorTextHoverDescriptor {
    private static final String HOVER_TAG = "pyTextHover";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ACTIVATE_PLUG_IN_ATTRIBUTE = "activate";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String ATT_PYDEV_HOVER_PRIORITY = "priority";
    public static final String ATT_PYDEV_HOVER_LABEL = "label";
    public static final String ATT_PYDEV_HOVER_CLASS = "class";
    public static final String ATT_PYDEV_HOVER_ID = "id";
    public static final String ATT_PYDEV_HOVER_PREEMPT = "preempt";
    public static final String ATT_PYDEV_HOVER_ENABLE = "enable";
    public static final int DEFAULT_HOVER_PRIORITY = 100;
    public static final String NO_MODIFIER = "0";
    public static final Integer DEFAULT_MODIFIER_MASK = 0;
    public static final int HIGHEST_PRIORITY = 1;
    private static final String COMBINING_HOVER_ID = "org.python.pydev.combininghover";
    private static final String COMBINING_HOVER_LABEL = "PyDev Combining Hover";
    private static final String COMBINING_HOVER_DESCR = "A Text Hover which combines hover info from contributed hovers";
    int fStateMask;
    String fModifierString;
    private boolean fIsEnabled;
    private IConfigurationElement fElement;
    private Integer fPriority;
    private Boolean fPreempt;
    private AbstractPyEditorTextHover fHover;

    public static PyEditorTextHoverDescriptor[] getContributedHovers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.python.pydev.pydev_hover2");
        PyEditorTextHoverDescriptor[] hoverDescs = PyEditorTextHoverDescriptor.createDescriptors(elements);
        PyEditorTextHoverDescriptor.initializeDefaultHoverPreferences(elements);
        PyEditorTextHoverDescriptor.initializeHoversFromPreferences(hoverDescs);
        return hoverDescs;
    }

    public static int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = PyAction.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    public PyEditorTextHoverDescriptor(PydevCombiningHover hover) {
        Assert.isNotNull((Object)hover);
        this.fHover = hover;
        this.fPriority = 1;
        this.fIsEnabled = PyHoverPreferencesPage.getCombineHoverInfo();
    }

    private PyEditorTextHoverDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public AbstractPyEditorTextHover createTextHover() {
        if (this.fElement != null) {
            boolean isHoversPlugInActivated;
            String pluginId = this.fElement.getContributor().getName();
            boolean bl = isHoversPlugInActivated = Platform.getBundle((String)pluginId).getState() == 32;
            if (isHoversPlugInActivated || this.canActivatePlugIn()) {
                try {
                    return (AbstractPyEditorTextHover)this.fElement.createExecutableExtension(ATT_PYDEV_HOVER_CLASS);
                }
                catch (CoreException x) {
                    Log.log((Throwable)x);
                }
            }
            return null;
        }
        return this.fHover;
    }

    public String getId() {
        if (this.fElement != null) {
            return this.fElement.getAttribute(ATT_PYDEV_HOVER_ID);
        }
        return COMBINING_HOVER_ID;
    }

    public String getHoverClassName() {
        if (this.fElement != null) {
            return this.fElement.getAttribute(ATT_PYDEV_HOVER_CLASS);
        }
        return this.fHover.getClass().getName();
    }

    public String getLabel() {
        if (this.fElement != null) {
            String label = this.fElement.getAttribute("label");
            if (label != null) {
                return label;
            }
            label = this.getHoverClassName();
            int lastDot = label.lastIndexOf(46);
            if (lastDot >= 0 && lastDot < label.length() - 1) {
                return label.substring(lastDot + 1);
            }
            return label;
        }
        return COMBINING_HOVER_LABEL;
    }

    public String getDescription() {
        if (this.fElement != null) {
            return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        }
        return COMBINING_HOVER_DESCR;
    }

    public boolean canActivatePlugIn() {
        return this.fElement == null ? false : Boolean.valueOf(this.fElement.getAttribute(ACTIVATE_PLUG_IN_ATTRIBUTE));
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((PyEditorTextHoverDescriptor)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static PyEditorTextHoverDescriptor[] createDescriptors(IConfigurationElement[] elements) {
        ArrayList<PyEditorTextHoverDescriptor> result = new ArrayList<PyEditorTextHoverDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (HOVER_TAG.equals(element.getName())) {
                PyEditorTextHoverDescriptor desc = new PyEditorTextHoverDescriptor(element);
                result.add(desc);
            }
            ++i;
        }
        return result.toArray(new PyEditorTextHoverDescriptor[result.size()]);
    }

    public static void initializeDefaultHoverPreferences(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            int priority;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(ATT_PYDEV_HOVER_ID);
            PydevPrefs.getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_MODIFIER_" + id, NO_MODIFIER);
            PydevPrefs.getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + id, DEFAULT_MODIFIER_MASK.intValue());
            String attVal = element.getAttribute(ATT_PYDEV_HOVER_PREEMPT);
            PydevPlugin.getDefault().getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_PREEMPT_" + id, Boolean.parseBoolean(attVal));
            attVal = element.getAttribute(ATT_PYDEV_HOVER_ENABLE);
            PydevPlugin.getDefault().getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_ENABLE_" + id, Boolean.parseBoolean(attVal));
            attVal = element.getAttribute(ATT_PYDEV_HOVER_PRIORITY);
            try {
                priority = Integer.parseInt(attVal);
                priority = priority >= 1 ? priority : 1;
            }
            catch (NumberFormatException numberFormatException) {
                priority = 100;
            }
            PydevPlugin.getDefault().getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_PRORITY_" + id, priority);
            ++n2;
        }
    }

    public static void initializeHoversFromPreferences(PyEditorTextHoverDescriptor[] hovers) {
        int i = 0;
        while (i < hovers.length) {
            hovers[i].fIsEnabled = PydevPlugin.getDefault().getPreferenceStore().getBoolean("PYDEV_TEXT_HOVER_ENABLE_" + hovers[i].getId());
            hovers[i].fPreempt = PydevPlugin.getDefault().getPreferenceStore().getBoolean("PYDEV_TEXT_HOVER_PREEMPT_" + hovers[i].getId());
            String sPriority = PydevPlugin.getDefault().getPreferenceStore().getString("PYDEV_TEXT_HOVER_PRORITY_" + hovers[i].getId());
            try {
                hovers[i].fPriority = Integer.parseInt(sPriority);
            }
            catch (NumberFormatException numberFormatException) {
                hovers[i].fPriority = 100;
            }
            String modifierString = PydevPrefs.getPreferenceStore().getString("PYDEV_TEXT_HOVER_MODIFIER_" + hovers[i].getId());
            if (modifierString == null || modifierString.equals(NO_MODIFIER)) {
                modifierString = "";
            }
            hovers[i].fModifierString = modifierString;
            hovers[i].fStateMask = PyEditorTextHoverDescriptor.computeStateMask(modifierString);
            if (hovers[i].fStateMask == -1) {
                try {
                    hovers[i].fStateMask = Integer.parseInt(PydevPrefs.getPreferenceStore().getString("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + hovers[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    hovers[i].fStateMask = -1;
                }
                int stateMask = hovers[i].fStateMask;
                hovers[i].fModifierString = stateMask == -1 ? "" : PyAction.getModifierString(stateMask);
            }
            ++i;
        }
    }

    public int getStateMask() {
        return this.fStateMask;
    }

    public String getModifierString() {
        return this.fModifierString;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setIsEnabled(boolean enabled) {
        this.fIsEnabled = enabled;
    }

    public Integer getPriority() {
        return this.fPriority;
    }

    public void setPriority(int priority) {
        this.fPriority = priority;
    }

    public Boolean isPreempt() {
        return this.fPreempt;
    }

    public void setIsPreempt(boolean preempt) {
        this.fPreempt = preempt;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }
}

