/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editor.codecompletion.shell.ProcessCreationInfo;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.shared_core.io.FileUtils;

public class PythonShell
extends AbstractShell {
    public PythonShell() throws IOException, CoreException {
        super(PydevPlugin.getScriptWithinPySrc("pycompletionserver.py"));
    }

    @Override
    protected synchronized ProcessCreationInfo createServerProcess(IInterpreterInfo interpreter, int port) throws IOException {
        File file = new File(interpreter.getExecutableOrJar());
        if (file.isDirectory()) {
            throw new RuntimeException("The interpreter location found is a directory. " + interpreter);
        }
        String[] parameters = SimplePythonRunner.preparePythonCallParameters(interpreter.getExecutableOrJar(), FileUtils.getFileAbsolutePath((File)this.serverFile), new String[]{"" + port});
        IInterpreterManager manager = PydevPlugin.getPythonInterpreterManager();
        String[] envp = null;
        try {
            envp = SimpleRunner.getEnvironment(null, interpreter, manager);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        File workingDir = this.serverFile.getParentFile();
        return new ProcessCreationInfo(parameters, envp, workingDir, SimpleRunner.createProcess(parameters, envp, workingDir));
    }
}

