/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ManagerInfoToUpdate;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_core.structure.OrderedSet;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ThreadPriorityHelper;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.dialogs.SelectNDialog;
import org.python.pydev.ui.dialogs.TreeNodeLabelProvider;
import org.python.pydev.ui.pythonpathconf.DefaultPathsForInterpreterInfo;
import org.python.pydev.ui.pythonpathconf.IInterpreterInfoBuilder;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class SynchSystemModulesManager {
    public static final boolean DEBUG = false;
    private final JobApplyChanges jobApplyChanges = new JobApplyChanges();
    private boolean selectingElementsInDialog = false;
    private final Object selectingElementsInDialogLock = new Object();

    public void applySelectedChangesToInterpreterInfosPythonpath(DataAndImageTreeNode root, List<TreeNode> selectElements, IProgressMonitor monitor) {
        List<IInterpreterInfo> changedInfos = this.computeChanges(root, selectElements);
        if (changedInfos.size() > 0) {
            IInterpreterManager[] allInterpreterManagers;
            IInterpreterManager[] iInterpreterManagerArray = allInterpreterManagers = PydevPlugin.getAllInterpreterManagers();
            int n = allInterpreterManagers.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterManager manager = iInterpreterManagerArray[n2];
                if (manager != null) {
                    HashMap<String, IInterpreterInfo> changedInterpreterNameToInterpreter = new HashMap<String, IInterpreterInfo>();
                    for (IInterpreterInfo info : changedInfos) {
                        changedInterpreterNameToInterpreter.put(info.getName(), info);
                    }
                    IInterpreterInfo[] allInfos = manager.getInterpreterInfos();
                    ArrayList<IInterpreterInfo> newInfos = new ArrayList<IInterpreterInfo>(allInfos.length);
                    HashSet<String> changedNames = new HashSet<String>();
                    IInterpreterInfo[] iInterpreterInfoArray = allInfos;
                    int n3 = allInfos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IInterpreterInfo info = iInterpreterInfoArray[n4];
                        IInterpreterInfo changedInfo = (IInterpreterInfo)changedInterpreterNameToInterpreter.remove(info.getName());
                        if (changedInfo != null) {
                            newInfos.add(changedInfo);
                            changedNames.add(changedInfo.getExecutableOrJar());
                        } else {
                            newInfos.add(info);
                        }
                        ++n4;
                    }
                    if (changedNames.size() > 0) {
                        manager.setInfos(newInfos.toArray(new IInterpreterInfo[newInfos.size()]), changedNames, monitor);
                    }
                }
                ++n2;
            }
        }
    }

    public void updateStructures(IProgressMonitor monitor, DataAndImageTreeNode root, ManagerInfoToUpdate managerToNameToInfo, CreateInterpreterInfoCallback callback) {
        ImageCache imageCache;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((imageCache = SharedUiPlugin.getImageCache()) == null) {
            imageCache = new ImageCache(null){

                public Image get(String key) {
                    return null;
                }
            };
        }
        Tuple<IInterpreterManager, IInterpreterInfo>[] tupleArray = managerToNameToInfo.getManagerAndInfos();
        int n = tupleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple<IInterpreterManager, IInterpreterInfo> infos = tupleArray[n2];
            IInterpreterManager manager = (IInterpreterManager)infos.o1;
            IInterpreterInfo internalInfo = (IInterpreterInfo)infos.o2;
            String executable = internalInfo.getExecutableOrJar();
            IInterpreterInfo newInterpreterInfo = callback.createInterpreterInfo(manager, executable, monitor);
            if (newInterpreterInfo != null) {
                DefaultPathsForInterpreterInfo defaultPaths = new DefaultPathsForInterpreterInfo();
                OrderedSet newEntries = new OrderedSet((Collection)newInterpreterInfo.getPythonPath());
                newEntries.removeAll((Collection)internalInfo.getPythonPath());
                Iterator it = newEntries.iterator();
                while (it.hasNext()) {
                    String entryInPythonpath = (String)it.next();
                    if (defaultPaths.selectByDefault(entryInPythonpath) && defaultPaths.exists(entryInPythonpath)) continue;
                    it.remove();
                }
                OrderedSet removedEntries = new OrderedSet();
                List pythonPath = internalInfo.getPythonPath();
                for (String string : pythonPath) {
                    if (new File(string).exists()) continue;
                    removedEntries.add((Object)string);
                }
                if (newEntries.size() > 0 || removedEntries.size() > 0) {
                    DataAndImageTreeNode interpreterNode = new DataAndImageTreeNode(root, (Object)internalInfo, imageCache.get("icons/python_16x16.png"));
                    for (String s : newEntries) {
                        new DataAndImageTreeNode(interpreterNode, (Object)new PythonpathChange(s, true), imageCache.get("icons/jar_l_obj.gif"));
                    }
                    for (String s : removedEntries) {
                        new DataAndImageTreeNode(interpreterNode, (Object)new PythonpathChange(s, false), imageCache.get("icons/jar_remove_l_obj.gif"));
                    }
                }
            }
            ++n2;
        }
    }

    private List<TreeNode> selectElementsInDialog(DataAndImageTreeNode root, List<TreeNode> initialSelection) {
        List<TreeNode> selectElements = SelectNDialog.selectElements((TreeNode)root, new TreeNodeLabelProvider(){

            @Override
            public Image getImage(Object element) {
                DataAndImageTreeNode n = (DataAndImageTreeNode)element;
                return n.image;
            }

            @Override
            public String getText(Object element) {
                TreeNode n = (TreeNode)element;
                Object data = n.getData();
                if (data == null) {
                    return "null";
                }
                if (data instanceof IInterpreterInfo) {
                    IInterpreterInfo iInterpreterInfo = (IInterpreterInfo)data;
                    return iInterpreterInfo.getNameForUI();
                }
                return data.toString();
            }
        }, "System PYTHONPATH changes detected", "Please check which interpreters and paths should be updated.", true, initialSelection);
        return selectElements;
    }

    private List<IInterpreterInfo> computeChanges(DataAndImageTreeNode root, List<TreeNode> selectElements) {
        ArrayList<IInterpreterInfo> changedInfos = new ArrayList<IInterpreterInfo>();
        HashSet<TreeNode> set = new HashSet<TreeNode>(selectElements.size());
        set.addAll(selectElements);
        for (Object n : root.getChildren()) {
            DataAndImageTreeNode interpreterNode = (DataAndImageTreeNode)n;
            if (!set.contains(interpreterNode)) continue;
            IInterpreterInfo info = (IInterpreterInfo)interpreterNode.getData();
            List pythonPath = info.getPythonPath();
            boolean changed = false;
            OrderedSet newPythonPath = new OrderedSet((Collection)pythonPath);
            for (Object entryNode : interpreterNode.getChildren()) {
                DataAndImageTreeNode pythonpathNode = (DataAndImageTreeNode)entryNode;
                if (!set.contains(pythonpathNode)) continue;
                PythonpathChange change = (PythonpathChange)pythonpathNode.data;
                change.apply((OrderedSet<String>)newPythonPath);
                changed = true;
            }
            if (!changed) continue;
            InterpreterInfo copy = (InterpreterInfo)info.makeCopy();
            copy.libs.clear();
            copy.libs.addAll((Collection<String>)newPythonPath);
            changedInfos.add(copy);
        }
        return changedInfos;
    }

    public void synchronizeManagerToNameToInfoPythonpath(IProgressMonitor monitor, ManagerInfoToUpdate localManagerToNameToInfo, IInterpreterInfoBuilder builder) {
        Tuple<IInterpreterManager, IInterpreterInfo>[] managerAndInfos;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (builder == null) {
            builder = (IInterpreterInfoBuilder)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_interpreter_info_builder", (boolean)false);
        }
        Tuple<IInterpreterManager, IInterpreterInfo>[] tupleArray = managerAndInfos = localManagerToNameToInfo.getManagerAndInfos();
        int n = managerAndInfos.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple<IInterpreterManager, IInterpreterInfo> tuple = tupleArray[n2];
            InterpreterInfo info = (InterpreterInfo)tuple.o2;
            long initial = System.currentTimeMillis();
            builder.syncInfoToPythonPath(monitor, info);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSelectingElementsInDialog() {
        Object object = this.selectingElementsInDialogLock;
        synchronized (object) {
            return this.selectingElementsInDialog;
        }
    }

    void asyncSelectAndScheduleElementsToChangePythonpath(final DataAndImageTreeNode root, final ManagerInfoToUpdate managerToNameToInfo, final List<TreeNode> initialSelection) {
        RunInUiThread.async((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    Object object = SynchSystemModulesManager.this.selectingElementsInDialogLock;
                    synchronized (object) {
                        if (SynchSystemModulesManager.this.selectingElementsInDialog) {
                            return;
                        }
                        SynchSystemModulesManager.this.selectingElementsInDialog = true;
                    }
                    try {
                        if (!managerToNameToInfo.somethingChanged()) break block18;
                    }
                    catch (Throwable throwable) {
                        Object object2 = SynchSystemModulesManager.this.selectingElementsInDialogLock;
                        synchronized (object2) {
                            SynchSystemModulesManager.this.selectingElementsInDialog = false;
                        }
                        throw throwable;
                    }
                    Object object3 = SynchSystemModulesManager.this.selectingElementsInDialogLock;
                    synchronized (object3) {
                        SynchSystemModulesManager.this.selectingElementsInDialog = false;
                    }
                    return;
                }
                List selectedElements = SynchSystemModulesManager.this.selectElementsInDialog(root, initialSelection);
                SynchSystemModulesManager.this.saveUnselected(root, selectedElements, PydevPrefs.getPreferences());
                if (selectedElements != null && selectedElements.size() > 0) {
                    SynchSystemModulesManager.this.jobApplyChanges.stack(root, selectedElements, managerToNameToInfo);
                } else {
                    SynchSystemModulesManager.this.jobApplyChanges.stack(managerToNameToInfo);
                }
                SynchSystemModulesManager.this.jobApplyChanges.schedule();
                Object object = SynchSystemModulesManager.this.selectingElementsInDialogLock;
                synchronized (object) {
                    SynchSystemModulesManager.this.selectingElementsInDialog = false;
                }
            }
        });
    }

    public void saveUnselected(DataAndImageTreeNode root, List<TreeNode> selectedElements, IPreferenceStore iPreferenceStore) {
        HashSet<TreeNode> selectionSet = new HashSet<TreeNode>();
        if (selectedElements != null && selectedElements.size() > 0) {
            selectionSet.addAll(selectedElements);
        }
        boolean changed = false;
        for (DataAndImageTreeNode interpreterNode : root.getChildren()) {
            HashSet<TreeNode> addToIgnore = new HashSet<TreeNode>();
            if (!selectionSet.contains(interpreterNode)) {
                addToIgnore.addAll(interpreterNode.getChildren());
            } else {
                for (TreeNode pathNode : interpreterNode.getChildren()) {
                    if (selectionSet.contains(pathNode)) continue;
                    addToIgnore.add(pathNode);
                }
            }
            if (addToIgnore.size() <= 0) continue;
            IInterpreterInfo info = (IInterpreterInfo)interpreterNode.getData();
            String key = SynchSystemModulesManager.createKeyForInfo(info);
            ArrayList<String> addToIgnorePaths = new ArrayList<String>(addToIgnore.size());
            for (TreeNode node : addToIgnore) {
                PythonpathChange data = (PythonpathChange)node.getData();
                addToIgnorePaths.add(data.path);
            }
            changed = true;
            iPreferenceStore.setValue(key, StringUtils.join((String)"|||", addToIgnorePaths));
        }
        if (changed && iPreferenceStore instanceof IPersistentPreferenceStore) {
            IPersistentPreferenceStore iPersistentPreferenceStore = (IPersistentPreferenceStore)iPreferenceStore;
            try {
                iPersistentPreferenceStore.save();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public static String createKeyForInfo(IInterpreterInfo info) {
        return "synch_ignore_entries_" + StringUtils.md5((String)(String.valueOf(info.getName()) + "_" + info.getExecutableOrJar()));
    }

    public List<TreeNode> createInitialSelectionForDialogConsideringPreviouslyIgnored(DataAndImageTreeNode root, IPreferenceStore iPreferenceStore) {
        ArrayList<TreeNode> initialSelection = new ArrayList<TreeNode>();
        for (DataAndImageTreeNode interpreterNode : root.getChildren()) {
            IInterpreterInfo info = (IInterpreterInfo)interpreterNode.getData();
            String key = SynchSystemModulesManager.createKeyForInfo(info);
            String ignoredValue = iPreferenceStore.getString(key);
            if (ignoredValue != null && ignoredValue.length() > 0) {
                HashSet previouslyIgnored = new HashSet(StringUtils.split((String)ignoredValue, (String)"|||"));
                boolean added = false;
                for (TreeNode pathNode : interpreterNode.getChildren()) {
                    if (previouslyIgnored.contains(((PythonpathChange)pathNode.data).path)) continue;
                    initialSelection.add(pathNode);
                    added = true;
                }
                if (!added) continue;
                initialSelection.add((TreeNode)interpreterNode);
                continue;
            }
            initialSelection.add((TreeNode)interpreterNode);
            initialSelection.addAll(interpreterNode.getChildren());
        }
        return initialSelection;
    }

    public static class CreateInterpreterInfoCallback {
        public IInterpreterInfo createInterpreterInfo(IInterpreterManager manager, String executable, IProgressMonitor monitor) {
            boolean askUser = false;
            try {
                return manager.createInterpreterInfo(executable, monitor, askUser);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return null;
            }
        }
    }

    private class JobApplyChanges
    extends Job {
        private DataAndImageTreeNode root;
        private List<TreeNode> selectElements;
        private ManagerInfoToUpdate managerToNameToInfo;
        private final Object lock;

        public JobApplyChanges() {
            super("Apply PYTHONPATH changes");
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ThreadPriorityHelper priorityHelper = new ThreadPriorityHelper(this.getThread());
            priorityHelper.setMinPriority();
            try {
                ManagerInfoToUpdate localManagerToNameToInfo;
                List<TreeNode> localSelectElements;
                DataAndImageTreeNode localRoot;
                Object object = this.lock;
                synchronized (object) {
                    localRoot = this.root;
                    localSelectElements = this.selectElements;
                    localManagerToNameToInfo = this.managerToNameToInfo;
                    this.root = null;
                    this.selectElements = null;
                    this.managerToNameToInfo = null;
                }
                if (localRoot != null && localSelectElements != null) {
                    SynchSystemModulesManager.this.applySelectedChangesToInterpreterInfosPythonpath(localRoot, localSelectElements, monitor);
                } else if (localManagerToNameToInfo != null) {
                    SynchSystemModulesManager.this.synchronizeManagerToNameToInfoPythonpath(monitor, localManagerToNameToInfo, null);
                }
            }
            finally {
                priorityHelper.restoreInitialPriority();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stack(DataAndImageTreeNode root, List<TreeNode> selectElements, ManagerInfoToUpdate managerToNameToInfo) {
            Object object = this.lock;
            synchronized (object) {
                this.root = root;
                this.selectElements = selectElements;
                this.managerToNameToInfo = managerToNameToInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stack(ManagerInfoToUpdate managerToNameToInfo) {
            Object object = this.lock;
            synchronized (object) {
                this.root = null;
                this.selectElements = null;
                this.managerToNameToInfo = managerToNameToInfo;
            }
        }
    }

    public static class PythonpathChange {
        public final String path;
        public final boolean add;

        public PythonpathChange(String path, boolean add) {
            this.path = path;
            this.add = add;
        }

        public String toString() {
            if (this.add) {
                return "Add to PYTHONPATH: " + this.path;
            }
            return "Remove from PYTHONPATH: " + this.path;
        }

        public void apply(OrderedSet<String> newPythonPath) {
            if (this.add) {
                newPythonPath.add((Object)this.path);
            } else {
                newPythonPath.remove((Object)this.path);
            }
        }
    }
}

