/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.autoedit;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.docutils.PythonPairMatcher;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.autoedit.TestIndentPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.auto_edit.AutoEditStrategyNewLineHelper;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.NoPeerAvailableException;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocCmd;
import org.python.pydev.shared_interactive_console.console.ui.internal.IHandleScriptAutoEditStrategy;

public final class PyAutoIndentStrategy
implements IAutoEditStrategy,
IHandleScriptAutoEditStrategy {
    private IIndentPrefs prefs;
    private boolean blockSelection;
    private final IAdaptable projectAdaptable;
    IDocument EMPTY_DOCUMENT = new Document();
    private boolean isCython;

    public PyAutoIndentStrategy(IAdaptable projectAdaptable) {
        this.projectAdaptable = projectAdaptable;
    }

    public void setIndentPrefs(IIndentPrefs prefs) {
        this.prefs = prefs;
    }

    public IIndentPrefs getIndentPrefs() {
        if (this.prefs == null) {
            this.prefs = SharedCorePlugin.inTestMode() ? new TestIndentPrefs(true, 4) : new DefaultIndentPrefs(this.projectAdaptable);
        }
        return this.prefs;
    }

    private Tuple<String, Boolean> autoIndentNewline(IDocument document, int length, String text, int offset) throws BadLocationException {
        if (offset > 0) {
            PySelection selection = new PySelection(document, offset);
            String lineWithoutComments = selection.getLineContentsToCursor(true, true);
            Tuple<Integer, Boolean> tup = PyAutoIndentStrategy.determineSmartIndent(offset, document, this.prefs);
            int smartIndent = (Integer)tup.o1;
            boolean isInsidePar = (Boolean)tup.o2;
            if (lineWithoutComments.length() > 0) {
                int curr = lineWithoutComments.length() - 1;
                char lastChar = lineWithoutComments.charAt(curr);
                while (curr > 0 && Character.isWhitespace(lastChar)) {
                    lastChar = lineWithoutComments.charAt(--curr);
                }
                if (smartIndent == -1 && !isInsidePar && StringUtils.isClosingPeer((char)lastChar)) {
                    PythonPairMatcher matcher = new PythonPairMatcher(PyStringUtils.BRACKETS);
                    int bracketOffset = selection.getLineOffset() + curr;
                    IRegion region = matcher.match(document, bracketOffset + 1);
                    if (region != null && !PySelection.endsInSameLine((IDocument)document, (IRegion)region)) {
                        int openingBracketLine = document.getLineOfOffset(region.getOffset());
                        String openingBracketLineStr = PySelection.getLine((IDocument)document, (int)openingBracketLine);
                        int first = PySelection.getFirstCharPosition((String)openingBracketLineStr);
                        String initial = this.getCharsBeforeNewLine(text);
                        text = String.valueOf(initial) + openingBracketLineStr.substring(0, first);
                        return new Tuple((Object)text, (Object)isInsidePar);
                    }
                } else if (smartIndent == -1 && lastChar == ':') {
                    text = this.indentBasedOnStartingScope(text, selection, false);
                    return new Tuple((Object)text, (Object)isInsidePar);
                }
            }
            String trimmedLine = lineWithoutComments.trim();
            if (smartIndent >= 0 && (PyStringUtils.hasOpeningBracket((String)trimmedLine) || PyStringUtils.hasClosingBracket((String)trimmedLine))) {
                return new Tuple((Object)this.makeSmartIndent(text, smartIndent), (Object)isInsidePar);
            }
            if (PySelection.startsWithDedentToken((String)trimmedLine)) {
                if (lineWithoutComments.endsWith("\\")) {
                    return new Tuple((Object)(String.valueOf(text) + this.prefs.getIndentationString()), (Object)isInsidePar);
                }
                return new Tuple((Object)this.dedent(text), (Object)isInsidePar);
            }
            boolean indentBasedOnStartingScope = false;
            try {
                if (PySelection.containsOnlyWhitespaces((String)selection.getLineContentsFromCursor())) {
                    indentBasedOnStartingScope = true;
                }
            }
            catch (BadLocationException badLocationException) {
                indentBasedOnStartingScope = true;
            }
            if (indentBasedOnStartingScope) {
                String lineContentsToCursor = selection.getLineContentsToCursor();
                String trimmed = lineContentsToCursor.trim();
                if (trimmed.length() == 0) {
                    return new Tuple((Object)this.indentBasedOnStartingScope(text, selection, false), (Object)isInsidePar);
                }
                boolean endsWithTrippleSingle = trimmed.endsWith("'''");
                if ((endsWithTrippleSingle || trimmed.endsWith("\"\"\"")) && endsWithTrippleSingle) {
                    int cursorLine = -1;
                    try {
                        char c;
                        ParsingUtils parsingUtils = ParsingUtils.create((Object)selection.getDoc(), (boolean)true);
                        int cursorOffset = selection.getAbsoluteCursorOffset();
                        while (Character.isWhitespace(c = parsingUtils.charAt(--cursorOffset))) {
                        }
                        int startOffset = parsingUtils.eatLiteralsBackwards(null, cursorOffset);
                        cursorLine = selection.getLineOfOffset(startOffset);
                    }
                    catch (Exception exception) {}
                    if (cursorLine == -1) {
                        cursorLine = selection.getCursorLine();
                    }
                    return new Tuple((Object)this.indentBasedOnStartingScope(text, new PySelection(selection.getDoc(), cursorLine, 0), false), (Object)isInsidePar);
                }
            }
        }
        return new Tuple((Object)text, (Object)false);
    }

    private String indentBasedOnStartingScope(String text, PySelection selection, boolean checkForLowestBeforeNewScope) {
        PySelection.LineStartingScope previousIfLine = selection.getPreviousLineThatStartsScope();
        if (previousIfLine != null) {
            String initial = this.getCharsBeforeNewLine(text);
            if (previousIfLine.lineWithDedentWhileLookingScope == null) {
                String indent = PySelection.getIndentationFromLine((String)previousIfLine.lineStartingScope);
                if (checkForLowestBeforeNewScope && previousIfLine.lineWithLowestIndent != null) {
                    indent = PySelection.getIndentationFromLine((String)previousIfLine.lineWithLowestIndent);
                    text = String.valueOf(initial) + indent;
                } else {
                    text = String.valueOf(initial) + indent + this.prefs.getIndentationString();
                }
            } else {
                String indent = PySelection.getIndentationFromLine((String)previousIfLine.lineWithDedentWhileLookingScope);
                String indentationString = this.prefs.getIndentationString();
                int i = indent.length() - indentationString.length();
                text = i > 0 && indent.length() > i ? (String.valueOf(initial) + indent).substring(0, i + 1) : initial;
            }
        }
        return text;
    }

    private int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private void autoIndentSameAsPrevious(IDocument d, DocumentCommand c) {
        String txt = this.autoIndentSameAsPrevious(d, c.offset, c.text, true);
        if (txt != null) {
            c.text = txt;
        }
    }

    private String autoIndentSameAsPrevious(IDocument d, int offset, String text, boolean considerEmptyLines) {
        if (offset == -1 || d.getLength() == 0) {
            return null;
        }
        try {
            IRegion info = d.getLineInformationOfOffset(offset);
            String line = d.get(info.getOffset(), info.getLength());
            if (!considerEmptyLines) {
                int currLine = d.getLineOfOffset(offset);
                while (PySelection.containsOnlyWhitespaces((String)line)) {
                    if (--currLine < 0) break;
                    info = d.getLineInformation(currLine);
                    line = d.get(info.getOffset(), info.getLength());
                }
            }
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, offset);
            FastStringBuffer buf = new FastStringBuffer(text, end - start + 1);
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String dedent(String text) {
        String indentationString = this.prefs.getIndentationString();
        int indentationLength = indentationString.length();
        int len = text.length();
        if (len >= indentationLength) {
            text = text.substring(0, len - indentationLength);
        }
        return text;
    }

    private static Tuple<String, Integer> removeFirstIndent(String text, IIndentPrefs prefs) {
        String indentationString = prefs.getIndentationString();
        if (text.startsWith(indentationString)) {
            return new Tuple((Object)text.substring(indentationString.length()), (Object)indentationString.length());
        }
        return new Tuple((Object)text, (Object)0);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (this.blockSelection || !command.doit) {
            this.getIndentPrefs().convertToStd(document, command);
            return;
        }
        char c = command.text.length() == 1 ? command.text.charAt(0) : (char)'\u0000';
        String contentType = ParsingUtils.getContentType((IDocument)document, (int)command.offset);
        switch (c) {
            case '\"': 
            case '\'': {
                this.handleLiteral(document, command, contentType.equals("__dftl_partition_content_type"), c);
                return;
            }
        }
        boolean tabStopInComments = this.getIndentPrefs().getTabStopInComment();
        boolean isNewLine = AutoEditStrategyNewLineHelper.isNewLineText((IDocument)document, (int)command.length, (String)command.text);
        if (!contentType.equals("__dftl_partition_content_type")) {
            if (isNewLine) {
                if (ParsingUtils.isStringContentType((String)contentType)) {
                    this.autoIndentSameAsPrevious(document, command);
                    return;
                }
            } else if (!ParsingUtils.isCommentContentType((String)contentType) || c != '\t' || !tabStopInComments) {
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
        }
        try {
            if (isNewLine) {
                this.customizeNewLine(document, command);
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
            if (c == '\u0000') {
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
            if (c == '\t') {
                this.handleTab(document, command);
                this.getIndentPrefs().convertToStd(document, command);
                return;
            }
            this.getIndentPrefs().convertToStd(document, command);
            switch (c) {
                case '[': 
                case '{': {
                    char peer;
                    PySelection ps;
                    if (this.prefs.getAutoParentesis() && PyAutoIndentStrategy.shouldClose(ps = new PySelection(document, command.offset), c, peer = StringUtils.getPeer((char)c))) {
                        command.shiftsCaret = false;
                        command.text = String.valueOf(c) + peer;
                        command.caretOffset = command.offset + 1;
                    }
                    return;
                }
                case '(': {
                    PyAutoIndentStrategy.handleParens(document, command, this.prefs);
                    return;
                }
                case ':': {
                    if (this.prefs.getAutoColon()) {
                        this.performColonReplacement(document, command);
                    }
                    PyAutoIndentStrategy.autoDedentAfterColon(document, command, this.prefs);
                    return;
                }
                case ' ': {
                    if (this.prefs.getAutoWriteImport()) {
                        String importsTipperStr;
                        PySelection ps = new PySelection(document, command.offset);
                        String completeLine = ps.getLineWithoutCommentsOrLiterals();
                        String lineToCursor = ps.getLineContentsToCursor().trim();
                        String lineContentsFromCursor = ps.getLineContentsFromCursor();
                        if (!(completeLine.indexOf(" import ") != -1 || !StringUtils.leftTrim((String)completeLine).startsWith("from ") || completeLine.startsWith("import ") || completeLine.endsWith(" import") || lineToCursor.endsWith(" import") || lineContentsFromCursor.startsWith("import") || completeLine.startsWith("cimport ") || completeLine.endsWith(" cimport") || lineToCursor.endsWith(" cimport") || lineContentsFromCursor.startsWith("cimport") || (importsTipperStr = ImportsSelection.getImportsTipperStr((String)lineToCursor, (boolean)false).importsTipperStr).length() <= 0 || this.isCython)) {
                            command.text = " import ";
                        }
                    }
                    PyAutoIndentStrategy.autoDedentElif(document, command, this.getIndentPrefs());
                    return;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (this.prefs.getAutoBraces() && command.offset < document.getLength() && document.get(command.offset, 1).equals(command.text)) {
                        boolean found = false;
                        int i = 1;
                        while (i <= PyStringUtils.BRACKETS.length && !found) {
                            char b = PyStringUtils.BRACKETS[i];
                            if (b == c) {
                                found = true;
                                this.performPairReplacement(document, command);
                            }
                            i += 2;
                        }
                    }
                    return;
                }
            }
        }
        catch (BadLocationException e) {
            command.text = "BadLocationException";
            throw new RuntimeException(e);
        }
    }

    public static void handleParens(IDocument document, DocumentCommand command, IIndentPrefs prefs) throws BadLocationException {
        PyAutoIndentStrategy.autoDedentElif(document, command, prefs);
        PyAutoIndentStrategy.customizeParenthesis(document, command, false, prefs);
    }

    private void handleLiteral(IDocument document, DocumentCommand command, boolean isDefaultContext, char literalChar) {
        boolean hasMatchesAfter;
        if (!this.prefs.getAutoLiterals()) {
            return;
        }
        TextSelectionUtils ps = new TextSelectionUtils(document, (ITextSelection)new TextSelection(document, command.offset, command.length));
        if (command.length > 0) {
            try {
                ps.deleteSelection();
                command.length = 0;
                ps.setSelection(command.offset, command.offset);
            }
            catch (BadLocationException badLocationException) {}
        }
        try {
            char nextChar = ps.getCharAfterCurrentOffset();
            if (Character.isJavaIdentifierPart(nextChar)) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
        String cursorLineContents = ps.getCursorLineContents();
        if (cursorLineContents.indexOf(literalChar) == -1) {
            if (!isDefaultContext) {
                return;
            }
            command.text = StringUtils.getWithClosedPeer((char)literalChar);
            command.shiftsCaret = false;
            command.caretOffset = command.offset + 1;
            return;
        }
        boolean balanced = this.isLiteralBalanced(cursorLineContents);
        Tuple beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(literalChar);
        int matchesBefore = ((String)beforeAndAfterMatchingChars.o1).length();
        int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
        boolean hasMatchesBefore = matchesBefore != 0;
        boolean bl = hasMatchesAfter = matchesAfter != 0;
        if (!hasMatchesBefore && !hasMatchesAfter) {
            if (balanced) {
                if (!isDefaultContext) {
                    return;
                }
                command.text = StringUtils.getWithClosedPeer((char)literalChar);
                command.shiftsCaret = false;
                command.caretOffset = command.offset + 1;
            }
        } else if (matchesAfter == 1) {
            command.text = "";
            command.shiftsCaret = false;
            command.caretOffset = command.offset + 1;
        }
    }

    private boolean isLiteralBalanced(String cursorLineContents) {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)cursorLineContents, (boolean)true);
        int offset = 0;
        int end = cursorLineContents.length();
        boolean balanced = true;
        while (offset < end) {
            int eaten;
            char curr;
            if ((curr = cursorLineContents.charAt(offset++)) != '\"' && curr != '\'') continue;
            try {
                eaten = parsingUtils.eatLiterals(null, offset - 1) + 1;
            }
            catch (SyntaxErrorException syntaxErrorException) {
                balanced = false;
                break;
            }
            if (eaten <= offset) continue;
            offset = eaten;
        }
        return balanced;
    }

    private void handleTab(IDocument document, DocumentCommand command) throws BadLocationException {
        PySelection ps = new PySelection(document, command.offset);
        String lineContentsToCursor = ps.getLineContentsToCursor();
        int currSize = lineContentsToCursor.length();
        int cursorLine = ps.getCursorLine();
        if (lineContentsToCursor.trim().length() == 0) {
            int firstCharPosition;
            String nextLine = ps.getLine(cursorLine + 1);
            String prevLine = ps.getLine(cursorLine - 1);
            boolean forceTryOnNext = false;
            if (prevLine.trim().length() == 0 && nextLine.trim().length() > 0) {
                forceTryOnNext = true;
            }
            if ((forceTryOnNext || nextLine.trim().startsWith("@") || PySelection.matchesFunctionLine((String)nextLine)) && currSize < (firstCharPosition = PySelection.getFirstCharPosition((String)nextLine))) {
                String txt;
                command.text = txt = nextLine.substring(currSize, firstCharPosition);
                return;
            }
        }
        if (cursorLine > 0) {
            String prevExpectedIndent;
            IRegion prevLineInfo = document.getLineInformation(cursorLine - 1);
            int prevLineEndOffset = prevLineInfo.getOffset() + prevLineInfo.getLength();
            String txt = prevExpectedIndent = this.autoIndentSameAsPrevious(document, prevLineEndOffset, "\n", false);
            Tuple<String, Boolean> prevLineTup = this.autoIndentNewline(document, 0, txt, prevLineEndOffset);
            txt = (String)prevLineTup.o1;
            txt = txt.substring(1);
            prevExpectedIndent = prevExpectedIndent.substring(1);
            if (txt.length() > 0) {
                int sizeExpected = txt.length();
                int sizeApplied = currSize + sizeExpected;
                if (currSize >= sizeExpected) {
                    boolean applied = false;
                    if (((Boolean)prevLineTup.o2).booleanValue()) {
                        int len = sizeApplied - sizeExpected;
                        if (prevExpectedIndent.length() > len) {
                            command.text = prevExpectedIndent.substring(len);
                            applied = true;
                        }
                    }
                    if (!applied) {
                        this.applyDefaultForTab(command, currSize);
                    }
                } else if (sizeExpected == sizeApplied) {
                    if (command.length == 0) {
                        ps.deleteSpacesAfter(command.offset);
                    }
                    command.text = txt;
                } else if (sizeApplied > sizeExpected) {
                    ps.deleteSpacesAfter(command.offset);
                    command.text = txt.substring(0, sizeExpected - currSize);
                }
            } else {
                this.applyDefaultForTab(command, currSize);
            }
        } else {
            this.applyDefaultForTab(command, currSize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void customizeParenthesis(IDocument document, DocumentCommand command, boolean considerOnlyCurrentLine, IIndentPrefs prefs) throws BadLocationException {
        if (!prefs.getAutoParentesis()) return;
        PySelection ps = new PySelection(document, command.offset);
        String line = ps.getLine();
        if (!PyAutoIndentStrategy.shouldClose(ps, '(', ')')) return;
        boolean hasClass = line.indexOf("class ") != -1;
        boolean hasClassMethodDef = line.indexOf(" def ") != -1 || line.indexOf("\tdef ") != -1;
        boolean hasMethodDef = line.indexOf("def ") != -1;
        boolean hasDoublePoint = line.indexOf(":") != -1;
        command.shiftsCaret = false;
        if (!hasDoublePoint && (hasClass || hasClassMethodDef || hasMethodDef)) {
            if (hasClass) {
                command.text = "():";
                command.caretOffset = command.offset + 1;
                return;
            }
            if (hasClassMethodDef && prefs.getAutoAddSelf()) {
                String prevLine = ps.getLine(ps.getCursorLine() - 1);
                if (prevLine.indexOf("@classmethod") != -1) {
                    command.text = "(cls):";
                    command.caretOffset = command.offset + 4;
                    return;
                }
                if (prevLine.indexOf("@staticmethod") != -1) {
                    command.text = "():";
                    command.caretOffset = command.offset + 1;
                    return;
                }
                boolean addRegular = true;
                if (!considerOnlyCurrentLine) {
                    int firstCharPosition = PySelection.getFirstCharPosition((String)line);
                    PySelection.LineStartingScope scopeStart = ps.getPreviousLineThatStartsScope(PySelection.CLASS_AND_FUNC_TOKENS, false, firstCharPosition);
                    if (scopeStart != null) {
                        if (scopeStart.lineStartingScope != null && scopeStart.lineStartingScope.indexOf("def ") != -1) {
                            int iPrevDef;
                            int iCurrDef = PySelection.getFirstCharPosition((String)line);
                            if (iCurrDef > (iPrevDef = PySelection.getFirstCharPosition((String)scopeStart.lineStartingScope))) {
                                addRegular = false;
                            } else if (iCurrDef == iPrevDef && scopeStart.lineStartingScope.indexOf("self") == -1) {
                                if (scopeStart.iLineStartingScope <= 0) {
                                    addRegular = false;
                                } else {
                                    String line2;
                                    addRegular = false;
                                    int i = scopeStart.iLineStartingScope - 1;
                                    do {
                                        line2 = ps.getLine(i).trim();
                                        --i;
                                        if (!line2.startsWith("@classmethod") && !line2.startsWith("@staticmethod")) continue;
                                        addRegular = true;
                                        break;
                                    } while (line2.startsWith("@"));
                                }
                            }
                        }
                    } else {
                        addRegular = false;
                    }
                }
                if (addRegular) {
                    command.text = "(self):";
                    command.caretOffset = command.offset + 5;
                    return;
                } else {
                    command.text = "():";
                    command.caretOffset = command.offset + 1;
                }
                return;
            }
            if (!hasMethodDef) throw new RuntimeException(String.valueOf(PyAutoIndentStrategy.class.toString()) + ": customizeDocumentCommand()");
            command.text = "():";
            command.caretOffset = command.offset + 1;
            return;
        }
        command.text = "()";
        command.caretOffset = command.offset + 1;
    }

    public void customizeNewLine(IDocument document, DocumentCommand command) throws BadLocationException {
        this.prefs = this.getIndentPrefs();
        this.autoIndentSameAsPrevious(document, command);
        if (this.prefs.getSmartIndentPar()) {
            PySelection selection = new PySelection(document, command.offset);
            if (selection.getCursorLineContents().trim().length() > 0) {
                command.text = (String)this.autoIndentNewline((IDocument)document, (int)command.length, (String)command.text, (int)command.offset).o1;
                if (PySelection.containsOnlyWhitespaces((String)selection.getLineContentsToCursor())) {
                    command.caretOffset = command.offset + selection.countSpacesAfter(command.offset);
                }
            }
        } else {
            TextSelectionUtils selection = new TextSelectionUtils(document, command.offset);
            if (selection.getLineContentsToCursor().trim().endsWith(":")) {
                command.text = String.valueOf(command.text) + this.prefs.getIndentationString();
            }
        }
    }

    private void applyDefaultForTab(DocumentCommand command, int lineContentsToCursorLen) {
        IIndentPrefs prefs = this.getIndentPrefs();
        if (prefs.getUseSpaces(true)) {
            int tabWidth = this.getIndentPrefs().getTabWidth();
            int mod = (lineContentsToCursorLen + tabWidth) % tabWidth;
            command.text = StringUtils.createSpaceString((int)(tabWidth - mod));
        }
    }

    public static Tuple<String, Integer> autoDedentAfterColon(IDocument document, DocumentCommand command, String tok, String[] tokens, IIndentPrefs prefs) throws BadLocationException {
        String previousIfLine;
        PySelection ps;
        String lineContents;
        if (prefs.getAutoDedentElse() && command.doit && (lineContents = (ps = new PySelection(document, command.offset)).getCursorLineContents()).trim().equals(tok) && (previousIfLine = ps.getPreviousLineThatStartsWithToken(tokens)) != null) {
            String ifIndent = PySelection.getIndentationFromLine((String)previousIfLine);
            String lineIndent = PySelection.getIndentationFromLine((String)lineContents);
            String indent = prefs.getIndentationString();
            if (lineIndent.length() == ifIndent.length() + indent.length()) {
                Tuple<String, Integer> dedented = PyAutoIndentStrategy.removeFirstIndent(lineContents, prefs);
                ps.replaceLineContentsToSelection((String)dedented.o1);
                command.offset -= ((Integer)dedented.o2).intValue();
                return dedented;
            }
        }
        return null;
    }

    public static Tuple<String, Integer> autoDedentAfterColon(IDocument document, DocumentCommand command, IIndentPrefs prefs) throws BadLocationException {
        Tuple<String, Integer> ret = null;
        ret = PyAutoIndentStrategy.autoDedentAfterColon(document, command, "else", PySelection.TOKENS_BEFORE_ELSE, prefs);
        if (ret != null) {
            return ret;
        }
        ret = PyAutoIndentStrategy.autoDedentAfterColon(document, command, "except", PySelection.TOKENS_BEFORE_EXCEPT, prefs);
        if (ret != null) {
            return ret;
        }
        ret = PyAutoIndentStrategy.autoDedentAfterColon(document, command, "finally", PySelection.TOKENS_BEFORE_FINALLY, prefs);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static Tuple<String, Integer> autoDedentElif(IDocument document, DocumentCommand command, IIndentPrefs prefs) throws BadLocationException {
        return PyAutoIndentStrategy.autoDedentAfterColon(document, command, "elif", PySelection.TOKENS_BEFORE_ELIF, prefs);
    }

    private String makeSmartIndent(String text, int smartIndent) throws BadLocationException {
        if (smartIndent > 0) {
            String initial = text;
            initial = this.getCharsBeforeNewLine(initial);
            String indentationString = this.prefs.getIndentationString();
            int indentationSteps = smartIndent / this.prefs.getTabWidth();
            int spaceSteps = smartIndent % this.prefs.getTabWidth();
            StringBuffer b = new StringBuffer(smartIndent);
            while (indentationSteps > 0) {
                --indentationSteps;
                b.append(indentationString);
            }
            if (this.prefs.getUseSpaces(true)) {
                while (spaceSteps >= 0) {
                    --spaceSteps;
                    b.append(" ");
                }
            }
            return String.valueOf(initial) + b.toString();
        }
        return text;
    }

    private String getCharsBeforeNewLine(String initial) {
        int initialLength = initial.length();
        int i = 0;
        while (i < initialLength) {
            char theChar = initial.charAt(i);
            if (theChar != '\r' && theChar != '\n') {
                if (i <= 0) break;
                initial = initial.substring(0, i);
                break;
            }
            ++i;
        }
        return initial;
    }

    private void performColonReplacement(IDocument document, DocumentCommand command) {
        int documentLength;
        PySelection ps = new PySelection(document, command.offset);
        int absoluteOffset = ps.getAbsoluteCursorOffset();
        if (absoluteOffset < (documentLength = ps.getDoc().getLength())) {
            try {
                char currentCharacter = document.getChar(absoluteOffset);
                if (currentCharacter == ':') {
                    command.text = "";
                    command.caretOffset = command.offset + 1;
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void performPairReplacement(IDocument document, DocumentCommand command) throws BadLocationException {
        boolean skipChar = this.canSkipCloseParenthesis(document, command);
        if (skipChar) {
            command.text = "";
            command.caretOffset = command.offset + 1;
        }
    }

    public boolean canSkipCloseParenthesis(IDocument document, DocumentCommand command) throws BadLocationException {
        PySelection ps = new PySelection(document, command.offset);
        char c = ps.getCharAtCurrentOffset();
        try {
            char peer = StringUtils.getPeer((char)c);
            FastStringBuffer doc = new FastStringBuffer(document.get(), 2);
            ParsingUtils.removeCommentsWhitespacesAndLiterals((FastStringBuffer)doc, (boolean)false);
            int chars = StringUtils.countChars((char)c, (FastStringBuffer)doc);
            int peers = StringUtils.countChars((char)peer, (FastStringBuffer)doc);
            boolean skipChar = chars == peers;
            return skipChar;
        }
        catch (NoPeerAvailableException noPeerAvailableException) {
            return false;
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean shouldClose(PySelection ps, char c, char peer) throws BadLocationException {
        int closingPeerLine;
        PySelection.LineStartingScope nextLineThatStartsScope;
        PythonPairMatcher matcher = new PythonPairMatcher(PyStringUtils.BRACKETS);
        String lineContentsFromCursor = ps.getLineContentsFromCursor();
        int i = 0;
        while (i < lineContentsFromCursor.length()) {
            char charAt = lineContentsFromCursor.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                if (charAt == ',' || StringUtils.isClosingPeer((char)charAt)) break;
                return false;
            }
            ++i;
        }
        int lineStartingNextScope = (nextLineThatStartsScope = ps.getNextLineThatStartsScope()) == null ? Integer.MAX_VALUE : nextLineThatStartsScope.iLineStartingScope;
        int closingPeerFoundAtOffset = ps.getAbsoluteCursorOffset() - 1;
        do {
            if ((closingPeerFoundAtOffset = matcher.searchForClosingPeer(closingPeerFoundAtOffset, c, peer, ps.getDoc())) == -1) {
                return true;
            }
            IRegion match = matcher.match(ps.getDoc(), closingPeerFoundAtOffset + 1);
            if (match == null) {
                return false;
            }
            try {
                closingPeerLine = ps.getDoc().getLineOfOffset(closingPeerFoundAtOffset);
            }
            catch (Exception exception) {
                break;
            }
        } while (lineStartingNextScope > closingPeerLine);
        return true;
    }

    public static Tuple<Integer, Boolean> determineSmartIndent(int offset, IDocument document, IIndentPrefs prefs) throws BadLocationException {
        PythonPairMatcher matcher = new PythonPairMatcher(PyStringUtils.BRACKETS);
        int openingPeerOffset = matcher.searchForAnyOpeningPeer(offset, document);
        if (openingPeerOffset == -1) {
            return new Tuple((Object)-1, (Object)false);
        }
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(openingPeerOffset);
        boolean openingPeerIsInCurrentLine = PySelection.isInside((int)offset, (IRegion)lineInformationOfOffset);
        int len = -1;
        String contents = "";
        if (prefs.getIndentToParLevel()) {
            String fromParToCursor;
            PySelection ps = new PySelection(document, offset);
            String lineContentsToCursor = ps.getLineContentsToCursor();
            if (!openingPeerIsInCurrentLine && !PyStringUtils.hasUnbalancedClosingPeers((String)lineContentsToCursor)) {
                try {
                    char openingChar = document.getChar(openingPeerOffset);
                    int closingPeerOffset = matcher.searchForClosingPeer(openingPeerOffset, openingChar, StringUtils.getPeer((char)openingChar), document);
                    if (closingPeerOffset == -1 || offset <= closingPeerOffset) {
                        return new Tuple((Object)-1, (Object)true);
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return new Tuple((Object)-1, (Object)true);
                }
            }
            if (openingPeerIsInCurrentLine && openingPeerOffset < offset && (fromParToCursor = document.get(openingPeerOffset, offset - openingPeerOffset)).length() > 0 && fromParToCursor.charAt(0) == '(' && !PySelection.containsOnlyWhitespaces((String)(fromParToCursor = fromParToCursor.substring(1)))) {
                int firstCharPosition = PySelection.getFirstCharPosition((String)fromParToCursor);
                openingPeerOffset += firstCharPosition;
            }
            int openingPeerLineOffset = lineInformationOfOffset.getOffset();
            len = openingPeerOffset - openingPeerLineOffset;
            contents = document.get(openingPeerLineOffset, len);
        } else {
            if (!openingPeerIsInCurrentLine) {
                return new Tuple((Object)-1, (Object)true);
            }
            int line = document.getLineOfOffset(openingPeerOffset);
            String indent = prefs.getIndentationString();
            contents = PySelection.getLine((IDocument)document, (int)line);
            contents = PySelection.getIndentationFromLine((String)contents);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < prefs.getIndentAfterParWidth()) {
                sb.append(indent);
                ++i;
            }
            contents = String.valueOf(contents) + sb.substring(0, sb.length() - 1);
            len = contents.length();
        }
        int i = 0;
        while (i < contents.length()) {
            if (contents.charAt(i) == '\t') {
                len += prefs.getTabWidth() - 1;
            }
            ++i;
        }
        return new Tuple((Object)len, (Object)true);
    }

    public void setBlockSelection(boolean blockSelection) {
        this.blockSelection = blockSelection;
    }

    public void customizeParenthesis(IDocument doc, DocumentCommand docCmd) throws BadLocationException {
        PyAutoIndentStrategy.customizeParenthesis(doc, docCmd, true, this.getIndentPrefs());
    }

    public String convertTabs(String cmd) {
        DocCmd newStr = new DocCmd(0, 0, cmd);
        this.getIndentPrefs().convertToStd(this.EMPTY_DOCUMENT, (DocumentCommand)newStr);
        cmd = newStr.text;
        return cmd;
    }

    public void setCythonFile(boolean isCython) {
        this.isCython = isCython;
    }
}

