/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.actions.OrganizeImportsFixesUnused;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.organize_imports.ImportArranger;
import org.python.pydev.editor.actions.organize_imports.Pep8ImportArranger;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.ui.importsconf.ImportsPreferencesPage;

public class PyOrganizeImports
extends PyAction
implements IFormatter {
    private final boolean automatic;

    public PyOrganizeImports() {
        this.automatic = false;
    }

    public PyOrganizeImports(boolean automatic) {
        this.automatic = automatic;
    }

    public void run(IAction action) {
        block7: {
            try {
                if (!this.canModifyEditor()) {
                    return;
                }
                PyEdit pyEdit = this.getPyEdit();
                PySelection ps = new PySelection((ITextEditor)pyEdit);
                IDocument doc = ps.getDoc();
                if (ps.getStartLineIndex() == ps.getEndLineIndex()) {
                    this.organizeImports(pyEdit, doc, null, ps);
                    break block7;
                }
                DocumentRewriteSession session = TextSelectionUtils.startWrite((IDocument)doc);
                try {
                    ps.performSimpleSort(doc, ps.getStartLineIndex(), ps.getEndLineIndex());
                }
                finally {
                    TextSelectionUtils.endWrite((IDocument)doc, (DocumentRewriteSession)session);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                PyOrganizeImports.beep(e);
            }
        }
    }

    private void organizeImports(PyEdit edit, IDocument doc, IFile f, PySelection ps) {
        DocumentRewriteSession session = null;
        String endLineDelim = ps.getEndLineDelim();
        List participants = null;
        if (f == null && !this.automatic) {
            participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_organize_imports");
            for (IOrganizeImports organizeImports : participants) {
                if (organizeImports.beforePerformArrangeImports(ps, edit, f)) continue;
                return;
            }
        }
        PyEdit projectAdaptable = edit != null ? edit : f;
        String indentStr = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get((IAdaptable)f).getIndentationString();
        session = TextSelectionUtils.startWrite((IDocument)doc);
        try {
            boolean pep8;
            boolean removeUnusedImports = false;
            if (!this.automatic && (removeUnusedImports = ImportsPreferencesPage.getDeleteUnusedImports(projectAdaptable))) {
                new OrganizeImportsFixesUnused().beforePerformArrangeImports(ps, edit, f);
            }
            if (pep8 = ImportsPreferencesPage.getPep8Imports(projectAdaptable)) {
                if (f == null) {
                    f = edit.getIFile();
                }
                IProject p = f != null ? f.getProject() : null;
                PyOrganizeImports.pep8PerformArrangeImports(doc, removeUnusedImports, endLineDelim, p, indentStr, this.automatic, (IPyFormatStdProvider)edit);
            } else {
                PyOrganizeImports.performArrangeImports(doc, removeUnusedImports, endLineDelim, indentStr, this.automatic, (IPyFormatStdProvider)edit);
            }
            if (participants != null) {
                for (IOrganizeImports organizeImports : participants) {
                    organizeImports.afterPerformArrangeImports(ps, edit);
                }
            }
        }
        finally {
            TextSelectionUtils.endWrite((IDocument)doc, (DocumentRewriteSession)session);
        }
    }

    public static void performArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        new ImportArranger(doc, removeUnusedImports, endLineDelim, indentStr, automatic, edit).perform();
    }

    public static void pep8PerformArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, IProject prj, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        new Pep8ImportArranger(doc, removeUnusedImports, endLineDelim, prj, indentStr, automatic, edit).perform();
    }

    public static void performArrangeImports(Document doc, String endLineDelim, String indentStr, IPyFormatStdProvider edit) {
        PyOrganizeImports.performArrangeImports((IDocument)doc, false, endLineDelim, indentStr, false, edit);
    }

    public static void performPep8ArrangeImports(Document doc, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        IProject project = null;
        PyOrganizeImports.pep8PerformArrangeImports((IDocument)doc, false, endLineDelim, project, indentStr, automatic, edit);
    }

    public void formatAll(IDocument doc, IPyFormatStdProvider edit, IFile f, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        this.organizeImports((PyEdit)edit, doc, f, new PySelection(doc));
    }

    public void formatSelection(IDocument doc, int[] regionsToFormat, IPyFormatStdProvider edit, PySelection ps) {
        throw new UnsupportedOperationException();
    }
}

