/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.actions.BaseAction;
import org.python.pydev.utils.Messages;
import org.python.pydev.utils.PyEditorMessages;

public abstract class PyAction
extends BaseAction
implements IEditorActionDelegate {
    protected PyAction() {
    }

    protected PyAction(String text, int style) {
        super(text, style);
    }

    public static String getDelimiter(IDocument doc) {
        return PySelection.getDelimiter((IDocument)doc);
    }

    protected PyEdit getPyEdit() {
        if (this.targetEditor instanceof PyEdit) {
            return (PyEdit)this.targetEditor;
        }
        throw new RuntimeException("Expecting PyEdit editor. Found:" + this.targetEditor.getClass().getName());
    }

    protected boolean canModifyEditor() {
        ITextEditor editor = this.getTextEditor();
        return BaseAction.canModifyEditor((ITextEditor)editor);
    }

    protected void isInFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            String src = doc.get(offset, region.getLength());
            if ("".equals(src)) {
                return;
            }
            int i = 0;
            while (i < src.length()) {
                if (!Character.isWhitespace(src.charAt(i))) break;
                ++i;
            }
            this.setCaretPosition(offset + i - 1);
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
            return;
        }
    }

    protected int getLastCharPosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        int offset = region.getOffset();
        String src = doc.get(offset, region.getLength());
        int i = src.length();
        boolean breaked = false;
        while (i > 0) {
            if (Character.isWhitespace(src.charAt(--i)) || src.charAt(i) == '\t') continue;
            breaked = true;
            break;
        }
        if (!breaked) {
            --i;
        }
        return offset + i;
    }

    protected void gotoFirstChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            this.setCaretPosition(offset);
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
        }
    }

    protected void gotoFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            this.setCaretPosition(PySelection.getFirstCharPosition((IDocument)doc, (int)cursorOffset));
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
        }
    }

    protected boolean isAtFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            return PySelection.getFirstCharPosition((IDocument)doc, (int)cursorOffset) == cursorOffset;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected static void beep(Exception e) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().beep();
        }
        catch (Throwable throwable) {}
        Log.log((Throwable)e);
    }

    public static String getLineWithoutComments(String sel) {
        return sel.replaceAll("#.*", "");
    }

    public static String getLineWithoutComments(PySelection ps) {
        return PyAction.getLineWithoutComments(ps.getCursorLineContents());
    }

    public static String lowerChar(String s, int pos) {
        char[] ds = s.toCharArray();
        ds[pos] = Character.toLowerCase(ds[pos]);
        return new String(ds);
    }

    public static boolean stillInTok(String string, int j) {
        char c = string.charAt(j);
        return c != '\n' && c != '\r' && c != ' ' && c != '.' && c != '(' && c != ')' && c != ',' && c != ']' && c != '[' && c != '#' && c != '\'' && c != '\"';
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = PyAction.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = PyAction.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = PyAction.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = PyAction.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format(PyEditorMessages.EditorUtility_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    protected void revealSelEndLine(PySelection ps) {
        int docLen = ps.getDoc().getLength() - 1;
        IRegion endLine = ps.getEndLine();
        if (endLine != null) {
            int curOffset = endLine.getOffset();
            this.getTextEditor().selectAndReveal(curOffset < docLen ? curOffset : docLen, 0);
        }
    }

    public static Set<IFile> getOpenFiles() {
        HashSet<IFile> ret = new HashSet<IFile>();
        IWorkbenchWindow activeWorkbenchWindow = EditorUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return ret;
        }
        IWorkbenchPage[] pages = activeWorkbenchWindow.getPages();
        int i = 0;
        while (i < pages.length) {
            IEditorReference[] editorReferences = pages[i].getEditorReferences();
            int j = 0;
            while (j < editorReferences.length) {
                IEditorReference iEditorReference = editorReferences[j];
                if ("org.python.pydev.editor.PythonEditor".equals(iEditorReference.getId())) {
                    try {
                        IFile file;
                        IEditorInput editorInput = iEditorReference.getEditorInput();
                        if (editorInput != null && (file = (IFile)editorInput.getAdapter(IFile.class)) != null) {
                            ret.add(file);
                        }
                    }
                    catch (Exception e1) {
                        Log.log((Throwable)e1);
                    }
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

