/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pylint;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.pylint.PyLintPrefPage;
import org.python.pydev.consoles.MessageConsoles;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;

public class PyLintVisitor
extends PyDevBuilderVisitor {
    public static final String PYLINT_PROBLEM_MARKER = "org.python.pydev.pylintproblemmarker";
    public static final List<PyLintThread> pyLintThreads = new ArrayList<PyLintThread>();
    private static Object lock = new Object();

    @Override
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        IFile file;
        IPath location;
        if (document == null) {
            return;
        }
        try {
            resource.deleteMarkers(PYLINT_PROBLEM_MARKER, false, 0);
        }
        catch (CoreException e3) {
            Log.log((Throwable)e3);
        }
        if (!PyLintPrefPage.usePyLint()) {
            return;
        }
        IProject project = resource.getProject();
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        try {
            if (pythonNature.getInterpreterType() != 0) {
                return;
            }
            if (!this.isResourceInPythonpathProjectSources(resource, pythonNature, false)) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (project != null && resource instanceof IFile && (location = (file = (IFile)resource).getRawLocation()) != null) {
            PyLintThread thread = new PyLintThread(resource, document, location);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String cmdLineToExe, IOConsoleOutputStream out, Object ... args) {
        block11: {
            try {
                if (out == null) break block11;
                Object object = lock;
                synchronized (object) {
                    if (args != null) {
                        Object[] objectArray = args;
                        int n = args.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object arg = objectArray[n2];
                            if (arg instanceof String) {
                                cmdLineToExe = String.valueOf(cmdLineToExe) + " " + arg;
                            } else if (arg instanceof String[]) {
                                String[] strings;
                                String[] stringArray = strings = (String[])arg;
                                int n3 = strings.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String string = stringArray[n4];
                                    cmdLineToExe = String.valueOf(cmdLineToExe) + " " + string;
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    out.write(String.valueOf(cmdLineToExe) + "\n");
                }
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
    }

    @Override
    public int maxResourcesToVisit() {
        int i = PyLintPrefPage.getMaxPyLintDelta();
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    public static class PyLintThread
    extends Thread {
        IResource resource;
        ICallback0<IDocument> document;
        IPath location;
        List<Object[]> markers = new ArrayList<Object[]>();
        private static Pattern PYLINT_MATCH_PATTERN = Pattern.compile("\\A[CRWEF]:\\s*(\\d+)(,\\s*\\d+)?:(.*)\\((.*)\\)\\s*\\Z");

        public PyLintThread(IResource resource, ICallback0<IDocument> document, IPath location) {
            this.setName("PyLint thread");
            this.resource = resource;
            this.document = document;
            this.location = location;
        }

        private boolean canPassPyLint() {
            if (pyLintThreads.size() < PyLintPrefPage.getMaxPyLintDelta()) {
                pyLintThreads.add(this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            try {
                try {
                    if (this.canPassPyLint()) {
                        IOConsoleOutputStream out = this.getConsoleOutputStream();
                        final IDocument doc = (IDocument)this.document.call();
                        this.passPyLint(this.resource, out, doc);
                        new Job("Adding markers"){

                            protected IStatus run(IProgressMonitor monitor) {
                                ArrayList<PyMarkerUtils.MarkerInfo> lst = new ArrayList<PyMarkerUtils.MarkerInfo>();
                                for (Object[] el : markers) {
                                    String tok = (String)el[0];
                                    int priority = (Integer)el[1];
                                    String id = (String)el[2];
                                    int line = (Integer)el[3];
                                    lst.add(new PyMarkerUtils.MarkerInfo(doc, "ID:" + id + " " + tok, PyLintVisitor.PYLINT_PROBLEM_MARKER, priority, false, false, line, 0, line, 0, null));
                                }
                                PyMarkerUtils.replaceMarkers(lst, (IResource)resource, (String)PyLintVisitor.PYLINT_PROBLEM_MARKER, (boolean)true, (IProgressMonitor)monitor);
                                return PydevPlugin.makeStatus(0, "", null);
                            }
                        }.schedule();
                    }
                }
                catch (Exception e) {
                    new Job("Error reporting"){

                        protected IStatus run(IProgressMonitor monitor) {
                            Log.log((Throwable)e);
                            return PydevPlugin.makeStatus(0, "", null);
                        }
                    }.schedule();
                    try {
                        pyLintThreads.remove(this);
                    }
                    catch (Exception e2) {
                        Log.log((Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    pyLintThreads.remove(this);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }

        private IOConsoleOutputStream getConsoleOutputStream() throws MalformedURLException {
            if (PyLintPrefPage.useConsole()) {
                return MessageConsoles.getConsoleOutputStream("PyLint", "icons/pylint.png");
            }
            return null;
        }

        private void addToMarkers(String tok, int priority, String id, int line) {
            this.markers.add(new Object[]{tok, priority, id, line});
        }

        /*
         * Unable to fully structure code
         */
        private void passPyLint(IResource resource, IOConsoleOutputStream out, IDocument doc) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
            script = FileUtils.getFileAbsolutePath((File)new File(PyLintPrefPage.getPyLintLocation()));
            target = FileUtils.getFileAbsolutePath((File)new File(this.location.toOSString()));
            isPyScript = script.endsWith(".py") != false || script.endsWith(".pyw") != false;
            cmdList = new ArrayList<String>();
            if (!isPyScript) {
                cmdList.add(script);
            }
            userArgs = StringUtils.replaceNewLines((String)PyLintPrefPage.getPyLintArgs(), (String)" ");
            tokenizer2 = new StringTokenizer(userArgs);
            while (tokenizer2.hasMoreTokens()) {
                cmdList.add(tokenizer2.nextToken());
            }
            cmdList.add(target);
            cmdArray = cmdList.toArray(new String[0]);
            project = resource.getProject();
            workingDir = project.getLocation().toFile();
            if (isPyScript) {
                nature = PythonNature.getPythonNature(project);
                if (nature == null) {
                    e = new RuntimeException("PyLint ERROR: Nature not configured for: " + project);
                    Log.log((Throwable)e);
                    return;
                }
                interpreter = nature.getProjectInterpreter().getExecutableOrJar();
                PyLintVisitor.write("PyLint: Executing command line:", out, new Object[]{script, cmdArray});
                outTup = new SimplePythonRunner().runAndGetOutputFromPythonScript(interpreter, script, cmdArray, workingDir, project);
            } else {
                PyLintVisitor.write("PyLint: Executing command line:", out, new Object[]{cmdArray});
                outTup = new SimpleRunner().runAndGetOutput(cmdArray, workingDir, PythonNature.getPythonNature(project), null, null);
            }
            output = (String)outTup.o1;
            errors = (String)outTup.o2;
            PyLintVisitor.write("PyLint: The stdout of the command line is:", out, new Object[]{output});
            PyLintVisitor.write("PyLint: The stderr of the command line is:", out, new Object[]{errors});
            tokenizer = new StringTokenizer(output, "\r\n");
            useW = PyLintPrefPage.useWarnings();
            useE = PyLintPrefPage.useErrors();
            useF = PyLintPrefPage.useFatal();
            useC = PyLintPrefPage.useCodingStandard();
            useR = PyLintPrefPage.useRefactorTips();
            wSeverity = PyLintPrefPage.wSeverity();
            eSeverity = PyLintPrefPage.eSeverity();
            fSeverity = PyLintPrefPage.fSeverity();
            cSeverity = PyLintPrefPage.cSeverity();
            rSeverity = PyLintPrefPage.rSeverity();
            if (output.indexOf("Traceback (most recent call last):") != -1) {
                e = new RuntimeException("PyLint ERROR: \n" + output);
                Log.log((Throwable)e);
                return;
            }
            if (errors.indexOf("Traceback (most recent call last):") == -1) ** GOTO lbl121
            e = new RuntimeException("PyLint ERROR: \n" + errors);
            Log.log((Throwable)e);
            return;
lbl-1000:
            // 1 sources

            {
                tok = tokenizer.nextToken();
                try {
                    found = false;
                    priority = 0;
                    indexOfDoublePoints = tok.indexOf(":");
                    if (indexOfDoublePoints == -1) continue;
                    if (tok.startsWith("C") && useC) {
                        found = true;
                        priority = cSeverity;
                    } else if (tok.startsWith("R") && useR) {
                        found = true;
                        priority = rSeverity;
                    } else if (tok.startsWith("W") && useW) {
                        found = true;
                        priority = wSeverity;
                    } else if (tok.startsWith("E") && useE) {
                        found = true;
                        priority = eSeverity;
                    } else {
                        if (!tok.startsWith("F") || !useF) continue;
                        found = true;
                        priority = fSeverity;
                    }
                    try {
                        if (!found) continue;
                        line = -1;
                        id = "";
                        if (tok.indexOf(58) == 1) {
                            p = PyLintThread.PYLINT_MATCH_PATTERN;
                            m = p.matcher(tok);
                            if (!m.matches()) continue;
                            line = Integer.parseInt(tok.substring(m.start(1), m.end(1)));
                            id = tok.substring(m.start(4), m.end(4)).trim();
                            tok = tok.substring(m.start(3), m.end(3)).trim();
                        } else {
                            id = tok.substring(0, tok.indexOf(":")).trim();
                            i = tok.indexOf(":");
                            if (i == -1 || (i = (tok = tok.substring(i + 1)).indexOf(":")) == -1) continue;
                            substring = tok.substring(0, i).trim();
                            line = Integer.parseInt((String)StringUtils.split((String)substring, (char)',').get(0));
                            i = tok.indexOf(":");
                            if (i == -1) continue;
                            tok = tok.substring(i + 1);
                        }
                        region = null;
                        try {
                            region = doc.getLineInformation(line - 1);
                        }
                        catch (Exception v0) {
                            region = doc.getLineInformation(line);
                        }
                        lineContents = doc.get(region.getOffset(), region.getLength());
                        pos = -1;
                        pos = lineContents.indexOf("IGNORE:");
                        if (pos != -1 && (lintW = lineContents.substring(pos + "IGNORE:".length())).startsWith(id)) continue;
                        this.addToMarkers(tok, priority, id, line - 1);
                    }
                    catch (RuntimeException e2) {
                        Log.log((Throwable)e2);
                    }
                    continue;
                }
                catch (Exception e1) {
                    Log.log((Throwable)e1);
                }
lbl121:
                // 11 sources

                ** while (tokenizer.hasMoreTokens())
            }
lbl122:
            // 1 sources

        }
    }
}

