/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.VisitorMemo;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;

public abstract class PyDevBuilderVisitor
implements Comparable<PyDevBuilderVisitor> {
    public static final int MAX_TO_VISIT_INFINITE = -1;
    private static final String MODULE_CACHE = "MODULE_CACHE";
    private static final String MODULE_NAME_CACHE = "MODULE_NAME";
    static final String MODULE_IN_PROJECT_PYTHONPATH = "MODULE_IN_PROJECT_PYTHONPATH";
    public static final int PRIORITY_DEFAULT = 5;
    public static final int PRIORITY_MAX = 0;
    public static final int PRIORITY_MIN = 10;
    public VisitorMemo memo;
    public static final String IS_FULL_BUILD = "IS_FULL_BUILD";
    public static final String DOCUMENT_TIME = "DOCUMENT_TIME";

    @Override
    public int compareTo(PyDevBuilderVisitor o) {
        int otherPriority;
        int priority = this.getPriority();
        if (priority < (otherPriority = o.getPriority())) {
            return -1;
        }
        if (otherPriority < priority) {
            return 1;
        }
        return 0;
    }

    protected int getPriority() {
        return 5;
    }

    protected boolean isFullBuild() {
        Boolean b = (Boolean)this.memo.get(IS_FULL_BUILD);
        if (b == null) {
            return false;
        }
        return b;
    }

    protected long getDocumentTime() {
        Long b = (Long)this.memo.get(DOCUMENT_TIME);
        if (b == null) {
            return -1L;
        }
        return b;
    }

    protected SourceModule getSourceModule(IResource resource, IDocument document, IPythonNature nature) throws MisconfigurationException {
        SourceModule module = (SourceModule)this.memo.get(MODULE_CACHE + resource.getModificationStamp());
        if (module == null) {
            module = this.createSoureModule(resource, document, this.getModuleName(resource, nature));
            this.setModuleInCache(resource, module);
        }
        return module;
    }

    protected void setModuleInCache(IResource resource, IModule module) {
        this.memo.put(MODULE_CACHE + resource.getModificationStamp(), module);
    }

    protected SourceModule createSoureModule(IResource resource, IDocument document, String moduleName) throws MisconfigurationException {
        PythonNature nature = PythonNature.getPythonNature(resource.getProject());
        IFile f = (IFile)resource;
        String file = f.getRawLocation().toOSString();
        SourceModule module = AbstractModule.createModuleFromDoc(moduleName, new File(file), document, (IGrammarVersionProvider)nature, true);
        return module;
    }

    protected PythonNature getPythonNature(IResource resource) {
        PythonNature pythonNature = PythonNature.getPythonNature(resource);
        return pythonNature;
    }

    public String getModuleName(IResource resource, IPythonNature nature) throws MisconfigurationException {
        String moduleName = (String)this.memo.get(PyDevBuilderVisitor.getModuleNameCacheKey(resource));
        if (moduleName == null) {
            moduleName = nature.resolveModule(resource);
            if (moduleName != null) {
                PyDevBuilderVisitor.setModuleNameInCache(this.memo, resource, moduleName);
            } else {
                throw new RuntimeException("Unable to resolve module for:" + resource);
            }
        }
        return moduleName;
    }

    private static String getModuleNameCacheKey(IResource resource) {
        return MODULE_NAME_CACHE + resource.getModificationStamp();
    }

    public static void setModuleNameInCache(Map<String, Object> memo, IResource resource, String moduleName) {
        memo.put(PyDevBuilderVisitor.getModuleNameCacheKey(resource), moduleName);
    }

    public boolean isResourceInPythonpathProjectSources(IResource resource, IPythonNature nature, boolean addExternal) throws CoreException, MisconfigurationException {
        Boolean isInProjectPythonpath = (Boolean)this.memo.get(MODULE_IN_PROJECT_PYTHONPATH + addExternal);
        if (isInProjectPythonpath == null) {
            IModulesManager modulesManager;
            ICodeCompletionASTManager astManager;
            List<String> onlyProjectPythonPathLst = this.memo.getOnlyProjectPythonPathStr(nature, addExternal);
            String resourceOSString = PydevPlugin.getIResourceOSString(resource);
            String moduleName = null;
            if (resourceOSString != null && (astManager = nature.getAstManager()) != null && (modulesManager = astManager.getModulesManager()) instanceof ProjectModulesManager) {
                PythonPathHelper pythonPathHelper = ((ProjectModulesManager)modulesManager).getPythonPathHelper();
                moduleName = pythonPathHelper.resolveModule(resourceOSString, false, onlyProjectPythonPathLst, nature.getProject());
            }
            if ((isInProjectPythonpath = Boolean.valueOf(moduleName != null)).booleanValue()) {
                PyDevBuilderVisitor.setModuleNameInCache(this.memo, resource, moduleName);
            }
        }
        return isInProjectPythonpath;
    }

    public static boolean isInPythonPath(IResource resource) {
        ICodeCompletionASTManager astManager;
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        PythonNature nature = PythonNature.getPythonNature(project);
        if (project != null && nature != null && (astManager = nature.getAstManager()) != null) {
            IModulesManager modulesManager = astManager.getModulesManager();
            return modulesManager.isInPythonPath(resource, project);
        }
        return false;
    }

    public int maxResourcesToVisit() {
        return -1;
    }

    public abstract void visitChangedResource(IResource var1, ICallback0<IDocument> var2, IProgressMonitor var3);

    public void visitAddedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitChangedResource(resource, document, monitor);
    }

    public abstract void visitRemovedResource(IResource var1, ICallback0<IDocument> var2, IProgressMonitor var3);

    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
    }

    public void visitingEnded(IProgressMonitor monitor) {
    }
}

