/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.model;

import com.python.pydev.debug.DebugPluginPrefsInitializer;
import com.python.pydev.debug.model.ProcessServerOutputStream;
import com.python.pydev.debug.remote.RemoteDebuggerServer;
import java.io.InputStream;
import java.io.OutputStream;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.PipedInputStream;
import org.python.pydev.shared_core.string.StringUtils;

public class ProcessServer
extends Process {
    private PipedInputStream inputStream;
    private PipedInputStream errorStream;
    private OutputStream outputStream;
    private Object lock;

    public ProcessServer() {
        try {
            this.inputStream = new PipedInputStream();
            this.inputStream.write(StringUtils.format((String)"Debug Server at port: %s\r\n", (Object[])new Object[]{DebugPluginPrefsInitializer.getRemoteDebuggerPort()}).getBytes());
            this.errorStream = new PipedInputStream();
            this.outputStream = new ProcessServerOutputStream();
            this.lock = new Object();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
        return 0;
    }

    @Override
    public int exitValue() {
        throw new IllegalThreadStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        RemoteDebuggerServer.getInstance().dispose();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void writeToStdOut(String str) {
        try {
            PipedInputStream p = this.inputStream;
            if (p != null) {
                p.write(str.getBytes());
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void writeToStdErr(String str) {
        try {
            PipedInputStream p = this.errorStream;
            if (p != null) {
                p.write(str.getBytes());
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

