/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search.replace;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_ui.search.SearchMessages;
import org.python.pydev.shared_ui.search.replace.ReplaceConfigurationPage;
import org.python.pydev.shared_ui.search.replace.ReplaceRefactoring;

public class ReplaceAction
extends Action {
    private final AbstractTextSearchResult fResult;
    private final Object[] fSelection;
    private final boolean fSkipFiltered;
    private final Shell fShell;
    private ICallback<Boolean, Match> fSkipMatch;

    public ReplaceAction(Shell shell, AbstractTextSearchResult result, Object[] selection, boolean skipFiltered) {
        this(shell, result, selection, skipFiltered, null);
    }

    public ReplaceAction(Shell shell, AbstractTextSearchResult result, Object[] selection, boolean skipFiltered, ICallback<Boolean, Match> skipMatch) {
        this.fShell = shell;
        this.fResult = result;
        this.fSelection = selection;
        this.fSkipFiltered = skipFiltered;
        this.fSkipMatch = skipMatch;
    }

    public void run() {
        try {
            ReplaceRefactoring refactoring = new ReplaceRefactoring(this.fResult, this.fSelection, this.fSkipFiltered, this.fSkipMatch);
            ReplaceWizard refactoringWizard = new ReplaceWizard(refactoring);
            if (this.fSelection == null) {
                refactoringWizard.setDefaultPageTitle(SearchMessages.ReplaceAction_title_all);
            } else {
                refactoringWizard.setDefaultPageTitle(SearchMessages.ReplaceAction_title_selected);
            }
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
            op.run(this.fShell, SearchMessages.ReplaceAction_description_operation);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class ReplaceWizard
    extends RefactoringWizard {
        public ReplaceWizard(ReplaceRefactoring refactoring) {
            super((Refactoring)refactoring, 4);
        }

        protected void addUserInputPages() {
            this.addPage((IWizardPage)new ReplaceConfigurationPage((ReplaceRefactoring)this.getRefactoring()));
        }
    }
}

