/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.dialogs.ProjectSelectionDialog;
import org.python.pydev.shared_ui.search.ICustomLineElement;
import org.python.pydev.shared_ui.search.ScopeAndData;
import org.python.pydev.shared_ui.search.SearchIndexData;
import org.python.pydev.shared_ui.search.SearchIndexDataHistory;
import org.python.pydev.shared_ui.search.SearchMessages;

public abstract class AbstractSearchIndexPage
extends DialogPage
implements ISearchPage {
    protected SearchIndexDataHistory searchIndexDataHistory;
    protected Text fPattern;
    protected ISearchPageContainer fContainer;
    protected boolean fFirstTime = true;
    protected Button fIsCaseSensitiveCheckbox;
    protected Button fIsWholeWordCheckbox;
    protected Button fModulesScopeRadio;
    protected Button fWorkspaceScopeRadio;
    protected Button fProjectsScopeRadio;
    protected Text fModuleNames;
    protected Text fProjectNames;
    protected Button fHistory;
    protected Button fSelectProjects;
    protected Button fSelectFolders;

    public AbstractSearchIndexPage(AbstractUIPlugin plugin) {
        this.searchIndexDataHistory = new SearchIndexDataHistory(plugin);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.searchIndexDataHistory.readConfiguration();
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(10, false);
        composite.setLayout((Layout)layout);
        this.createLabel(composite, 16384, "&Text  (* = any string, ? = any character, \\\\ = escape).", 10);
        this.createComponents(composite);
        if (this.fSelectProjects != null && this.fProjectNames != null) {
            this.fSelectProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] result;
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    ProjectSelectionDialog dialog = new ProjectSelectionDialog(activeShell, null, true);
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    String text = AbstractSearchIndexPage.this.fProjectNames.getText();
                    ArrayList<IProject> lst = new ArrayList<IProject>();
                    for (String s : StringUtils.split((String)text, (char)',')) {
                        IProject project = root.getProject(s = s.trim());
                        if (project == null || !project.exists() || !project.isAccessible()) continue;
                        lst.add(project);
                    }
                    dialog.setInitialElementSelections(lst);
                    int open = dialog.open();
                    if (open == 0 && (result = dialog.getResult()) != null) {
                        FastStringBuffer buf = new FastStringBuffer();
                        Object[] objectArray = result;
                        int n = result.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object instanceof IProject) {
                                if (buf.length() > 0) {
                                    buf.append(", ");
                                }
                                buf.append(((IProject)object).getName());
                            }
                            ++n2;
                        }
                        AbstractSearchIndexPage.this.fProjectNames.setText(buf.toString());
                        AbstractSearchIndexPage.this.setRadioSelection(AbstractSearchIndexPage.this.fProjectsScopeRadio);
                    }
                }
            });
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void setRadioSelection(Button bt) {
        Composite parent = bt.getParent();
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (bt != child && child instanceof Button && (child.getStyle() & 0x10) != 0) {
                ((Button)child).setSelection(false);
            }
            ++i;
        }
        bt.setSelection(true);
    }

    protected void createComponents(Composite composite) {
        this.fPattern = this.createText(composite, 2052, 5, 50);
        this.fIsCaseSensitiveCheckbox = this.createButton(composite, 32, SearchMessages.SearchPage_caseSensitive, 5);
        this.createLabel(composite, 0, "", 5);
        this.fIsWholeWordCheckbox = this.createButton(composite, 32, SearchMessages.SearchPage_wholeWord, 5);
        this.createLabel(composite, 16384, "Scope", 1);
        this.fWorkspaceScopeRadio = this.createButton(composite, 16, "&Workspace", 1);
        this.fModulesScopeRadio = this.createButton(composite, 16, "&Module(s)", 1);
        this.fModuleNames = this.createText(composite, 2052, 2, 50);
        this.createLabel(composite, 0, "", 5);
        this.createLabel(composite, 0, "", 1);
        this.fProjectsScopeRadio = this.createButton(composite, 16, "&Project(s)", 1);
        this.fProjectNames = this.createText(composite, 2052, 2, 50);
        this.fSelectProjects = this.createButton(composite, 8, "...", 1);
        ((GridData)this.fSelectProjects.getLayoutData()).widthHint = 25;
        this.createLabel(composite, 16384, "\n\nNote: only modules in the PyDev index will be searched (valid modules below a source folder).", 10);
        this.createLabel(composite, 16384, "Note: wildcards may be used for modules and project matching.", 10);
    }

    protected Text createText(Composite composite, int style, int cols, int charsLen) {
        Text text = new Text(composite, style);
        text.setFont(composite.getFont());
        GridData data = new GridData(4, 4, true, false, cols, 1);
        data.widthHint = this.convertWidthInCharsToPixels(charsLen);
        text.setLayoutData((Object)data);
        return text;
    }

    protected Label createLabel(Composite composite, int style, String string, int cols) {
        Label label = new Label(composite, style);
        label.setText(string);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, cols, 1));
        label.setFont(composite.getFont());
        return label;
    }

    protected Button createButton(Composite composite, int style, String string, int cols) {
        Button bt = new Button(composite, style);
        bt.setText(string);
        bt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        bt.setLayoutData((Object)new GridData(4, 0x1000000, false, false, cols, 1));
        bt.setFont(composite.getFont());
        return bt;
    }

    protected ScopeAndData getScopeAndData() {
        if (this.fModulesScopeRadio.getSelection()) {
            return new ScopeAndData(0, this.fModuleNames.getText());
        }
        if (this.fWorkspaceScopeRadio.getSelection()) {
            return new ScopeAndData(2, "");
        }
        if (this.fProjectsScopeRadio.getSelection()) {
            return new ScopeAndData(1, this.fProjectNames.getText());
        }
        return new ScopeAndData(2, "");
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null && this.fFirstTime) {
            this.fFirstTime = false;
            SearchIndexData last = this.initializeFromLast();
            if (last != null) {
                this.fIsCaseSensitiveCheckbox.setSelection(last.isCaseSensitive);
                this.fIsWholeWordCheckbox.setSelection(last.isWholeWord);
            }
            this.initializeFromSelection(last);
        }
        super.setVisible(visible);
        if (visible && this.fPattern != null) {
            this.fPattern.selectAll();
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
    }

    protected SearchIndexData initializeFromLast() {
        String text;
        SearchIndexData last = this.searchIndexDataHistory.getLast();
        if (last != null && (text = last.textPattern) != null && text.length() > 0) {
            this.fPattern.setText(text);
            return last;
        }
        return null;
    }

    protected void updateOKStatus() {
        this.fContainer.setPerformActionEnabled(true);
    }

    protected void initializeFromSelection(SearchIndexData last) {
        String text;
        boolean regularPath;
        ISelection selection = this.fContainer.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && ((ITextSelection)selection).getLength() > 0 && (regularPath = true) && (text = ((ITextSelection)selection).getText()) != null) {
            this.fPattern.setText(text);
        }
        HashSet<String> projectNames = new HashSet<String>();
        HashSet<String> moduleNames = new HashSet<String>();
        ISelection sel = this.fContainer.getSelection();
        boolean hasNonEditorSelection = true;
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object curr : (IStructuredSelection)sel) {
                IResource resource;
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) continue;
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2 = (IResource)elements[i].getAdapter(IResource.class);
                        this.checkSelectedResource(projectNames, moduleNames, resource2);
                        ++i;
                    }
                    continue;
                }
                if (curr instanceof ICustomLineElement) {
                    resource = ((ICustomLineElement)curr).getParent();
                    this.checkSelectedResource(projectNames, moduleNames, resource);
                    continue;
                }
                if (!(curr instanceof IAdaptable)) continue;
                resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class);
                this.checkSelectedResource(projectNames, moduleNames, resource);
            }
        } else if (this.fContainer.getActiveEditorInput() != null) {
            hasNonEditorSelection = false;
            this.checkSelectedResource(projectNames, moduleNames, (IResource)this.fContainer.getActiveEditorInput().getAdapter(IFile.class));
        }
        this.fModuleNames.setText(StringUtils.join((String)", ", moduleNames));
        this.fProjectNames.setText(StringUtils.join((String)", ", projectNames));
        if (hasNonEditorSelection) {
            if (!moduleNames.isEmpty()) {
                this.fModulesScopeRadio.setSelection(true);
                return;
            }
            if (!projectNames.isEmpty()) {
                this.fProjectsScopeRadio.setSelection(true);
                return;
            }
        }
        if (last != null && this.initializeScopeFromLast(last)) {
            return;
        }
        this.fWorkspaceScopeRadio.setSelection(true);
    }

    private IDocument getDocument(TextSelection tx) {
        try {
            Method method = TextSelection.class.getDeclaredMethod("getDocument", new Class[0]);
            method.setAccessible(true);
            return (IDocument)method.invoke((Object)tx, new Object[0]);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    protected boolean initializeScopeFromLast(SearchIndexData last) {
        int scope = last.scope;
        switch (scope) {
            case 2: {
                this.fWorkspaceScopeRadio.setSelection(true);
                return true;
            }
            case 0: {
                this.fModulesScopeRadio.setSelection(true);
                return true;
            }
            case 1: {
                this.fProjectsScopeRadio.setSelection(true);
                return true;
            }
        }
        return false;
    }

    protected abstract void checkSelectedResource(Collection<String> var1, Collection<String> var2, IResource var3);
}

